<?php

class Report extends Eloquent
{
    protected $table = 'reports';
    public $timestamps = true;

    protected static $rules = [
        'id'      => 'required|numeric|exists:website',
        'email'   => 'required|email',
        'subject' => 'required|max:255',
        'message' => 'max:1000'
    ];

    public static function add($data)
    {
        $validator = Validator::make($data, self::$rules,
        [
            'required'  => DBLang::get('validation_required'),
            'numeric'   => DBLang::get('validation_numeric'),
            'exists'    => DBLang::get('validation_exists'),
            'max'       => DBLang::get('validation_max_string'),
            'email'     => DBLang::get('validation_email')
        ],
        [
            'id'        => 'Website ID',
            'email'     => DBLang::get('email'),
            'subject'   => DBLang::get('subject'),
            'message'   => DBLang::get('your_message')
        ]);

        if ($validator->fails()) {
            return [
                'status' => false,
                'errors' => $validator->errors()->all()
            ];
        }

        $report = new Report;
        $report->site_id = $data['id'];
        $report->site_name = $data['site_name'];
        $report->email = $data['email'];
        $report->subject = $data['subject'];
        $report->message = $data['message'];
        $report->ip_address = $data['ip_address'];
        $report->user_agent = $data['user_agent'];
        $report->status = 0;

        if ($report->save()) {
            return [
                'status'    => true,
                'insert_id' => $report->id
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

}