<?php
use Carbon\Carbon;
class RemoveWebSite extends Eloquent
{

    protected $table = 'remove_website';

    public static function add($data)
    {
        $website = new RemoveWebSite;
        $website->site_id = $data['site_id'];
        $website->site_name = $data['site_name'];
        $website->remove_code = sha1(md5(uniqid() . $data['site_name']));
        $website->ip_address = $data['ip_address'];
        $website->user_agent = $data['user_agent'];

        if($website->save()){
            return true;
        }

        return false;
    }

    public static function verifiedSite($id)
    {

        return self::where('id', $id)->update([
            'status' => 1,
            'deleted_at' => Carbon::now()
        ]);
    }

    public static function getLastRemoveCode($site)
    {
        return self::where(['site_name' => $site, 'status' => 0])->orderBy('id', 'desc')->first();
    }



}
