<?php

class Keyword extends Eloquent
{

    protected $table = 'website_keywords';
    public $timestamps = false;

    public static function add($id, $keywords)
    {
        $data = [];
        foreach($keywords as $keyword){
            $data[] = [
                'site_id' => $id,
                'keyword' => $keyword
            ];
        }

        self::insert($data);
    }

    public static function keywordCount($keyword)
    {
        return self::where('keyword', $keyword)->distinct('site_id')->count();
    }


}
