<?php

class Country extends Eloquent{
    protected $table = 'countries';
    public $timestamps = false;

    public static function getCountryByCode($code)
    {
        return self::where('alpha_2', strtolower($code))->first();
    }

    public static function getCountryBySlug($slug, $remember = 0)
    {
        $country = self::where('slug', strtolower($slug));
        if($remember){
            $country->remember($remember);
        }
        return $country->get()->first();
    }

    public static function getAll()
    {
        return self::all();
    }

    public static function getAllWebSiteCount()
    {
        return self::orderBy('website_count', 'desc')->get();
    }

    public static function getRandomCountries($limit = 10, $remember = 0)
    {

        $randomCountries = self::where('website_count', '>', 0)->orderByRaw("RAND()")->take($limit);
        if($remember) {
            $randomCountries->remember($remember);
        }
        return $randomCountries->get();
    }

    public static function updateWebSiteCount($countryId, $count)
    {
        $country = self::find($countryId);
        $country->website_count = $count;
        $country->save();
    }
}