<?php

class Contact extends Eloquent
{
    protected $table = 'contacts';
    public $timestamps = true;

    protected static $rules = [
        'name'    => 'required|max:100',
        'subject' => 'required|max:255',
        'email'   => 'required|email',
        'message' => 'required|max:1000'
    ];

    public static function add($data)
    {
        $validator = Validator::make($data, self::$rules,
        [
            'required'  => DBLang::get('validation_required'),
            'max'       => DBLang::get('validation_max_string'),
            'email'     => DBLang::get('validation_email')
        ],
        [
            'name'      => DBLang::get('name_lastname'),
            'email'     => DBLang::get('email'),
            'subject'   => DBLang::get('subject'),
            'message'   => DBLang::get('your_message')
        ]);

        if ($validator->fails()) {
            return [
                'status' => false,
                'errors' => $validator->errors()->all()
            ];
        }

        $contact = new Contact;
        $contact->name = $data['name'];
        $contact->email = $data['email'];
        $contact->subject = $data['subject'];
        $contact->message = $data['message'];
        $contact->ip_address = $data['ip_address'];
        $contact->user_agent = $data['user_agent'];
        $contact->status = 0;

        if ($contact->save()) {
            return [
                'status'    => true,
                'insert_id' => $contact->id
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

}