<?php
class CommonModel
{
    public static function getRandomCountries($limit = 12, $remember = 0)
    {
        $randomCountries = [];
        $countries = Country::getRandomCountries($limit, $remember);

        if ($countries) {
            foreach ($countries as $country) {
                $randomCountries[] = [
                    'name'          => $country->name,
                    'short_name'    => $country->alpha_2,
                    'slug'          => $country->slug,
                    'website_count' => $country->website_count
                ];
            }
        }

        return $randomCountries;
    }

    public static function getRecentWebSites($limit = 12, $remember = 0)
    {
        $recentWebSites = [];
        $sites = WebSite::getRecentWebsites($limit, $remember);
        if ($sites) {
            foreach ($sites as $site) {
                if($site->country_code){
                    $recentWebSites[] = [
                        'name'         => $site->name,
                        'country_code' => $site->country_code,
                        'country_name' => $site->country_name,
                        'pagerank'     => $site->google_rank,
                        'alexarank'    => $site->alexa_rank
                    ];
                }
            }
        }
        return $recentWebSites;
    }
}