<?php

class Comment extends Eloquent
{
    protected $table = 'comments';

    protected static $rules = [
        'site_id' => 'required|numeric|exists:website,id',
        'name'    => 'required|max:100',
        'email'   => 'required|email',
        'comment' => 'required|max:1000'
    ];

    public static function add($data)
    {
        $validator = Validator::make($data, self::$rules,
        [
            'required'  => DBLang::get('validation_required'),
            'numeric'   => DBLang::get('validation_numeric'),
            'exists'    => DBLang::get('validation_exists'),
            'max'       => DBLang::get('validation_max_string'),
            'email'     => DBLang::get('validation_email')
        ],
        [
            'name'     => DBLang::get('name_lastname'),
            'email'    => DBLang::get('email'),
            'comment'  => DBLang::get('your_comment')
        ]);

        if($validator->fails()){
            return [
                'status' => false,
                'errors' => $validator->errors()->all()
            ];
        }

        $comment = new Comment;
        $comment->site_id = $data['site_id'];
        $comment->site_name = $data['site_name'];
        $comment->name = $data['name'];
        $comment->email = $data['email'];
        $comment->comment = $data['comment'];
        $comment->ip_address = $data['ip_address'];
        $comment->user_agent = $data['user_agent'];
        $comment->status = 0;

        if($comment->save()){
            return [
                'status' => true,
                'insert_id' => $comment->id
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function getAll($websiteId)
    {
        return self::where([
            'site_id' => $websiteId,
            'status'  => 1
        ])->get()->toArray();
    }
}