<?php
use \Carbon\Carbon;

class LWebsite
{

    public static function get($id)
    {
        return WebSite::where('id', $id)->where('status', '!=', 2)->firstOrFail();
    }

    public static function update($id, $data)
    {

        $update = WebSite::where('id', $id)->update($data);

        if ($update) {
            $response = [
                'status'  => true,
                'message' => 'Update successfuly'
            ];
        } else {
            $response = [
                'status'  => false,
                'message' => 'An error Occured'
            ];
        }

        return $response;
    }

    public static function remove($id)
    {
        $affected = WebSite::where('id', $id)->delete();

        Keyword::where('site_id', $id)->delete();
        Comment::where('site_id', $id)->delete();
        Report::where('site_id', $id)->delete();

        if ($affected) {
            $response = [
                'status'  => true,
                'message' => 'Remove successfuly'
            ];
        } else {
            $response = [
                'status'  => false,
                'message' => 'An error Occured'
            ];
        }

        return $response;
    }

    public static function deletionRequests()
    {
        return RemoveWebSite::get();
    }

    public static function bulkWebsiteCreate($websiteList)
    {
        $createStatus = true;

        foreach ($websiteList as $site) {
            $siteName = get_site_name($site);
            if ($siteName) {
                $website = WebSiteUnIndexed::firstOrNew(['name' => standard_url($site)]);
                $website->name = standard_url($site);
                $website->created_date = Carbon::now()->timestamp;
                $website->status = 0;
                if (!$website->save()) {
                    $createStatus = false;
                }
            }
        }

        if ($createStatus) {
            return [
                'status'    => true
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function getCountryWebsiteCount($countryCode)
    {
        return WebSite::where('country_code', $countryCode)->where('status', 1)->where('publish', 1)->count();
    }

    public static function updateCountryWebsiteCount($websiteCount, $countryCode)
    {
        Country::where('alpha_2', $countryCode)->update(['website_count' => $websiteCount]);
    }

}