<?php

use Carbon\Carbon;
class LStats {

    public static function getTodayUniqueVisitors($siteID){
        $visitData = Analytics::query($siteID, 'today', 'today', 'ga:visits');

        if(isset($visitData->totalsForAllResults['ga:visits']))
            return $visitData->totalsForAllResults['ga:visits'];

        return 0;
    }

    public static function getTodayPageviews($siteID)
    {
        $visitData = Analytics::query($siteID, 'today', 'today', 'ga:pageviews');

        if(isset($visitData->totalsForAllResults['ga:pageviews']))
            return $visitData->totalsForAllResults['ga:pageviews'];

        return 0;
    }

    public static function getTotalVisitors($siteID)
    {
        $visitData = Analytics::query($siteID, '2016-01-01', 'today', 'ga:visitors');

        if(isset($visitData->totalsForAllResults['ga:visitors']))
            return $visitData->totalsForAllResults['ga:visitors'];

        return 0;
    }

    public static function getTotalPageviews($siteID)
    {
        $pageviews = Analytics::query($siteID, '2016-01-01', 'today', 'ga:pageviews');

        if(isset($pageviews->totalsForAllResults['ga:pageviews']))
            return $pageviews->totalsForAllResults['ga:pageviews'];

        return 0;
    }

    public static function getTotalWebsitesCount()
    {
        return WebSite::where('status', 1)->where('publish', 1)->count();
    }

    public static function getTodayAnalyzedWebsitesCount()
    {
        return WebSite::where('status', 1)->where('created_at', '>=', Carbon::today()->startOfDay())->count();
    }



    public static function getLastMonthVisitors($siteID)
    {
        $visitData = Analytics::query($siteID, '30daysAgo', 'today', 'ga:visits', array( 'dimensions' => 'ga:date'));

        if(isset($visitData->rows))
            return $visitData->rows;
        return [];
    }

    public static function getLastMonthPageViews($siteID)
    {
        $pageviewData = Analytics::query($siteID, '30daysAgo', 'today', 'ga:pageviews', array('dimensions' => 'ga:date'));

        if(isset($pageviewData->rows))
            return $pageviewData->rows;
        return [];
    }

    public static function getLastMonthBrowsers($siteID)
    {
        $browserData = Analytics::query($siteID, '30daysAgo', 'today', 'ga:visits', array('dimensions' => 'ga:browser', 'sort'  => '-ga:visits', 'max-results' => 10));

        if(isset($browserData->rows)){
            return array_values($browserData->rows); // Key Reset
        }

        return [];
    }

    public static function getLastMonthOs($siteID)
    {
        $osData = Analytics::query($siteID, '30daysAgo', 'today', 'ga:visits', array('dimensions' => 'ga:operatingSystem', 'sort' => '-ga:visits', 'max-results' => 10));

        if(isset($osData->rows)){
            return array_values($osData->rows); // Key Reset
        }

        return [];
    }

    public static function getLastMonthScreens($siteID)
    {
        $screenData = Analytics::query($siteID, '30daysAgo', 'today', 'ga:visits', array('dimensions' => 'ga:screenResolution', 'sort' => '-ga:visits', 'max-results' => 10));

        if(isset($screenData->rows)){
            return array_values($screenData->rows); // Key Reset
        }

        return [];
    }

    public static function getLastMonthKeywords($siteID)
    {
        $keywordData = Analytics::query($siteID, '30daysAgo', 'today', 'ga:visits', array('dimensions' => 'ga:keyword', 'sort' => '-ga:visits', 'max-results' => 50));

        if(isset($keywordData->rows)){
            return array_values($keywordData->rows); // Key Reset
        }

        return [];
    }

    public static function getLastMonthCities($siteID)
    {
        $cityData = Analytics::query($siteID, '30daysAgo', 'today', 'ga:visits', array('dimensions' => 'ga:city', 'sort' => '-ga:visits', 'max-results' => 50));

        if(isset($cityData->rows)){
            return array_values($cityData->rows); // Key Reset
        }

        return [];
    }

    public static function getLastMonthReferers($siteID)
    {
        $refererData = Analytics::query($siteID, '30daysAgo', 'today', 'ga:visits', array('dimensions' => 'ga:source', 'sort' => '-ga:visits', 'max-results' => 50));

        if(isset($refererData->rows)){
            return array_values($refererData->rows); // Key Reset
        }

        return [];
    }

}