<?php

class LSetting {

    protected static $generalRules = [
        'title'         => 'required|max:200',
        'description'   => 'required|max:400',
        'keywords'      => 'required|max:500',
        'contact_email' => 'required|email|max:100',
        'counter_code'  => 'max:3000'
    ];

    protected static $generalLabels = [
        'title'         => 'Title',
        'description'   => 'Description',
        'keywords'      => 'Keywords',
        'contact_email' => 'Contact Email',
        'counter_code'  => 'Counter Codes'
    ];

    protected static $apiKeyRules = [
        'google_api'        => 'required|max:255',
        'bing_account'      => 'required|max:255'
    ];
    protected static $apiKeyLabels = [
        'google_api'        => 'Google Api Key',
        'bing_account'      => 'Bing Account Key'
    ];

    protected static $mailRules = [
        'smtp_mail_name'        => 'required|max:255',
        'smtp_host'             => 'required|max:255',
        'smtp_port'             => 'required|max:50',
        'smtp_username'         => 'required|max:255',
        'smtp_password'         => 'required|max:100',
        'smtp_secure_socket'    => 'required|max:50'
    ];

    protected static $mailLabels = [
        'smtp_mail_name'        => 'SMTP Mail Name',
        'smtp_host'             => 'SMTP Host',
        'smtp_port'             => 'SMTP Port',
        'smtp_username'         => 'SMTP Username',
        'smtp_password'         => 'SMTP Password',
        'smtp_secure_socket'    => 'SMTP Secure Socket'
    ];

    protected static $sitemapRules = [
        'sitemap_per_page'      => 'required|max:6'
    ];

    protected static $sitemapLabels = [
        'sitemap_per_page'      => 'Website Per Page'
    ];

    protected static $paginationRules = [
        'recently_websites_limit'       => 'required',
        'countries_limit'               => 'required',
        'table_row_limit'               => 'required',
        'link_limit'                    => 'required',
        'website_per_country_page'      => 'required'
    ];

    protected static $paginationLabels = [
        'recently_websites_limit'       => 'Recently Added Websites Limit',
        'countries_limit'               => 'Countries Limit',
        'table_row_limit'               => 'Table Row Limit',
        'link_limit'                    => 'Link Limit (Link Analysis)',
        'website_per_country_page'      => 'Website Per Country Page'
    ];

    public static function generalUpdate($id, $data)
    {
        $validator = Validator::make($data, self::$generalRules, [], self::$generalLabels);

        if ($validator->fails()) {
            return [
                'status' => false,
                'errors' => $validator->errors()->all()
            ];
        }

        $setting = Setting::find($id);
        $setting->site_name = $data['site_name'];
        $setting->title = $data['title'];
        $setting->description = $data['description'];
        $setting->keywords = $data['keywords'];
        $setting->contact_email = $data['contact_email'];
        $setting->counter_code = $data['counter_code'];
        $setting->after_a_website_analysis = $data['after_a_website_analysis'];
        $setting->after_a_website_verifying = $data['after_a_website_verifying'];
        $setting->wap_analyzed_website_link = $data['wap_analyzed_website_link'];

        if ($setting->save()) {
            return [
                'status'    => true
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function socialUpdate($id, $data)
    {
        $setting = Setting::find($id);
        $setting->share_facebook = $data['facebook'];
        $setting->share_twitter = $data['twitter'];
        $setting->share_google_plus = $data['google_plus'];
        $setting->share_delicious = $data['delicious'];
        $setting->share_stumbleupon = $data['stumbleupon'];
        $setting->share_tumblr = $data['tumblr'];
        $setting->share_linkedin = $data['linkedin'];
        $setting->share_pinterest = $data['pinterest'];
        $setting->share_reddit = $data['reddit'];
        $setting->share_digg = $data['digg'];
        $setting->social_facebook_a = $data['facebook_account'];
        $setting->social_twitter_a = $data['twitter_account'];
        $setting->social_google_plus_a = $data['google_plus_account'];
        $setting->social_delicious_a = $data['delicious_account'];
        $setting->social_stumbleupon_a = $data['stumbleupon_account'];
        $setting->social_tumblr_a = $data['tumblr_account'];
        $setting->social_linkedin_a = $data['linkedin_account'];
        $setting->social_pinterest_a = $data['pinterest_account'];
        $setting->social_reddit_a = $data['reddit_account'];
        $setting->social_digg_a = $data['digg_account'];

        if ($setting->save()) {
            return [
                'status'    => true
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function apiKeysUpdate($id, $data)
    {
        $validator = Validator::make($data, self::$apiKeyRules, [], self::$apiKeyLabels);

        if ($validator->fails()) {
            return [
                'status' => false,
                'errors' => $validator->errors()->all()
            ];
        }

        $setting = Setting::find($id);
        $setting->api_google_key = $data['google_api'];
        $setting->api_bing_account = $data['bing_account'];
        $setting->api_google_recaptcha_site_key = $data['google_recaptcha_site'];
        $setting->api_google_recaptcha_secret_key = $data['google_recaptcha_secret'];
        $setting->api_google_analytics_client_id = $data['google_analytics_client_id'];
        $setting->api_google_analytics_service_email = $data['google_analytics_service_email'];
        $setting->api_whois_key = $data['api_whois_key'];
        $setting->api_pagepeeker_status = $data['pagepeeker_api_status'];
        $setting->api_pagepeeker_key = $data['pagepeeker_api'];

        if ($setting->save()) {
            return [
                'status'    => true
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function mailUpdate($data)
    {
        $validator = Validator::make($data, self::$mailRules, [], self::$mailLabels);

        if ($validator->fails()) {
            return [
                'status' => false,
                'errors' => $validator->errors()->all()
            ];
        }

        $setting = Setting::find($data['id']);
        $setting->smtp_mail_name = $data['smtp_mail_name'];
        $setting->smtp_host = $data['smtp_host'];
        $setting->smtp_port = $data['smtp_port'];
        $setting->smtp_username = $data['smtp_username'];
        $setting->smtp_password = $data['smtp_password'];
        $setting->smtp_secure_socket = $data['smtp_secure_socket'];
        $setting->mail_comment_status = $data['mail_comment_status'];
        $setting->mail_contact_status = $data['mail_contact_status'];
        $setting->mail_report_status = $data['mail_report_status'];
        $setting->mail_remove_website_status = $data['mail_remove_website_status'];

        if ($setting->save()) {
            return [
                'status'    => true
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function sitemapUpdate($data)
    {
        $validator = Validator::make($data, self::$sitemapRules, [], self::$sitemapLabels);

        if ($validator->fails()) {
            return [
                'status' => false,
                'errors' => $validator->errors()->all()
            ];
        }

        $setting = Sitemap::find($data['id']);
        $setting->sitemap_per_page = $data['sitemap_per_page'];
        $setting->page_status = $data['page_status'];
        $setting->country_status = $data['country_status'];
        $setting->website_status = $data['website_status'];
        $setting->page_change_frequency = $data['page_change_frequency'];
        $setting->page_priority_level = $data['page_priority_level'];
        $setting->country_change_frequency = $data['country_change_frequency'];
        $setting->country_priority_level = $data['country_priority_level'];
        $setting->website_change_frequency = $data['website_change_frequency'];
        $setting->website_priority_level = $data['website_priority_level'];

        if ($setting->save()) {
            return [
                'status'    => true
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function commentUpdate($data)
    {
        $setting = Setting::find($data['id']);
        $setting->comment_default = $data['comment_default'];
        $setting->comment_disqus = $data['comment_disqus'];
        $setting->comment_disqus_username = $data['comment_disqus_username'];
        $setting->comment_facebook = $data['comment_facebook'];
        $setting->api_facebook_app_id = $data['comment_facebook_app_id'];
        $setting->comment_facebook_limit = $data['comment_facebook_limit'];

        if ($setting->save()) {
            return [
                'status'    => true
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function paginationUpdate($data)
    {
        $validator = Validator::make($data, self::$paginationRules, [], self::$paginationLabels);

        if ($validator->fails()) {
            return [
                'status' => false,
                'errors' => $validator->errors()->all()
            ];
        }

        $setting = Setting::find($data['id']);
        $setting->recently_websites_limit = $data['recently_websites_limit'];
        $setting->countries_limit = $data['countries_limit'];
        $setting->table_row_limit = $data['table_row_limit'];
        $setting->link_limit = $data['link_limit'];
        $setting->website_per_country_page = $data['website_per_country_page'];
        $setting->sidebar_countries_limit = $data['sidebar_countries_limit'];
        $setting->sidebar_analyzed_websites_limit = $data['sidebar_analyzed_websites_limit'];

        if ($setting->save()) {
            return [
                'status'    => true
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function layoutUpdate($id, $data)
    {
        $setting = Style::find($id);
        $setting->header_bgc = $data['header_bgc'];
        $setting->header_link_c = $data['header_link_c'];
        $setting->header_link_hc = $data['header_link_hc'];
        $setting->header_link_hbc = $data['header_link_hbc'];
        $setting->button_bgc = $data['button_bgc'];
        $setting->button_fc = $data['button_fc'];
        $setting->button_bc = $data['button_bc'];
        $setting->button_hbgc = $data['button_hbgc'];
        $setting->button_hfc = $data['button_hfc'];
        $setting->button_hbc = $data['button_hbc'];
        $setting->search_button_bgc = $data['search_button_bgc'];
        $setting->search_button_fc = $data['search_button_fc'];
        $setting->search_button_bc = $data['search_button_bc'];
        $setting->search_button_hbgc = $data['search_button_hbgc'];
        $setting->search_button_hfc = $data['search_button_hfc'];
        $setting->search_button_hbc = $data['search_button_hbc'];
        $setting->module_title_bgc = $data['module_title_bgc'];
        $setting->module_title_fc = $data['module_title_fc'];
        $setting->footer_bgc = $data['footer_bgc'];
        $setting->footer_tbgc = $data['footer_tbgc'];
        $setting->footer_fc = $data['footer_fc'];
        $setting->fixed_menu_bgc = $data['fixed_menu_bgc'];
        $setting->fixed_menu_lc = $data['fixed_menu_lc'];
        $setting->fixed_menu_lhc = $data['fixed_menu_lhc'];
        $setting->fixed_menu_lhbc = $data['fixed_menu_lhbc'];
        $setting->fixed_menu_bbc = $data['fixed_menu_bbc'];
        $setting->module_bc = $data['module_bc'];
        $setting->module_bhc = $data['module_bhc'];
        $setting->module_shc = $data['module_shc'];
        $setting->module_subtitle_bgc = $data['module_subtitle_bgc'];
        $setting->module_subtitle_fc = $data['module_subtitle_fc'];

        if ($setting->save()) {
            return [
                'status'    => true
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function cacheUpdate($id, $data)
    {
        $setting = Setting::find($id);
        $setting->cache_hp_s = $data['cache_hp_s'];
        $setting->cache_wap_s = $data['cache_wap_s'];
        $setting->cache_ctp_s = $data['cache_ctp_s'];
        $setting->cache_p_s = $data['cache_p_s'];
        $setting->cache_s_s = $data['cache_s_s'];
        $setting->cache_hp_et = $data['cache_hp_et'];
        $setting->cache_wap_et = $data['cache_wap_et'];
        $setting->cache_ctp_et = $data['cache_ctp_et'];
        $setting->cache_p_et = $data['cache_p_et'];
        $setting->cache_s_et = $data['cache_s_et'];

        if ($setting->save()) {
            return [
                'status'    => true
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function adsUpdate($id, $data)
    {
        $setting = Setting::find($id);
        $setting->ads_sidebar_top_status = $data['ads_sidebar_top_status'];
        $setting->ads_sidebar_bottom_status = $data['ads_sidebar_bottom_status'];
        $setting->ads_wtp_header_status = $data['ads_wtp_header_status'];
        $setting->ads_wtp_comments_status = $data['ads_wtp_comments_status'];
        $setting->ads_wtp_fb_comments_status = $data['ads_wtp_fb_comments_status'];
        $setting->ads_ap_header_status = $data['ads_ap_header_status'];
        $setting->ads_cp_status = $data['ads_cp_status'];
        $setting->ads_sidebar_top_code = $data['ads_sidebar_top_code'];
        $setting->ads_sidebar_bottom_code = $data['ads_sidebar_bottom_code'];
        $setting->ads_wtp_header_code = $data['ads_wtp_header_code'];
        $setting->ads_wtp_comments_code = $data['ads_wtp_comments_code'];
        $setting->ads_wtp_fb_comments_code = $data['ads_wtp_fb_comments_code'];
        $setting->ads_ap_header_code = $data['ads_ap_header_code'];
        $setting->ads_cp_code = $data['ads_cp_code'];

        if ($setting->save()) {
            return [
                'status'    => true
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function logoUpdate($imageName)
    {
        $setting = Style::find(1);
        $setting->site_logo = $imageName;

        if ($setting->save()) {
            return [
                'status'    => true
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function faviconUpdate($imageName)
    {
        $setting = Style::find(1);
        $setting->site_favicon = $imageName;

        if ($setting->save()) {
            return [
                'status'    => true
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function mainbackgroundUpdate($imageName)
    {
        $setting = Style::find(1);
        $setting->site_main_background = $imageName;

        if ($setting->save()) {
            return [
                'status'    => true
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function analyticsFileUpdate($fileName)
    {
        $setting = Setting::find(1);
        $setting->api_google_analytics_file = $fileName;

        if ($setting->save()) {
            return [
                'status'    => true
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function getSettings() // Update Datas
    {
        return Setting::find(1);
    }

    public static function getApiKeys() // Update Datas
    {
        return ApiKey::find(1);
    }

    public static function getSitemapSettings() // Update Datas
    {
        return Sitemap::find(1);
    }

    public static function getLayoutSettings() // Update Datas
    {
        return Style::find(1);
    }

}