<?php

class LPage {

    public static function rules()
    {
        $rules = [];
        foreach (LLanguage::getActiveLangs() as $lang) {
            $rules['page_title['.$lang->short.']'] = 'required|max:255';
        }

        return $rules;
    }

    public static function labels()
    {
        $labels = [];
        foreach (LLanguage::getActiveLangs() as $lang) {
            $labels['page_title['.$lang->short.']'] = 'Page Title(' . $lang->short .')';
        }

        return $labels;
    }

    public static function create($data)
    {
        $validator = Validator::make($data, self::rules(), [], self::labels());

        if ($validator->fails()) {
            return [
                'status' => false,
                'errors' => $validator->errors()->all()
            ];
        }

        $page = new Page;

        $page_title = [];
        $title = [];
        $description = [];
        $keywords = [];
        $content = [];

        foreach (LLanguage::getActiveLangs() as $lang) {
            $page_title[$lang->short] = $data['page_title['.$lang->short.']'];
            $title[$lang->short] = $data['title['.$lang->short.']'];
            $description[$lang->short] = $data['description['.$lang->short.']'];
            $keywords[$lang->short] = $data['keywords['.$lang->short.']'];
            $content[$lang->short] = $data['content['.$lang->short.']'];
        }

        $page->page_title = json_encode($page_title);
        $page->title = json_encode($title);
        $page->description = json_encode($description);
        $page->keywords = json_encode($keywords);
        $page->content = json_encode($content);
        $page->slug = $data['slug'];
        $page->status = $data['status'];

        if ($page->save()) {
            return [
                'status'    => true,
                'insert_id' => $page->id,
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function update($id, $data)
    {
        $validator = Validator::make($data, self::rules(), [], self::labels());

        if ($validator->fails()) {
            return [
                'status' => false,
                'errors' => $validator->errors()->all()
            ];
        }

        $page = Page::find($id);

        $page_title = [];
        $title = [];
        $description = [];
        $keywords = [];
        $content = [];

        foreach (LLanguage::getActiveLangs() as $lang) {
            $page_title[$lang->short] = $data['page_title['.$lang->short.']'];
            $title[$lang->short] = $data['title['.$lang->short.']'];
            $description[$lang->short] = $data['description['.$lang->short.']'];
            $keywords[$lang->short] = $data['keywords['.$lang->short.']'];
            $content[$lang->short] = $data['content['.$lang->short.']'];
        }

        $page->page_title = json_encode($page_title);
        $page->title = json_encode($title);
        $page->description = json_encode($description);
        $page->keywords = json_encode($keywords);
        $page->content = json_encode($content);

        $page->slug = $data['slug'];
        $page->status = $data['status'];

        if ($page->save()) {
            return [
                'status'    => true,
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function remove($id)
    {
        $page = Page::find($id);
        $page->status = -1;

        if ($page->save()) {
            return [
                'status'    => true,
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function get($id)
    {
        return Page::where('id', $id)->where('status', '!=', -1)->firstOrFail();;
    }

}