<?php

class LLanguage
{

    public static function all()
    {
        return Language::get();
    }

    public static function getActiveLangs()
    {
        return Language::where('status', 1)->orderBy('default_lang', 'desc')->get();
    }

    public static function setDefaultLang($id)
    {
        Language::where('default_lang', 1)->where('status', 1)->update(array('default_lang' => 0));
        Language::where('id', $id)->where('status', 1)->update(array('default_lang' => 1));
        return true;
    }

    public static function keys()
    {
        return LanguageKey::get();
    }

    public static function create($languageID, $langData)
    {
        $response = ['status' => false, 'message' => '', 'errors' => []];

        if (self::isExists($languageID)) {
            $response['errors'][] = 'Language is already use';
        } else {

            $data = [
                'lang_id'    => $languageID,
                'lang_data'   => json_encode($langData),
            ];

            if (LanguageTranslation::insert($data)) {

                $language = Language::find($languageID);
                $language->status = 1;
                $language->save();

                $response['status'] = true;
                $response['message'] = 'Successfuly Added';
            } else {
                $response['errors'][] = 'Error an Ocurred';
            }
        }

        return $response;
    }

    public static function update($languageID, $langData)
    {
        $response = ['status' => false, 'message' => '', 'errors' => []];

        $update = LanguageTranslation::where('lang_id', $languageID)->update(array('lang_data' => json_encode($langData)));

        if ($update) {
            $response['status'] = true;
            $response['message'] = 'Successfuly Updated';
        } else {
            $response['errors'][] = 'Error an Ocurred';
        }

        return $response;
    }

    private static function isExists($languageID)
    {
        return Language::where('status', 1)->where('id', $languageID)->count();
    }

    public static function remove($id)
    {
        $language = Language::find($id);

        if($language->default_lang){
            return [
                'status'    => false,
                'message' => 'The default language can not be deleted'
            ];
        }

        $language->status = 0;

        if ($language->save()) {

            LanguageTranslation::where('lang_id', $id)->delete();

            return [
                'status'    => true,
                'message' => 'Remove successfuly'
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function getTranslations($languageID)
    {
        $langData = LanguageTranslation::where('lang_id', $languageID)->firstOrFail();

        return json_decode($langData->lang_data, true);
    }

    public static function getDefaultLang()
    {
        return Language::where('status', 1)->where('default_lang', 1)->first();
    }



}