<?php

class LAdministrator {

    protected static $rules = [
        'username'              => 'required|max:255|unique:administrators',
        'password'              => 'required|alpha_num|between:4,12|confirmed',
        'password_confirmation' => 'required|alpha_num|between:4,12',
        'email'                 => 'required|email|max:50|unique:administrators,email,NULL,id,status,0,status,1'
    ];


    public static function updateRules($id)
    {
        return [
            'username'              => 'required|max:255|unique:administrators,username,' . $id,
            'password'              => 'alpha_num|between:4,12|confirmed',
            'password_confirmation' => 'alpha_num|between:4,12',
            'email'                 => 'required|email|max:50|unique:administrators,email,' . $id . ',id,status,0,status,1'
        ];
    }

    protected static $labels = [
        'username'              => 'Username',
        'password'              => 'Password',
        'password_confirmation' => 'Password Again',
        'email'                 => 'E-Mail'
    ];

    public static function create($data)
    {
        $validator = Validator::make($data, self::$rules, [], self::$labels);

        if ($validator->fails()) {
            return [
                'status' => false,
                'errors' => $validator->errors()->all()
            ];
        }

        $administrator = new Administrator;
        $administrator->username = $data['username'];
        $administrator->password = Hash::make($data['password']);
        $administrator->email = $data['email'];
        $administrator->status = $data['status'];

        if ($administrator->save()) {
            return [
                'status'    => true,
                'insert_id' => $administrator->id
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function update($id, $data)
    {
        $administrator = Administrator::find($id);

        $validator = Validator::make($data, self::updateRules($administrator->id), [], self::$labels);

        if ($validator->fails()) {
            return [
                'status' => false,
                'errors' => $validator->errors()->all()
            ];
        }

        $administrator->username = $data['username'];
        if ($data['password'] != '') {
            $administrator->password = Hash::make($data['password']);
        }
        $administrator->email = $data['email'];
        $administrator->status = $data['status'];

        if ($administrator->save()) {
            return [
                'status'    => true
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function remove($id)
    {
        $administrator = Administrator::find($id);
        $administrator->status = -1;

        if ($administrator->save()) {
            return [
                'status'    => true,
                'message' => 'Remove successfuly'
            ];
        }

        return [
            'status' => false,
            'errors' => 'Error an Ocurred'
        ];
    }

    public static function get($id) // Update Datas
    {
        return Administrator::where('id', $id)->where('status', '!=', -1)->firstOrFail();
    }

}