<?php

class DBLang{

    public static function setLanguage($lang = '')
    {
        if($lang){
           $language = Language::where('short', $lang)->where('status', 1)->first()->toArray();
        }else{
           $language = Language::where('default_lang', 1)->where('status', 1)->first()->toArray();
        }

        Session::set('lang', $language);

        return true;
    }


    public static function get($key = '', $params = array())
    {

        $translationsData = LanguageTranslation::remember(30)->where('lang_id', Session::get('lang')['id'])->first();

        $translations = json_decode($translationsData->lang_data, true);

        if(array_key_exists($key, $translations)){
            if($params){
                $translation = $translations[$key]['text'];
                foreach($params as $key => $param){
                    $translation = str_replace(':'.$key, $param, $translation);
                }
                return $translation;
            }else{
                return $translations[$key]['text'];
            }
        }

        return $key;
    }

    public static function languages()
    {
        return Language::where('status', 1)->get()->toArray();
    }

    public static function currentLanguage()
    {
        return Language::where('status', 1)->where('id', Session::get('lang_id'))->first()->toArray();
    }
}