<?php

class SocialService
{

    private $protocol;
    private $site;

    private $socialData = [
        'fb_total_count' => -1,
        'fb_share_count' => -1,
        'fb_like_count' => -1,
        'fb_comment_count' => -1,
        'fb_comment_box_count' => -1,
        'fb_click_count' => -1,
        //'twitter_share_count' => -1,
        'linkedin_share_count' => -1,
        'pinterest_share_count' => -1
    ];

    public function __construct($protocol, $site)
    {
        $this->protocol = $protocol;
        $this->site = $site;
    }

    public function get()
    {
        $this->getFacebookStat();
        //$this->getTwitterShareCount();
        $this->getLinkedInShareCount();
        $this->getPinterestShareCount();
        //$this->getStumbleuponCount();

        return $this->socialData;
    }

    public function getFacebookStat()
    {
        $fql     = sprintf('SELECT total_count, share_count, like_count, comment_count, commentsbox_count, click_count FROM link_stat WHERE url="%s"', $this->protocol . '://' . $this->site);
        $dataUrl = sprintf('https://api.facebook.com/method/fql.query?query=%s&format=json', rawurlencode($fql));

        $fbDataSource = file_get_contents_curl($dataUrl);

        if(! $fbDataSource){
            return false;
        }

        $fbData = json_decode($fbDataSource, true);

        if( !$fbData){
            return false;
        }

        $this->socialData['fb_total_count'] = $fbData[0]['total_count'];
        $this->socialData['fb_share_count'] = $fbData[0]['share_count'];
        $this->socialData['fb_like_count'] = $fbData[0]['like_count'];
        $this->socialData['fb_comment_count'] = $fbData[0]['comment_count'];
        $this->socialData['fb_comment_box_count'] = $fbData[0]['commentsbox_count'];
        $this->socialData['fb_click_count'] = $fbData[0]['click_count'];

    }

    public function getTwitterShareCount()
    {
        $dataUrl = sprintf('http://cdn.api.twitter.com/1/urls/count.json?url=%s', urlencode($this->protocol . '://' . $this->site));

        $twitterSource = file_get_contents_curl($dataUrl);

        if(! $twitterSource){
            return false;
        }

        $apiResponse = json_decode(file_get_contents($dataUrl));

        if($apiResponse){
            $this->socialData['twitter_share_count'] = $apiResponse->count;
        }
    }

    public function getLinkedInShareCount()
    {
        $dataUrl = sprintf('http://www.linkedin.com/countserv/count/share?url=%s&callback=_', urlencode($this->site));

        $linkedinSource = file_get_contents_curl($dataUrl);

        if(! $linkedinSource){
            return false;
        }

        $apiResponse = str_replace(['_(', ');', ')'], ['', '', ''], $linkedinSource);
        $apiResponse = json_decode($apiResponse);

        if($apiResponse){
            $this->socialData['linkedin_share_count'] = $apiResponse->count;
        }
    }

    public function getPinterestShareCount()
    {
        $dataUrl = sprintf('http://api.pinterest.com/v1/urls/count.json?url=%s&callback=_', urlencode($this->protocol .'://' . $this->site));

        $pinterestSource = file_get_contents_curl($dataUrl);

        if(! $pinterestSource){
            return false;
        }

        $apiResponse = str_replace(['_(', ');', ')'], ['', '', ''], $pinterestSource);
        $apiResponse = json_decode($apiResponse);

        if($apiResponse && isset($apiResponse->count)){
            $this->socialData['pinterest_share_count'] = $apiResponse->count;
        }
    }
/*
    public function getStumbleuponCount()
    {
        $dataUrl = sprintf('http://www.stumbleupon.com/services/1.01/badge.getinfo?url=%s', $this->site);
        $apiResponse = json_decode(file_get_contents($dataUrl));

        if($apiResponse->success == 1){
            if(isset($apiResponse->result->views)){
                $this->socialData['stumbleupon_count'] = $apiResponse->result->views;
            }
        }
    }
*/
/*
    public function getGooglePlusCount()
    {
        $body = '[{
                    "method":"pos.plusones.get",
                    "id":"p",
                    "params":{
                        "nolog":true,
                        "id":"http://stylehatch.co/",
                        "source":"widget",
                        "userId":"@viewer",
                        "groupId":"@self"
                        },
                    "jsonrpc":"2.0",
                    "key":"p",
                    "apiVersion":"v1"
                }]';
        return curl_post( Config::get('app.google_plus_count_url'), $body, 'application/json');
    }
*/
}