<?php

class SearchService{

    private $searchCountry;

    public function __construct(SearchModelCountry $searchModelCountry)
    {
        $this->search = $searchModelCountry;
    }

    public static function getRandomCountries($limit = 12)
    {
        $randomCountries = [];
        $countries = self::$searchCountry->searchRandomCountries()->paginate(0, $limit)->execute();
        if ($countries) {
            foreach ($countries as $country) {
                $countryGetter = new CountryGetter($country['_source']);

                $randomCountries[] = [
                    'name'          => $countryGetter->getName(),
                    'short_name'    => $countryGetter->getShortName(),
                    'slug'          => $countryGetter->getSlug(),
                    'website_count' => $countryGetter->getWebSiteCount()
                ];
            }
        }

        return $randomCountries;
    }



}