<?php
use \Bing\Client;

class BingService
{

    private $site;
    private $apiKey;
    private $bingData = [
        'bing_index_count'    => 0,
        'bing_image_count'    => 0
    ];

    public function __construct($site, $apiKey)
    {
        $this->site = $site;
        $this->apiKey = $apiKey;
    }

    public function get()
    {
        $c = new Client($this->apiKey, 'json');

        $res = $c->get('Composite', array('Sources' => "'web+image'", 'Query' => 'site:' . $this->site));

        if(! $res){
            return $this->bingData;
        }

        $res = json_decode($res, true);

        if ($res) {
            $this->bingData['bing_index_count'] = $res['d']['results'][0]['WebTotal'];
            $this->bingData['bing_image_count'] = $res['d']['results'][0]['ImageTotal'];
        }

        return $this->bingData;
    }

}