<?php


function file_get_contents_curl($url)
{
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    $data = curl_exec($ch);
    curl_close($ch);

    return $data;
}

function curl_post($url, $body, $content_type = 'text/plain')
{

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: ' . $content_type));
    $result = curl_exec($ch);
    curl_close($ch);

    return $result;
}

function strtoupper_tr($deger)
{
    $deger = str_replace("ç", "Ç", $deger);
    $deger = str_replace("ğ", "Ğ", $deger);
    $deger = str_replace("ı", "I", $deger);
    $deger = str_replace("i", "İ", $deger);
    $deger = str_replace("ö", "Ö", $deger);
    $deger = str_replace("ü", "Ü", $deger);
    $deger = str_replace("ş", "Ş", $deger);

    $deger = strtoupper($deger);
    $deger = trim($deger);

    return $deger;
}

function strtolower_tr($deger)
{
    $deger = str_replace("Ç", "ç", $deger);
    $deger = str_replace("Ğ", "ğ", $deger);
    $deger = str_replace("I", "ı", $deger);
    $deger = str_replace("İ", "i", $deger);
    $deger = str_replace("Ö", "ö", $deger);
    $deger = str_replace("Ü", "ü", $deger);
    $deger = str_replace("Ş", "ş", $deger);

    $deger = strtolower($deger);
    $deger = trim($deger);

    return $deger;
}

function ucfirst_tr($text)
{
    $text = strtolower_tr($text);
    $text_first = strtoupper_tr(substr($text, 0, 1));
    $text_other = substr($text, 1, 99999);

    return trim($text_first . $text_other);

}

function standard_number($number)
{
    return number_format($number, 0, '', '.');
}

function format_bytes($bytes, $precision = 1)
{
    if($bytes > 1024){
        $exp = floor(log($bytes, 1024)) | 0;
        return round($bytes / (pow(1024, $exp)), $precision);
    }
    else{
        $kb = $bytes / 1024;
        $kb = number_format($kb, 2);
        $kb = str_replace('.00', '', $kb);

        return $kb;
    }
}

function get_gravatar($email, $s = 80, $d = 'mm', $r = 'g', $img = false, $atts = array())
{
    $url = 'https://www.gravatar.com/avatar/';
    $url .= md5(strtolower(trim($email)));
    $url .= "?s=$s&d=$d&r=$r";
    if ($img) {
        $url = '<img src="' . $url . '"';
        foreach ($atts as $key => $val)
            $url .= ' ' . $key . '="' . $val . '"';
        $url .= ' />';
    }

    return $url;
}


function elapsed_time($timestamp, $reverse = false)
{

    if ($timestamp <= 0) {
        return 'n/a';
    }

    if ($reverse) {
        $time = $timestamp - time();
    } else {
        $time = time() - $timestamp;
    }

    $years = floor($time / 31556926);
    $months = floor(($time % 31556926) / 2592000);
    $days = floor(($time % 31556926) / 86400);
    $days = $days - ($months * 30);

    $times = [];
    if ($years) {
        if ($years == "1") {
            $times[] = "1 year";
        } else {
            $times[] = $years . " years";
        }
    }
    if ($months) {
        if ($months == "1") {
            $times[] = "1 month";
        } else {
            $times[] = $months . " months";
        }
    }
    if ($days) {
        if ($days == "1") {
            $times[] = "1 day";
        } else {
            $times[] = $days . " days";
        }
    }

    if(! $times){
        $times[] = "a few hours";
    }

    return implode(', ', $times);

}


function create_site_hash($site)
{
    return sha1(md5($site . uniqid('hepoon')));
}

function get_site_name($url)
{
    //preg_match('/^(?:https?:\/\/)?(?:www\.)?((?:[a-z0-9\.])+\.(?:com|net|org|info)).*?/', $url, $matched);
    preg_match('/^(?:https?:\/\/)?(?:www\.)?(?P<clean_domain>[a-z0-9-\.]+(?<!www)(?:\.[a-z]{2,}))\/?/', $url, $matched);

    if ($matched) {
        return $matched['clean_domain'];
    }

    return false;
}

function get_web_page($protocol, $site)
{

    $options = [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HEADER         => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_ENCODING       => "",
        CURLOPT_USERAGENT      => "YahooSeeker-Testing/v3.9 (compatible; Mozilla 4.0; MSIE 5.5; Yahoo! Search - Web Search)",
        CURLOPT_REFERER        => 'http://www.google.com',
        CURLOPT_CONNECTTIMEOUT => 30,
        CURLOPT_TIMEOUT        => 30,
        CURLOPT_MAXREDIRS      => 2,
    ];

    $ch = curl_init($protocol . '://' . $site);
    curl_setopt_array($ch, $options);
    $source = curl_exec($ch);
    $header = curl_getinfo($ch);
    curl_close($ch);

    return [
        'header' => $header,
        'source' => $source
    ];
}

function array_group($arr)
{
    $tmp = [];
    if($arr){
        foreach($arr as $val){
            if(array_key_exists($val, $tmp)){
                $tmp[$val] = $tmp[$val]+1;
            }else{
                $tmp[$val] = 1;
            }
        }
    }
    return $tmp;
}

function favicon_url($slug)
{
    //return route('favicon', [$slug]);
    return 'https://s2.googleusercontent.com/s2/favicons?domain_url=' . $slug;
}

function firstUpperCase($text){
    if(substr($text, 0, 5) == 'http:' || substr($text, 0, 4) == 'www.'){
        return strtolower_tr($text);
    }
    return ucfirst_tr($text);
}

function is_rtl( $string ) {
    $rtl_chars_pattern = '/[\x{0590}-\x{05ff}\x{0600}-\x{06ff}]/u';
    return preg_match($rtl_chars_pattern, $string);
}

function ipLookup($ip)
{
    $jsonData = file_get_contents_curl('http://ip-api.com/json/' . $ip);

    if (!$jsonData) {
        return false;
    }

    $data = json_decode($jsonData, true);

    if (!$data) {
        return false;
    }

    if($data['status'] == 'success'){
        return $data;
    }

    return false;
}


function standard_url($url)
{
    if (!preg_match('#^http(s)?://#', $url)) {
        $url = 'http://' . $url;
    }

    $urlParts = parse_url($url);

    // Remove www
    $domain = preg_replace('/^www\./', '', $urlParts['host']);

    return $domain;
}


function myfunction($v1,$v2)
{
    return strtolower_tr($v1) === strtolower_tr($v2) ? 0 : 1;
}

function censor($string)
{
    $filters = json_decode(@file_get_contents(storage_path('filters.txt')), true);

    $string = str_ireplace(array_keys($filters), $filters, $string);

    return $string;
}

function get_protocol($url){
    if(substr($url, 0, 5) == 'https'){
        return 'https';
    }else{
        return 'http';
    }
}