<?php

class WordFilterControllerAjax extends AdminController {

    private $json;
    public function __construct()
    {
        $this->json = [
            'status'  => false,
            'message' => ''
        ];
    }

    public function get()
    {

        $filterWords = FilterWord::select(array('filter_words.id', 'filter_words.word'))->where('filter_words.status', '=', 1);

        return Datatables::of($filterWords)
            ->set_index_column('id')
            ->filter_column('filter_words.word', 'where', 'filter_words.word', 'LIKE', '$1')
            ->add_column('Options', '<a href="{{ route( \'ajax.remove.filter.word\', array( $id )) }}" class="btn remove-filter-word btn-danger btn-xs">Remove</a>')
            ->make();
    }

    public function create()
    {
        $data = [
            'filter_words'  => Input::get('filter_words')
        ];

        $response = LWordFilter::create($data);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Successfully added...';
            $this->json['url'] = route('word.filter.all');
        } else {
            $this->json['message'] = $response['errors'];
        }
        return $this->send();
    }

    public function remove($id)
    {
        $response = LWordFilter::remove($id);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Deleted successfully...';
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();
    }

    private function send()
    {
        return json_encode($this->json);
    }

}