<?php

class WebsiteControllerAjax extends AdminController
{

    private $json;

    public function __construct()
    {
        $this->json = [
            'status'  => false,
            'message' => ''
        ];
    }

    public function get()
    {
        $websites = WebSite::select(array('website.id', 'website.name', 'website.country_name', 'website.ip_address', 'website.created_at', 'website.status', 'website.publish'))->where('status', '!=', 2);

        return Datatables::of($websites)
            ->set_index_column('id')
            ->filter_column('website.name','where','website.name','LIKE','$1')
            ->edit_column('status', '{{ $status ? \'<span class="label label-success">Analyzed</span>\' : \'<span class="label label-warning">Not Analyzed</span>\' }}')
            ->edit_column('publish', '{{ $publish ? \'<span class="label label-success">Active</span>\' : \'<span class="label label-warning">Passive</span>\' }}')
            ->add_column('Options', '<a href="{{ route( \'website-edit\', array( $id )) }}" class="btn btn-primary btn-xs">Edit</a> <a href="{{ route( \'ajax.remove.website\', array( $id )) }}" class="btn remove-website btn-danger btn-xs">Remove</a>')
            ->make();
    }

    public function deletionRequests()
    {
        $websites = RemoveWebSite::select(array('id', 'site_name', 'remove_type', 'ip_address', 'created_at', 'updated_at', 'status', 'site_id'));

        return Datatables::of($websites)
            ->set_index_column('id')
            ->filter_column('site_name','where','site_name','LIKE','$1')
            ->edit_column('remove_type', '{{ $remove_type ? \'File Upload\' : \'Meta Tag\' }}')
            ->edit_column('status', '{{ $status ? \'<span class="label label-success">Verified</span>\' : \'<span class="label label-warning">Pending</span>\' }}')
            ->edit_column('Options', '<a href="{{ route( \'ajax.remove.website\', array( $site_id )) }}" class="btn remove-website btn-danger btn-xs">Remove Website</a>')
            ->remove_column('site_id')
            ->make();
    }

    public function update($id)
    {
        (Input::get('publish') == '') ? $publish = 0 : $publish = 1;

        $data = [
            'site_title'       => Input::get('title'),
            'site_keywords'    => Input::get('keywords'),
            'site_description' => Input::get('description'),
            'ip_address'       => Input::get('ip'),
            'publish'          => $publish
        ];

        if(Input::has('country')){
            $country = LCountry::get(Input::get('country'));
            if(isset($country->id)){
                $data['country_name'] = $country->name;
                $data['country_code'] = $country->alpha_2;
            }
        }

        $edit = LWebsite::update($id, $data);

        if($edit['status']){
            $this->json['status'] = true;

            $website = LWebsite::get($id);
            $websiteCount = LWebsite::getCountryWebsiteCount($website->country_code);
            LWebsite::updateCountryWebsiteCount($websiteCount, $website->country_code);
        }
        $this->json['message'] = $edit['message'];
        return $this->send();
    }

    public function remove($id)
    {
        $website = LWebsite::get($id);
        $remove = LWebsite::remove($id);

        if($remove['status']){
            $websiteCount = LWebsite::getCountryWebsiteCount($website->country_code);
            LWebsite::updateCountryWebsiteCount($websiteCount, $website->country_code);

            $this->json['status'] = true;
        }
        $this->json['message'] = $remove['message'];
        return $this->send();
    }

    public function bulkWebsiteCreate()
    {
        $websiteList = trim(Input::get('website_list'));
        $websiteList = explode("\n", $websiteList);
        $websiteList = array_map('trim', $websiteList);

        $validator = Validator::make(Input::all(), array(
            'website_list' => 'required'
        ));

        if ($validator->fails()) {
            $this->json['message'] = $validator->errors()->all();
            return $this->send();
        }

        $response = LWebsite::bulkWebsiteCreate($websiteList);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Successfully uploaded...';
        } else {
            $this->json['message'] = $response['errors'];
        }
        return $this->send();
    }

    public function removeScreenshot($ss)
    {
        $path = public_path() . '/screenshots/'. $ss . '.png';
        if (File::exists($path)) {
            if (File::delete($path)){
                $this->json['status'] = true;
                $this->json['message'] = 'Deleted successfully...';
                $this->json['default_screenshot'] = asset('img/default-screenshot.png');
            }
        } else {
            $this->json['message'] = ['Error'];
        }
        return $this->send();
    }

    private function send()
    {
        return json_encode($this->json);
    }

}