<?php

class UploadControllerAjax extends AdminController {

    private $json;

    public function __construct()
    {
        $this->json = [
            'status'  => false,
            'message' => ''
        ];
    }

    public function imageUpload()
    {
        $data = array('image' => Input::file('image'));

        $rules = array(
            'image' => 'mimes:jpg,jpeg,bmp,png'
        );

        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            return Response::json([
                'success' => false,
                'message' => $validator->errors()->all()
            ]);
        } else {
            $extension = $data['image']->getClientOriginalExtension();
            $imageName = Str::slug(substr($data['image']->getClientOriginalName(), 0, -4));
            $newImageName = $imageName . '-' . rand(11111, 99999) . '.' . $extension;
            $path = 'img/';

            if (Input::get('image_type') == 1) { // Image Type 1 = Site Logo
                $response = LSetting::logoUpdate($newImageName);
            } else if (Input::get('image_type') == 2) { // Image Type 2 = Site Favicon
                $response = LSetting::faviconUpdate($newImageName);
            } else if (Input::get('image_type') == 3) { // Image Type 3 = Site Main Background
                $response = LSetting::mainbackgroundUpdate($newImageName);
            }

            $upload_success = $data['image']->move($path, $newImageName); // uploading file to given path

            if ($upload_success && $response) {
                return Response::json([
                    'success' => true,
                    'message' => 'Successfully...',
                    'image'   => asset($path.$newImageName)
                ]);
            } else {
                return Response::json([
                    'success' => false,
                    'message' => 'Error'
                ]);
            }

        }

    }

    public function fileUpload()
    {
        $data = array('file' => Input::file('file'));

        $rules = array(
            'file' => 'max:1000'
        );

        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            return Response::json([
                'success' => false,
                'message' => $validator->errors()->all()
            ]);
        } else {
            $extension = $data['file']->getClientOriginalExtension();
            $fileName = Str::slug(substr($data['file']->getClientOriginalName(), 0, -4));
            $newFileName = $fileName . '-' . rand(11111, 99999) . '.' . $extension;

            if (Input::get('file_type') == 1) { // File Type 1 = Google Analytics File
                $path = app_path().'/config/packages/thujohn/analytics/';
                $response = LSetting::analyticsFileUpdate($newFileName);
            }

            $upload_success = $data['file']->move($path, $newFileName); // uploading file to given path

            if ($upload_success && $response) {
                return Response::json([
                    'success' => true,
                    'message' => 'Successfully...',
                    'file'   => asset($path.$newFileName)
                ]);
            } else {
                return Response::json([
                    'success' => false,
                    'message' => 'Error'
                ]);
            }

        }

    }

    private function send()
    {
        return json_encode($this->json);
    }

}