<?php

class SettingControllerAjax extends AdminController {

    private $json;
    public function __construct()
    {
        $this->json = [
            'status'  => false,
            'message' => ''
        ];
    }

    public function generalUpdate($id)
    {
        (Input::get('after_a_website_analysis') == '') ? $afterAwebsiteAnalysis = 0 : $afterAwebsiteAnalysis = 1;
        (Input::get('after_a_website_verifying') == '') ? $afterAwebsiteVerifying = 0 : $afterAwebsiteVerifying = 1;
        (Input::get('wap_analyzed_website_link') == '') ? $wapAnalyzedWebsiteLink = 0 : $wapAnalyzedWebsiteLink = 1;

        $data = [
            'site_name'                 => Input::get('site_name'),
            'title'                     => Input::get('title'),
            'description'               => Input::get('description'),
            'keywords'                  => Input::get('keywords'),
            'contact_email'             => Input::get('contact_email'),
            'counter_code'              => Input::get('counter_code'),
            'after_a_website_analysis'  => $afterAwebsiteAnalysis,
            'after_a_website_verifying' => $afterAwebsiteVerifying,
            'wap_analyzed_website_link' => $wapAnalyzedWebsiteLink
        ];

        $response = LSetting::generalUpdate($id, $data);

        LLanguage::setDefaultLang(Input::get('default_lang'));

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Updated successfully...';
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();
    }

    public function socialUpdate($id)
    {
        // Social Sharing Status
        (Input::get('facebook') == '') ? $facebookStatus = 0 : $facebookStatus = 1;
        (Input::get('twitter') == '') ? $twitterStatus = 0 : $twitterStatus = 1;
        (Input::get('google_plus') == '') ? $googlePlusStatus = 0 : $googlePlusStatus = 1;
        (Input::get('delicious') == '') ? $deliciousStatus = 0 : $deliciousStatus = 1;
        (Input::get('stumbleupon') == '') ? $stumbleuponStatus = 0 : $stumbleuponStatus = 1;
        (Input::get('tumblr') == '') ? $tumblrStatus = 0 : $tumblrStatus = 1;
        (Input::get('linkedin') == '') ? $linkedinStatus = 0 : $linkedinStatus = 1;
        (Input::get('pinterest') == '') ? $pinterestStatus = 0 : $pinterestStatus = 1;
        (Input::get('reddit') == '') ? $redditStatus = 0 : $redditStatus = 1;
        (Input::get('digg') == '') ? $diggStatus = 0 : $diggStatus = 1;

        $data = [
            'facebook'                      => $facebookStatus,
            'twitter'                       => $twitterStatus,
            'google_plus'                   => $googlePlusStatus,
            'delicious'                     => $deliciousStatus,
            'stumbleupon'                   => $stumbleuponStatus,
            'tumblr'                        => $tumblrStatus,
            'linkedin'                      => $linkedinStatus,
            'pinterest'                     => $pinterestStatus,
            'reddit'                        => $redditStatus,
            'digg'                          => $diggStatus,
            'facebook_account'              => Input::get('facebook_account'),
            'twitter_account'               => Input::get('twitter_account'),
            'google_plus_account'           => Input::get('google_plus_account'),
            'delicious_account'             => Input::get('delicious_account'),
            'stumbleupon_account'           => Input::get('stumbleupon_account'),
            'tumblr_account'                => Input::get('tumblr_account'),
            'linkedin_account'              => Input::get('linkedin_account'),
            'pinterest_account'             => Input::get('pinterest_account'),
            'reddit_account'                => Input::get('reddit_account'),
            'digg_account'                  => Input::get('digg_account')
        ];

        $response = LSetting::socialUpdate($id, $data);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Updated successfully...';
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();
    }

    public function apiKeysUpdate($id)
    {
        $data = [
            'google_api'                        => Input::get('google_api'),
            'bing_account'                      => Input::get('bing_account'),
            'google_recaptcha_site'             => Input::get('google_recaptcha_site'),
            'google_recaptcha_secret'           => Input::get('google_recaptcha_secret'),
            'google_analytics_client_id'        => Input::get('google_analytics_client_id'),
            'google_analytics_service_email'    => Input::get('google_analytics_service_email'),
            'api_whois_key'                     => Input::get('api_whois_key'),
            'pagepeeker_api_status'             => Input::get('pagepeeker_api_status'),
            'pagepeeker_api'                    => Input::get('pagepeeker_api')
        ];

        $response = LSetting::apiKeysUpdate($id, $data);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Updated successfully...';
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();
    }

    public function mailUpdate()
    {
        (Input::get('mail_comment_status') == '') ? $mailCommentStatus = 0 : $mailCommentStatus = 1;
        (Input::get('mail_contact_status') == '') ? $mailContactStatus = 0 : $mailContactStatus = 1;
        (Input::get('mail_report_status') == '') ? $mailReportStatus = 0 : $mailReportStatus = 1;
        (Input::get('mail_remove_website_status') == '') ? $mailRemoveWebsiteStatus = 0 : $mailRemoveWebsiteStatus = 1;

        $data = [
            'id'                            => 1,
            'smtp_mail_name'                => Input::get('smtp_mail_name'),
            'smtp_host'                     => Input::get('smtp_host'),
            'smtp_port'                     => Input::get('smtp_port'),
            'smtp_username'                 => Input::get('smtp_username'),
            'smtp_password'                 => Input::get('smtp_password'),
            'smtp_secure_socket'            => Input::get('smtp_secure_socket'),
            'mail_comment_status'           => $mailCommentStatus,
            'mail_contact_status'           => $mailContactStatus,
            'mail_report_status'            => $mailReportStatus,
            'mail_remove_website_status'    => $mailRemoveWebsiteStatus
        ];

        $response = LSetting::mailUpdate($data);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Updated successfully...';
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();
    }

    public function sitemapUpdate()
    {
        // Page Status
        if (Input::get('page_status') == '') {
            $pageStatus = 0;
        } else{
            $pageStatus = 1;
        }

        // Country Status
        if (Input::get('country_status') == '') {
            $countryStatus = 0;
        } else{
            $countryStatus = 1;
        }

        // Website Status
        if (Input::get('website_status') == '') {
            $websiteStatus = 0;
        } else{
            $websiteStatus = 1;
        }

        $data = [
            'id'                        => 1,
            'sitemap_per_page'          => Input::get('sitemap_per_page'),
            'page_status'               => $pageStatus,
            'country_status'            => $countryStatus,
            'website_status'            => $websiteStatus,
            'page_change_frequency'     => Input::get('page_change_frequency'),
            'page_priority_level'       => Input::get('page_priority_level'),
            'country_change_frequency'  => Input::get('country_change_frequency'),
            'country_priority_level'    => Input::get('country_priority_level'),
            'website_change_frequency'  => Input::get('website_change_frequency'),
            'website_priority_level'    => Input::get('website_priority_level')
        ];

        $response = LSetting::sitemapUpdate($data);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Updated successfully...';
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();
    }

    public function commentUpdate()
    {
        // Comment Status
        (Input::get('comment_default') == '') ? $commentDefault = 0 : $commentDefault = 1;
        (Input::get('comment_disqus') == '') ? $commentDisqus = 0 : $commentDisqus = 1;
        (Input::get('comment_facebook') == '') ? $commentFacebook = 0 : $commentFacebook = 1;

        $data = [
            'id'                        => 1,
            'comment_default'           => $commentDefault,
            'comment_disqus'            => $commentDisqus,
            'comment_disqus_username'   => Input::get('comment_disqus_username'),
            'comment_facebook'          => $commentFacebook,
            'comment_facebook_app_id'   => Input::get('comment_facebook_app_id'),
            'comment_facebook_limit'    => Input::get('comment_facebook_limit')
        ];

        $response = LSetting::commentUpdate($data);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Updated successfully...';
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();
    }

    public function paginationUpdate()
    {
        $data = [
            'id'                                => 1,
            'recently_websites_limit'           => Input::get('recently_websites_limit'),
            'countries_limit'                   => Input::get('countries_limit'),
            'table_row_limit'                   => Input::get('table_row_limit'),
            'link_limit'                        => Input::get('link_limit'),
            'website_per_country_page'          => Input::get('website_per_country_page'),
            'sidebar_countries_limit'           => Input::get('sidebar_countries_limit'),
            'sidebar_analyzed_websites_limit'   => Input::get('sidebar_analyzed_websites_limit')
        ];

        $response = LSetting::paginationUpdate($data);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Updated successfully...';
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();
    }

    public function layoutUpdate($id)
    {
        $data = [
            'header_bgc'            => Input::get('header_bgc'),
            'header_link_c'         => Input::get('header_link_c'),
            'header_link_hc'        => Input::get('header_link_hc'),
            'header_link_hbc'       => Input::get('header_link_hbc'),
            'button_bgc'            => Input::get('button_bgc'),
            'button_fc'             => Input::get('button_fc'),
            'button_bc'             => Input::get('button_bc'),
            'button_hbgc'           => Input::get('button_hbgc'),
            'button_hfc'            => Input::get('button_hfc'),
            'button_hbc'            => Input::get('button_hbc'),
            'search_button_bgc'     => Input::get('search_button_bgc'),
            'search_button_fc'      => Input::get('search_button_fc'),
            'search_button_bc'      => Input::get('search_button_bc'),
            'search_button_hbgc'    => Input::get('search_button_hbgc'),
            'search_button_hfc'     => Input::get('search_button_hfc'),
            'search_button_hbc'     => Input::get('search_button_hbc'),
            'module_title_bgc'      => Input::get('module_title_bgc'),
            'module_title_fc'       => Input::get('module_title_fc'),
            'footer_bgc'            => Input::get('footer_bgc'),
            'footer_tbgc'           => Input::get('footer_tbgc'),
            'footer_fc'             => Input::get('footer_fc'),
            'fixed_menu_bgc'        => Input::get('fixed_menu_bgc'),
            'fixed_menu_lc'         => Input::get('fixed_menu_lc'),
            'fixed_menu_lhc'        => Input::get('fixed_menu_lhc'),
            'fixed_menu_lhbc'       => Input::get('fixed_menu_lhbc'),
            'fixed_menu_bbc'        => Input::get('fixed_menu_bbc'),
            'module_bc'             => Input::get('module_bc'),
            'module_bhc'            => Input::get('module_bhc'),
            'module_shc'            => Input::get('module_shc'),
            'module_subtitle_bgc'   => Input::get('module_subtitle_bgc'),
            'module_subtitle_fc'    => Input::get('module_subtitle_fc'),
        ];

        $response = LSetting::layoutUpdate($id, $data);

        if ($response['status']) {

            //$style = Style::first();

            //$styleCodes = View::make('style', ['style' => $style])->render();

            //file_put_contents(public_path('css/main.css'), $styleCodes);

            $this->json['status'] = true;
            $this->json['message'] = 'Updated successfully...';
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();
    }

    public function cacheUpdate($id)
    {
        // Cache Status
        (Input::get('cache_hp_s') == '') ? $cacheHpStatus = 0 : $cacheHpStatus = 1;
        (Input::get('cache_wap_s') == '') ? $cacheWapStatus = 0 : $cacheWapStatus = 1;
        (Input::get('cache_ctp_s') == '') ? $cacheCtpStatus = 0 : $cacheCtpStatus = 1;
        (Input::get('cache_p_s') == '') ? $cachePStatus = 0 : $cachePStatus = 1;
        (Input::get('cache_s_s') == '') ? $cacheSStatus = 0 : $cacheSStatus = 1;

        $data = [
            'cache_hp_s'            => $cacheHpStatus,
            'cache_wap_s'           => $cacheWapStatus,
            'cache_ctp_s'           => $cacheCtpStatus,
            'cache_p_s'             => $cachePStatus,
            'cache_s_s'             => $cacheSStatus,
            'cache_hp_et'           => Input::get('cache_hp_et'),
            'cache_wap_et'          => Input::get('cache_wap_et'),
            'cache_ctp_et'          => Input::get('cache_ctp_et'),
            'cache_p_et'            => Input::get('cache_p_et'),
            'cache_s_et'            => Input::get('cache_s_et')
        ];

        $response = LSetting::cacheUpdate($id, $data);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Updated successfully...';
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();
    }

    public function clearAllCache()
    {
        Cache::flush();
        $this->json['status'] = true;
        $this->json['message'] = 'Cleared successfully...';

        return $this->send();
    }

    public function adsUpdate($id)
    {
        // Ads Status
        (Input::get('ads_sidebar_top_status') == '') ? $adsSidebarTopStatus = 0 : $adsSidebarTopStatus = 1;
        (Input::get('ads_sidebar_bottom_status') == '') ? $adsSidebarBottomStatus = 0 : $adsSidebarBottomStatus = 1;
        (Input::get('ads_wtp_header_status') == '') ? $adsWtpHeaderStatus = 0 : $adsWtpHeaderStatus = 1;
        (Input::get('ads_wtp_comments_status') == '') ? $adsWtpCommentsStatus = 0 : $adsWtpCommentsStatus = 1;
        (Input::get('ads_wtp_fb_comments_status') == '') ? $adsWtpFbCommentsStatus = 0 : $adsWtpFbCommentsStatus = 1;
        (Input::get('ads_ap_header_status') == '') ? $adsApHeaderStatus = 0 : $adsApHeaderStatus = 1;
        (Input::get('ads_cp_status') == '') ? $adsCpStatus = 0 : $adsCpStatus = 1;

        $data = [
            'ads_sidebar_top_status'        => $adsSidebarTopStatus,
            'ads_sidebar_bottom_status'     => $adsSidebarBottomStatus,
            'ads_wtp_header_status'         => $adsWtpHeaderStatus,
            'ads_wtp_comments_status'       => $adsWtpCommentsStatus,
            'ads_wtp_fb_comments_status'    => $adsWtpFbCommentsStatus,
            'ads_ap_header_status'          => $adsApHeaderStatus,
            'ads_cp_status'                 => $adsCpStatus,
            'ads_sidebar_top_code'          => Input::get('ads_sidebar_top_code'),
            'ads_sidebar_bottom_code'       => Input::get('ads_sidebar_bottom_code'),
            'ads_wtp_header_code'           => Input::get('ads_wtp_header_code'),
            'ads_wtp_comments_code'         => Input::get('ads_wtp_comments_code'),
            'ads_wtp_fb_comments_code'      => Input::get('ads_wtp_fb_comments_code'),
            'ads_ap_header_code'            => Input::get('ads_ap_header_code'),
            'ads_cp_code'                   => Input::get('ads_cp_code')
        ];

        $response = LSetting::adsUpdate($id, $data);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Updated successfully...';
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();
    }

    private function send()
    {
        return json_encode($this->json);
    }

}