<?php

class ReportControllerAjax extends AdminController
{

    private $json;

    public function __construct()
    {
        $this->json = [
            'status'  => false,
            'message' => ''
        ];
    }

    public function get()
    {
        $reports = Report::select(array('reports.id', 'reports.site_name', 'reports.subject', 'reports.ip_address', 'reports.created_at', 'reports.status'))->where('reports.status', '>=', 0);

        return Datatables::of($reports)
            ->set_index_column('id')
            ->filter_column('reports.subject','where','reports.subject','LIKE','$1')
            ->filter_column('reports.ip_address','where','reports.ip_address','LIKE','$1')
            ->filter_column('reports.created_at','where','reports.created_at','LIKE','$1')
            ->edit_column('status', '@if($status == 1) <span class="label label-primary">Readed</span> @elseif($status == 2) <span class="label label-success">Answered</span> @else <span class="label label-warning">Unread</span> @endif ')
            ->add_column('Options', '<a href="{{ route( \'report.show\', array( $id )) }}" class="btn btn-primary btn-xs">Show</a> <a href="{{ route( \'ajax.remove.report\', array( $id )) }}" class="btn remove-report btn-danger btn-xs">Remove</a>')
            ->make();
    }

    public function remove($id)
    {
        $remove = LReport::remove($id);

        if($remove['status']){
            $this->json['status'] = true;
        }
        $this->json['message'] = $remove['message'];
        return $this->send();
    }

    private function send()
    {
        return json_encode($this->json);
    }

}