<?php

class PageControllerAjax extends AdminController {

    private $json;

    public function __construct()
    {
        $this->json = [
            'status'  => false,
            'message' => ''
        ];
    }

    public function get()
    {
        $pages = Page::select(array('pages.id', 'pages.page_title', 'pages.slug', 'pages.created_at', 'pages.updated_at', 'pages.status'))->where('pages.status', '>=', 0);

        return Datatables::of($pages)
            ->set_index_column('id')
            ->edit_column('page_title', function($row) {
                $defaultLang = LLanguage::getDefaultLang();
                $page_title = json_decode($row->page_title, true);
                return $page_title[$defaultLang['short']];
            })
            ->filter_column('pages.created_at', 'where', 'pages.created_at', 'LIKE', '$1')
            ->filter_column('pages.updated_at', 'where', 'pages.updated_at', 'LIKE', '$1')
            ->edit_column('status', '@if($status == 1) <span class="label label-success">Active</span> @else <span class="label label-warning">Passive</span> @endif ')
            ->add_column('Options', '<a href="{{ route( \'page.edit\', array( $id )) }}" class="btn btn-primary btn-xs">Edit</a> <a href="{{ route( \'ajax.remove.page\', array( $id )) }}" class="btn remove-page btn-danger btn-xs">Remove</a> @if($status == 1)<a href="{{ route( \'site.page\', array( $slug )) }}" target="_blank" class="margin-l-5"><i class="fa fa-external-link"></i></a>@endif')
            ->remove_column('slug')
            ->make();
    }

    public function create()
    {
        if (Input::get('status') == '') {
            $status = 0;
        } else {
            $status = 1;
        }

        if (Input::get('slug') == '') {
            $slug =  Str::slug(Input::get('page_title')[Input::get('default_lang_short_code')]);
        } else {
            $slug =  Input::get('slug');
        }

        foreach (LLanguage::getActiveLangs() as $lang) {
            $data['page_title['.$lang->short.']'] = Input::get('page_title')[$lang->short];
            $data['title['.$lang->short.']'] = Input::get('title')[$lang->short];
            $data['description['.$lang->short.']'] = Input::get('description')[$lang->short];
            $data['keywords['.$lang->short.']'] = Input::get('keywords')[$lang->short];
            $data['content['.$lang->short.']'] = Input::get('content')[$lang->short];
        }

        $data['slug'] = $slug;
        $data['status'] = $status;

        $response = LPage::create($data);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Successfully added...';
        } else {
            $this->json['message'] = $response['errors'];
        }
        return $this->send();
    }

    public function update($id)
    {
        if (Input::get('status') == '') {
            $status = 0;
        } else {
            $status = 1;
        }

        if (Input::get('slug') == '') {
            $slug =  Str::slug(Input::get('page_title')[Input::get('default_lang_short_code')]);
        } else {
            $slug =  Input::get('slug');
        }

        foreach (LLanguage::getActiveLangs() as $lang) {
            $data['page_title['.$lang->short.']'] = Input::get('page_title')[$lang->short];
            $data['title['.$lang->short.']'] = Input::get('title')[$lang->short];
            $data['description['.$lang->short.']'] = Input::get('description')[$lang->short];
            $data['keywords['.$lang->short.']'] = Input::get('keywords')[$lang->short];
            $data['content['.$lang->short.']'] = Input::get('content')[$lang->short];
        }

        $data['slug'] = $slug;
        $data['status'] = $status;

        $response = LPage::update($id, $data);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Updated successfully...';
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();

    }

    public function remove($id)
    {
        $response = LPage::remove($id);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Deleted successfully...';
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();
    }

    private function send()
    {
        return json_encode($this->json);
    }

}