<?php

class LanguageControllerAjax extends AdminController
{

    private $json;

    public function __construct()
    {
        $this->json = [
            'status'  => false,
            'message' => ''
        ];
    }

    public function get()
    {
        $contacts = Language::select(array('languages.id', 'languages.name', 'languages.short'))->where('languages.status', 1);

        return Datatables::of($contacts)
            ->edit_column('id', '<img src="{{ asset(\'img/languages/\' . $short . \'.png\') }}"/>')
            ->filter_column('languages.name','where','languages.name','LIKE','$1')
            ->add_column('Options', '<a href="{{ route( \'language.edit\', array( $id )) }}" class="btn btn-primary btn-xs">Edit</a> <a href="{{ route( \'ajax.remove.language\', array( $id )) }}" class="btn remove-language btn-danger btn-xs">Remove</a>')
            ->make();
    }

    public function create(){

        $languageID = Input::get('language');
        $langData     = Input::get('lang');

        $response = LLanguage::create($languageID, $langData);

        if($response['status']){
            $this->json['status'] = true;
            $this->json['message'] = $response['message'];
            $this->json['redirect'] = route('languages');
        }
        else{
            $this->json['errors'] = $response['errors'];
        }

        return $this->send();
    }

    public function update($id){

        $langData     = Input::get('lang');

        $response = LLanguage::update($id, $langData);

        if($response['status']){
            $this->json['status'] = true;
            $this->json['message'] = $response['message'];
        }
        else{
            $this->json['errors'] = $response['errors'];
        }

        return $this->send();
    }

    public function remove($id)
    {
        $response = LLanguage::remove($id);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Deleted successfully...';
        } else {
            $this->json['message'] = $response['message'];
        }

        return $this->send();
    }



    private function send()
    {
        return json_encode($this->json);
    }

}