<?php

class ContactControllerAjax extends AdminController
{

    private $json;

    public function __construct()
    {
        $this->json = [
            'status'  => false,
            'message' => ''
        ];
    }

    public function get()
    {
        $contacts = Contact::select(array('contacts.id', 'contacts.name', 'contacts.subject', 'contacts.ip_address', 'contacts.created_at', 'contacts.status'))->where('contacts.status', '>=', 0);

        return Datatables::of($contacts)
            ->set_index_column('id')
            ->filter_column('contacts.name','where','contacts.name','LIKE','$1')
            ->filter_column('contacts.subject','where','contacts.subject','LIKE','$1')
            ->edit_column('status', '@if($status == 1) <span class="label label-primary">Readed</span> @elseif($status == 2) <span class="label label-success">Answered</span> @else <span class="label label-warning">Unread</span> @endif ')
            ->add_column('Options', '<a href="{{ route( \'contact-show\', array( $id )) }}" class="btn btn-primary btn-xs">Show</a> <a href="{{ route( \'ajax.remove.contact\', array( $id )) }}" class="btn remove-contact btn-danger btn-xs">Remove</a>')
            ->make();
    }

    public function remove($id)
    {
        $remove = LContact::remove($id);

        if($remove['status']){
            $this->json['status'] = true;
        }
        $this->json['message'] = $remove['message'];
        return $this->send();
    }

    private function send()
    {
        return json_encode($this->json);
    }

}