<?php

class CommentControllerAjax extends AdminController
{

    private $json;

    public function __construct()
    {
        $this->json = [
            'status'  => false,
            'message' => ''
        ];
    }

    public function get()
    {
        $comments = Comment::select(array('comments.id', 'comments.site_name', 'comments.name', 'comments.email', 'comments.ip_address', 'comments.created_at', 'comments.status'))->where('comments.status', '>=', 0);

        return Datatables::of($comments)
            ->set_index_column('id')
            ->filter_column('comments.site_name', 'where', 'comments.site_name', 'LIKE', '$1')
            ->filter_column('comments.name', 'where', 'comments.name', 'LIKE', '$1')
            ->edit_column('status', '@if($status == 1) <span class="label label-success">Approved</span> @else <span class="label label-warning">Pending</span> @endif ')
            ->add_column('Options', '<a href="{{ route( \'comment-edit\', array( $id )) }}" class="btn btn-primary btn-xs">Edit</a> <a href="{{ route( \'ajax.remove.comment\', array( $id )) }}" class="btn remove-comment btn-danger btn-xs">Remove</a>')
            ->make();
    }

    public function update($id)
    {
        (Input::get('status') == '') ? $status = 0 : $status = 1;

        $data = [
            'name'    => Input::get('name'),
            'email'   => Input::get('email'),
            'comment' => Input::get('comment'),
            'status'  => $status
        ];

        $edit = LComment::update($id, $data);

        if ($edit['status']) {
            $this->json['status'] = true;
        }
        $this->json['message'] = $edit['message'];

        return $this->send();
    }

    public function remove($id)
    {
        $remove = LComment::remove($id);

        if ($remove['status']) {
            $this->json['status'] = true;
        }
        $this->json['message'] = $remove['message'];

        return $this->send();
    }


    private function send()
    {
        return json_encode($this->json);
    }

}