<?php

class AdministratorControllerAjax extends AdminController {

    private $json;

    public function __construct()
    {
        $this->json = [
            'status'  => false,
            'message' => ''
        ];
    }

    public function get()
    {
        $administrators = Administrator::select(array('administrators.id', 'administrators.username', 'administrators.email', 'administrators.status'))->where('administrators.status', '>=', 0);

        return Datatables::of($administrators)
            ->set_index_column('id')
            ->filter_column('administrators.username', 'where', 'administrators.username', 'LIKE', '$1')
            ->filter_column('administrators.email', 'where', 'administrators.email', 'LIKE', '$1')
            ->edit_column('status', '@if($status == 1) <span class="label label-success">Active</span> @else <span class="label label-warning">Passive</span> @endif ')
            ->add_column('Options', '<a href="{{ route( \'administrator.edit\', array( $id )) }}" class="btn btn-primary btn-xs">Edit</a> <a href="{{ route( \'ajax.remove.administrator\', array( $id )) }}" class="btn remove-administrator btn-danger btn-xs">Remove</a>')
            ->make();
    }

    public function create()
    {
        if (Input::get('status') == '') {
            $status = 0;
        } else {
            $status = 1;
        }

        $data = [
            'username'              => trim(Input::get('username')),
            'password'              => trim(Input::get('password')),
            'password_confirmation' => trim(Input::get('password_confirmation')),
            'email'                 => trim(Input::get('email')),
            'status'                => $status
        ];

        $response = LAdministrator::create($data);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Successfully added...';
        } else {
            $this->json['message'] = $response['errors'];
        }
        return $this->send();
    }

    public function update($id)
    {
        if (Input::get('status') == '') {
            $status = 0;
        } else{
            $status = 1;
        }

        $data = [
            'username'              => trim(Input::get('username')),
            'password'              => trim(Input::get('password')),
            'password_confirmation' => trim(Input::get('password_confirmation')),
            'email'                 => trim(Input::get('email')),
            'status'                => $status
        ];

        $response = LAdministrator::update($id, $data);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Updated successfully...';
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();

    }

    public function remove($id)
    {
        $response = LAdministrator::remove($id);

        if ($response['status']) {
            $this->json['status'] = true;
            $this->json['message'] = 'Deleted successfully...';
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();
    }

    private function send()
    {
        return json_encode($this->json);
    }

}