<?php

class WebsiteController extends AdminController {

    public function all()
    {
        return View::make('admin.website.all');
    }

    public function edit($id)
    {
        try {
            $website = LWebsite::get($id);
            $countries = LCountry::all();

            return View::make('admin.website.edit')
                ->with('website', $website)
                ->with('countries', $countries);

        } catch(Exception $e) {
            return Redirect::route('website.list');
        }
    }

    public function deletion()
    {
        $deletionRequests = LWebsite::deletionRequests();

        return View::make('admin.website.deletion-requests')
            ->with('websites', $deletionRequests);
    }

    public function bulkUpload()
    {
        return View::make('admin.website.bulk-upload');
    }

}