<?php

class SettingController extends AdminController {

    public function general()
    {
        $activeLangs = LLanguage::getActiveLangs();
        if ($activeLangs) {
            return View::make('admin.setting.general')
                ->with('activeLangs', $activeLangs);
        }
    }

    public function socialMedia()
    {
        return View::make('admin.setting.social-media');
    }

    public function apiKeys()
    {
        return View::make('admin.setting.api-key');
    }

    public function mail()
    {
        return View::make('admin.setting.mail');
    }

    public function sitemap()
    {
        $sitemap = LSetting::getSitemapSettings();
        if ($sitemap) {
            return View::make('admin.setting.sitemap')
                ->with('sitemap', $sitemap);
        }
    }

    public function comment()
    {
        return View::make('admin.setting.comment');
    }

    public function pagination()
    {
        return View::make('admin.setting.pagination');
    }

    public function layout()
    {
        $layoutSetting = LSetting::getLayoutSettings();
        if ($layoutSetting) {
            return View::make('admin.setting.layout')
                ->with('layoutSetting', $layoutSetting);
        }
    }

    public function cache()
    {
        return View::make('admin.setting.cache');
    }

    public function ads()
    {
        return View::make('admin.setting.ads');
    }

}