<?php

class PageController extends AdminController {

    public function all()
    {
        $defaultLang = LLanguage::getDefaultLang();
        if ($defaultLang) {
            return View::make('admin.page.all')
                ->with('defaultLang', $defaultLang);
        }

        return View::make('admin.page.all');
    }

    public function add()
    {
        $activeLangs = LLanguage::getActiveLangs();
        $defaultLang = LLanguage::getDefaultLang();
        if ($activeLangs) {
            return View::make('admin.page.add')
                ->with('activeLangs', $activeLangs)
                ->with('defaultLang', $defaultLang);
        }
    }

    public function edit($id)
    {
        try {
            $page = LPage::get($id);

            $page->page_title = json_decode($page->page_title, true);
            $page->title = json_decode($page->title, true);
            $page->description = json_decode($page->description, true);
            $page->keywords = json_decode($page->keywords, true);
            $page->content = json_decode($page->content, true);

            $activeLangs = LLanguage::getActiveLangs();
            $defaultLang = LLanguage::getDefaultLang();

            if ($page) {
                return View::make('admin.page.edit')
                    ->with('page', $page)
                    ->with('activeLangs', $activeLangs)
                    ->with('defaultLang', $defaultLang);
            }
        } catch(Exception $e) {
            return Redirect::route('pages');
        }

    }

}