<?php

class LanguageController extends AdminController
{
    public function all(){
        return View::make('admin.language.all');
    }

    public function add(){
        $languages    = LLanguage::all();
        $languageKeys = LLanguage::keys();

        return View::make('admin.language.add')
            ->with('languages', $languages)
            ->with('languageKeys', $languageKeys);
    }

    public function edit($id){
        try {
            $languages    = LLanguage::all();
            $translations = LLanguage::getTranslations($id);

            return View::make('admin.language.edit')
                ->with('currentLanguage', $id)
                ->with('languages', $languages)
                ->with('translations', $translations);

        } catch(Exception $e) {
            return Redirect::route('languages');
        }
    }
}