<?php

class AuthController extends AdminController
{

    public function getLogin()
    {
        return View::make('admin.auth.login');
    }

    public function postLogin()
    {
        $credentials = [
            'email'     => Input::get('email'),
            'password'  => Input::get('password'),
            'status'    => 1 // Active User : 1
        ];

        $remember = (Input::has('remember')) ? true : false;

        $rules = [
            'email'     => 'required|email',
            'password'  => 'required'
        ];

        $validator = Validator::make($credentials, $rules);

        if($validator->passes()) {
            if (Auth::attempt($credentials, $remember)) {
                return Redirect::Route('dashboard');
            } else {
                return Redirect::back()->withInput()->withErrors('E-Mail or Password is invalid!');
            }
        } else {
            return Redirect::back()->withErrors($validator)->withInput();
        }
    }

    public function getForgotPassword()
    {
        return View::make('admin.auth.forgot-password');
    }

    public function postForgotPassword() {
        $credentials = [
            'email' => Input::get('email')
        ];

        $rules = [
            'email' => 'required|email'
        ];

        $validator = Validator::make($credentials, $rules);

        if ($validator->fails()) {
            return Redirect::back()->withErrors($validator->errors()->all());
        }

        switch ($response = Password::remind(Input::only('email'), function($message) { $message->subject('Password Reset'); })) {
            case Password::INVALID_USER:
                return Redirect::back()->withErrors(Lang::get($response));

            case Password::REMINDER_SENT:
                return Redirect::back()->with('status', Lang::get($response));
        }
    }

    public function getResetPassword($token = null)
    {
        if (is_null($token)) App::abort(404);
        return View::make('admin.auth.password-reset')->with('token', $token);
    }

    public function postResetPassword()
    {
        $credentials = [
            'email'                 => Input::get('email'),
            'password'              => Input::get('password'),
            'password_confirmation' => Input::get('password_confirmation'),
            'token'                 => Input::get('token')
        ];

        $rules = [
            'email'                 => 'required|email',
            'password'              => 'alpha_num|between:4,12|confirmed',
            'password_confirmation' => 'alpha_num|between:4,12'
        ];

        $validator = Validator::make($credentials, $rules);

        if ($validator->fails()) {
            return Redirect::back()->withErrors($validator->errors()->all());
        }

        $response = Password::reset($credentials, function($user, $password) {
            $user->password = Hash::make($password);
            $user->save();
        });

        switch ($response)
        {
            case Password::INVALID_PASSWORD:
            case Password::INVALID_TOKEN:
            case Password::INVALID_USER:
                return Redirect::back()->withErrors(Lang::get($response));

            case Password::PASSWORD_RESET:
                return Redirect::back()->with('status', Lang::get($response));
        }
    }

    public function getLogout()
    {
        Auth::logout();
        return Redirect::Route('account.login');
    }

}