<?php
use Carbon\Carbon;
class ToolController extends BaseController{

    public function siteList()
    {
        $file = "site-list2.txt";
        $list = file($file);
        $sites = [];

        foreach($list as $site)
        {
            $siteName = get_site_name($site);

            if($siteName){
                $sites[] = $siteName;
            }
        }

        WebSiteUnIndexed::add($sites, 1);
    }

    public function stats()
    {
        $stats = Stats::getLastList(150);
        $unique = Stats::getUnique();
        $todayWebsiteCount = WebSite::getWebsiteCountToday();

        return View::make('stats.stats')
            ->with('stats', $stats)
            ->with('unique', $unique)
            ->with('todayWebsiteCount', $todayWebsiteCount);
    }
}