<?php

class SiteMapController extends BaseController
{

    private $settings;

    public function __construct()
    {
        $this->settings = LSetting::getSitemapSettings();
    }

    public function index()
    {

        $partCount = ceil(WebSite::getTotalCount() / $this->settings->sitemap_per_page);

        $content = View::make('sitemap.index')
        ->with('partCount', $partCount)
        ->with('perPage', $this->settings->sitemap_per_page)
        ->with('settings', $this->settings);

        return Response::make($content, '200')->header('Content-Type', 'text/xml');

    }

    public function main()
    {
        $pages = null;
        $countries = null;

        if($this->settings->page_status == 1)
            $pages = Page::getAll();

        if($this->settings->country_status == 1)
            $countries = Country::getAllWebSiteCount();

        $content = View::make('sitemap.main')
            ->with('pages', $pages)
            ->with('countries', $countries)
            ->with('settings', $this->settings);

        return Response::make($content, '200')->header('Content-Type', 'text/xml');

    }

    public function websites($limit)
    {
        if( $limit < $this->settings->sitemap_per_page ){
            exit;
        }

        $start = $limit - $this->settings->sitemap_per_page;
        $websites = WebSite::getAll($start, $this->settings->sitemap_per_page);

        $content = View::make('sitemap.websites')
            ->with('websites', $websites)
            ->with('settings', $this->settings);

        return Response::make($content, '200')->header('Content-Type', 'text/xml');
    }


}
