<?php

class SiteController extends BaseController
{

    public function home()
    {


        $settings = LSetting::getSettings();

        if ($settings->cache_hp_s) {
            $remember = $settings->cache_hp_et;
        } else {
            $remember = 0;
        }


        return View::make('index')
            ->with('recentWebSites', CommonModel::getRecentWebSites($settings->recently_websites_limit, $remember))
            ->with('randomCountries', CommonModel::getRandomCountries($settings->countries_limit, $remember));
    }

    public function contact()
    {
        return View::make('contact');
    }

    public function report($id)
    {
        $website = WebSite::getSiteById($id);
        if(isset($website->id)){
            return View::make('report')
                ->with('id', $website->id)
                ->with('name', $website->name);
        }
        return Redirect::route('index');
    }

    public function page($slug)
    {
        $settings = LSetting::getSettings();

        if ($settings->cache_p_s) {
            $remember = $settings->cache_p_et;
        } else {
            $remember = 0;
        }

        $page = Page::getPageBySlug($slug, $remember);

        $page->page_title = json_decode($page->page_title, true);
        $page->title = json_decode($page->title, true);
        $page->description = json_decode($page->description, true);
        $page->keywords = json_decode($page->keywords, true);
        $page->content = json_decode($page->content, true);

        if ($page) {
            return View::make('page')
                ->with('page', $page);
        }

        return 404;
    }

    public function changeLanguage($lang)
    {
        DBLang::setLanguage($lang);

        return Redirect::route('index');
    }

    public function getFavicon($slug)
    {
        $url = 'http://s2.googleusercontent.com/s2/favicons?domain_url=' . $slug;
        header('Content-type: image/png');
        readfile($url);
    }

    public function getContent($kind)
    {
        $kind = str_replace('-', '_', $kind);

        return DBLang::get('modal_' . $kind);
    }

    public function css()
    {
        $style = Style::first();

        return Response::view('style', ['style' => $style])
            ->header('Content-Type', 'text/css');

    }




}
