<?php

/**
 * Created by PhpStorm.
 * User: Burak
 * Date: 23.3.2015
 * Time: 21:25
 */
class CountryController extends BaseController
{


    public function index()
    {
        $countries = Country::getAllWebSiteCount()->toArray();
        $count = count($countries);
        $partial1 = $partial2 = $partial3 = [];

        if ($count <= 7) {
            $partial1 = $countries;
        } else {
            $partial1 = array_slice($countries, 0, 7);
            $otherCount = $count - 7;

            $partial2Count = floor($otherCount / 2);

            $partial3Count = $partial2Count;

            if (($otherCount % 2) == 1) {
                $partial2Count++;
            }

            $partial2 = array_slice($countries, 7, $partial2Count);
            $partial3 = array_slice($countries, 7 + $partial2Count, $partial3Count);
        }
        $index = 1;



        return View::make('country')
            ->with('partial1', $partial1)
            ->with('partial2', $partial2)
            ->with('partial3', $partial3)
            ->with('index', $index);
    }

    public function websites($slug)
    {
        $settings = LSetting::getSettings();

        if($settings->cache_ctp_s){
            $remember = $settings->cache_ctp_et;
        }else{
            $remember = 0;
        }



        $country = Country::getCountryBySlug($slug, $remember);
        $sites = WebSite::getWebsitesByCountry($country->alpha_2, $remember)
            ->paginate($settings->website_per_country_page)
            ->route('site.country-websites-p', ['slug' => $slug])
            ->pagesProximity(3);


        return View::make('websites')
            ->with('country', $country)
            ->with('sites', $sites);

    }
}