<?php

class AjaxSiteController extends BaseController
{
    private $json;
    private $settings;

    public function __construct()
    {
        $this->json = [
            'status'  => false,
            'message' => ''
        ];
        $this->settings = HSettings::getBasicSettings();
    }

    public function newComment()
    {
        $data = [
            'site_id'    => Input::get('id'),
            'name'       => Input::get('name'),
            'email'      => Input::get('email'),
            'comment'    => Input::get('comment'),
            'ip_address' => Request::getClientIp(),
            'user_agent' => Request::header('User-Agent')
        ];

        $validator = Validator::make(Input::all(), array(
            'g-recaptcha-response' => 'required|recaptcha'
        ));

        if ($validator->fails()) {
            $this->json['message'] = $validator->errors()->all();

            return $this->send();
        }

        $website = Website::getSingleSite($data['site_id']);
        if(isset($website['id'])){
            $data['site_name'] = $website['name'];
        }else{
            $data['site_name'] = '';
        }

        $response = Comment::add($data);

        if ($response['status']) {

            if($this->settings->mail_comment_status){
                Mail::send('emails.comment', array('name' => $data['name'], 'site' => $website['name']), function($message)
                {
                    $message->to($this->settings->contact_email, 'Smart Website Analyzer')->subject('New Comment');
                });
            }

            $this->json['status'] = true;
            $this->json['message'] = DBLang::get('comment_success_message');
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();

    }

    public function contact()
    {
        $data = [
            'name'       => Input::get('name'),
            'email'      => Input::get('email'),
            'subject'    => Input::get('subject'),
            'message'    => Input::get('message'),
            'ip_address' => Request::getClientIp(),
            'user_agent' => Request::header('User-Agent')
        ];

        $validator = Validator::make(Input::all(), array(
            'g-recaptcha-response' => 'required|recaptcha'
        ));

        if ($validator->fails()) {
            $this->json['message'] = $validator->errors()->all();

            return $this->send();
        }

        $response = Contact::add($data);

        if ($response['status']) {

            if($this->settings->mail_contact_status){
                Mail::send('emails.contact', array('name' => $data['name'] ), function($message)
                {
                    $message->to($this->settings->contact_email, 'Smart Website Analyzer')->subject('Contact Form');
                });
            }

            $this->json['status'] = true;
            $this->json['message'] = DBLang::get('contact_form_success_message');
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();

    }

    public function report()
    {
        $data = [
            'id'         => Input::get('id'),
            'email'      => Input::get('email'),
            'subject'    => Input::get('subject'),
            'message'    => Input::get('message'),
            'ip_address' => Request::getClientIp(),
            'user_agent' => Request::header('User-Agent')
        ];

        $validator = Validator::make(Input::all(), array(
            'g-recaptcha-response' => 'required|recaptcha'
        ));

        if ($validator->fails()) {
            $this->json['message'] = $validator->errors()->all();

            return $this->send();
        }

        $website = Website::getSiteById($data['id']);

        if(isset($website->id)){
            $data['site_name'] = $website->name;
        }else{
            $data['site_name'] = '';
        }

        $response = Report::add($data);

        if ($response['status']) {

            if($this->settings->mail_report_status){
                Mail::send('emails.report', array('site' => $website->name), function($message)
                {
                    $message->to($this->settings->contact_email, 'Smart Website Analyzer')->subject('Report Website');
                });
            }

            $this->json['status'] = true;
            $this->json['message'] = DBLang::get('report_form_success_message');
        } else {
            $this->json['message'] = $response['errors'];
        }

        return $this->send();

    }

    private function send()
    {
        return json_encode($this->json);
    }
}