<?php

class AjaxRemoveController extends BaseController
{
    private $json;
    private $settings;

    public function __construct()
    {
        $this->json = [
            'status'  => false,
            'message' => ''
        ];
        $this->settings = HSettings::getBasicSettings();
    }


    public function removeWebSite()
    {
        $website = Input::get('website');
        $website = str_replace('www.', '', $website);
        $website = str_replace('http://', '', $website);
        $website = str_replace('/', '', $website);

        $validator = Validator::make(['website' => $website], ['website' => 'exists:website,name'], [], ['website' => 'Web Site']);

        if($validator->fails()){
            $this->json['message'] = DBLang::get('not_registered');
            return $this->send();
        }

        $site = WebSite::getSiteByName($website);

        if(RemoveWebSite::add([
            'site_id'   => $site->id,
            'site_name' => $website,
            'ip_address' => Request::getClientIp(),
            'user_agent' => Request::header('User-Agent')
        ])){
            $this->json['status'] = true;
            $this->json['message'] = route('site.remove', [$website]);

            if($this->settings->mail_remove_website_status){
                Mail::send('emails.remove', array('site' => $site->name), function($message)
                {
                    $message->to($this->settings->contact_email, 'Smart Website Analyzer')->subject('Remove Website');
                });
            }
        }

        return $this->send();
    }

    public function verifyWebSite($url)
    {
        $removeData = RemoveWebSite::getLastRemoveCode($url);
        $removeCode = $removeData['remove_code'];

        $verificationMethod = Input::get('verification-method');

        if(! $removeData){
            $this->json['message'] = DBLang::get('request_not_found');
            return $this->send();
        }

        if($verificationMethod == 'file-upload'){
            $remoteFileContent = @file_get_contents_curl('http://' . $url . '/' . $removeCode . '.html');
            if($remoteFileContent == 'aws-' . $removeCode){
                // Başarılı
                $this->json['status'] = true;
            }else{
                $this->json['message'] = DBLang::get('upload_file_message');
            }
        }

        if($verificationMethod == 'html-code'){
            $remoteSiteContent = @file_get_contents_curl('http://' . $url);
            if(strpos($remoteSiteContent, 'aws-' . $removeCode) !== false){
                // Başarılı
                $this->json['status'] = true;
            }else{
                $this->json['message'] = DBLang::get('html_code_message');
            }
        }

        if($this->json['status']){
            $this->json['message'] = DBLang::get('remove_website_success');
            RemoveWebSite::verifiedSite($removeData['id']);
            if($this->settings->after_a_website_verifying == 0){
                LWebsite::remove($removeData['site_id']);
            }else{
                WebSite::deleteWebSite($removeData['site_name']);
            }

        }
        return $this->send();;
    }

    private function send()
    {
        return json_encode($this->json);
    }
}