<?php

return array(

    /*
    |--------------------------------------------------------------------------
    | Application Debug Mode
    |--------------------------------------------------------------------------
    |
    | When your application is in debug mode, detailed error messages with
    | stack traces will be shown on every error that occurs within your
    | application. If disabled, a simple generic error page is shown.
    |
    */

    'debug'                 => true,

    /*
    |--------------------------------------------------------------------------
    | Application URL
    |--------------------------------------------------------------------------
    |
    | This URL is used by the console to properly generate URLs when using
    | the Artisan command line tool. You should set this to the root of
    | your application so that it is used when running Artisan tasks.
    |
    */

    'url'                   => '',

    /*
    |--------------------------------------------------------------------------
    | Application Timezone
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default timezone for your application, which
    | will be used by the PHP date and date-time functions. We have gone
    | ahead and set this to a sensible default for you out of the box.
    |
    */

    'timezone'              => 'Europe/Istanbul',

    /*
    |--------------------------------------------------------------------------
    | Application Locale Configuration
    |--------------------------------------------------------------------------
    |
    | The application locale determines the default locale that will be used
    | by the translation service provider. You are free to set this value
    | to any of the locales which will be supported by the application.
    |
    */

    'locale'                => 'en',

    /*
    |--------------------------------------------------------------------------
    | Application Fallback Locale
    |--------------------------------------------------------------------------
    |
    | The fallback locale determines the locale to use when the current one
    | is not available. You may change the value to correspond to any of
    | the language folders that are provided through your application.
    |
    */

    'fallback_locale'       => 'en',

    /*
    |--------------------------------------------------------------------------
    | Encryption Key
    |--------------------------------------------------------------------------
    |
    | This key is used by the Illuminate encrypter service and should be set
    | to a random, 32 character string, otherwise these encrypted strings
    | will not be safe. Please do this before deploying an application!
    |
    */

    'key'                   => '8hDQvlSBszgRYYu9EmjXrN3GccZBE6XL',

    'cipher'                => MCRYPT_RIJNDAEL_128,

    /*
    |--------------------------------------------------------------------------
    | Autoloaded Service Providers
    |--------------------------------------------------------------------------
    |
    | The service providers listed here will be automatically loaded on the
    | request to your application. Feel free to add your own services to
    | this array to grant expanded functionality to your applications.
    |
    */

    'providers'             => array(

        'Illuminate\Foundation\Providers\ArtisanServiceProvider',
        'Illuminate\Auth\AuthServiceProvider',
        'Illuminate\Cache\CacheServiceProvider',
        'Illuminate\Session\CommandsServiceProvider',
        'Illuminate\Foundation\Providers\ConsoleSupportServiceProvider',
        'Illuminate\Routing\ControllerServiceProvider',
        'Illuminate\Cookie\CookieServiceProvider',
        'Illuminate\Database\DatabaseServiceProvider',
        'Illuminate\Encryption\EncryptionServiceProvider',
        'Illuminate\Filesystem\FilesystemServiceProvider',
        'Illuminate\Hashing\HashServiceProvider',
        'Illuminate\Html\HtmlServiceProvider',
        'Illuminate\Log\LogServiceProvider',
        'Illuminate\Mail\MailServiceProvider',
        'Illuminate\Database\MigrationServiceProvider',
        //'Illuminate\Pagination\PaginationServiceProvider',
        'DeSmart\Pagination\PaginationServiceProvider',
        'Illuminate\Queue\QueueServiceProvider',
        'Illuminate\Redis\RedisServiceProvider',
        'Illuminate\Remote\RemoteServiceProvider',
        'Illuminate\Auth\Reminders\ReminderServiceProvider',
        'Illuminate\Database\SeedServiceProvider',
        'Illuminate\Session\SessionServiceProvider',
        'Illuminate\Translation\TranslationServiceProvider',
        'Illuminate\Validation\ValidationServiceProvider',
        'Illuminate\View\ViewServiceProvider',
        'Illuminate\Workbench\WorkbenchServiceProvider',
        'Barryvdh\LaravelIdeHelper\IdeHelperServiceProvider',
        'Laracasts\Utilities\UtilitiesServiceProvider',
        'Monashee\PhpSimpleHtmlDomParser\PhpSimpleHtmlDomParserServiceProvider',
        'FruitcakeStudio\ReCaptcha\Support\Laravel\ServiceProvider',
        'Liebig\Cron\CronServiceProvider',
        'Spescina\Timthumb\TimthumbServiceProvider',
        'Bllim\Datatables\DatatablesServiceProvider',
        'Thujohn\Analytics\AnalyticsServiceProvider',
    ),

    /*
    |--------------------------------------------------------------------------
    | Service Provider Manifest
    |--------------------------------------------------------------------------
    |
    | The service provider manifest is used by Laravel to lazy load service
    | providers which are not needed for each request, as well to keep a
    | list of all of the services. Here, you may set its storage spot.
    |
    */

    'manifest'              => storage_path() . '/meta',

    /*
    |--------------------------------------------------------------------------
    | Class Aliases
    |--------------------------------------------------------------------------
    |
    | This array of class aliases will be registered when this application
    | is started. However, feel free to register as many as you wish as
    | the aliases are "lazy" loaded so they don't hinder performance.
    |
    */

    'aliases'               => array(

        'App'               => 'Illuminate\Support\Facades\App',
        'Artisan'           => 'Illuminate\Support\Facades\Artisan',
        'Auth'              => 'Illuminate\Support\Facades\Auth',
        'Blade'             => 'Illuminate\Support\Facades\Blade',
        'Cache'             => 'Illuminate\Support\Facades\Cache',
        'ClassLoader'       => 'Illuminate\Support\ClassLoader',
        'Config'            => 'Illuminate\Support\Facades\Config',
        'Controller'        => 'Illuminate\Routing\Controller',
        'Cookie'            => 'Illuminate\Support\Facades\Cookie',
        'Crypt'             => 'Illuminate\Support\Facades\Crypt',
        'DB'                => 'Illuminate\Support\Facades\DB',
        'Eloquent'          => 'Illuminate\Database\Eloquent\Model',
        'Event'             => 'Illuminate\Support\Facades\Event',
        'File'              => 'Illuminate\Support\Facades\File',
        'Form'              => 'Illuminate\Support\Facades\Form',
        'Hash'              => 'Illuminate\Support\Facades\Hash',
        'HTML'              => 'Illuminate\Support\Facades\HTML',
        'Input'             => 'Illuminate\Support\Facades\Input',
        'Lang'              => 'Illuminate\Support\Facades\Lang',
        'Log'               => 'Illuminate\Support\Facades\Log',
        'Mail'              => 'Illuminate\Support\Facades\Mail',
        'Paginator'         => 'Illuminate\Support\Facades\Paginator',
        'Password'          => 'Illuminate\Support\Facades\Password',
        'Queue'             => 'Illuminate\Support\Facades\Queue',
        'Redirect'          => 'Illuminate\Support\Facades\Redirect',
        'Redis'             => 'Illuminate\Support\Facades\Redis',
        'Request'           => 'Illuminate\Support\Facades\Request',
        'Response'          => 'Illuminate\Support\Facades\Response',
        'Route'             => 'Illuminate\Support\Facades\Route',
        'Schema'            => 'Illuminate\Support\Facades\Schema',
        'Seeder'            => 'Illuminate\Database\Seeder',
        'Session'           => 'Illuminate\Support\Facades\Session',
        'SoftDeletingTrait' => 'Illuminate\Database\Eloquent\SoftDeletingTrait',
        'SSH'               => 'Illuminate\Support\Facades\SSH',
        'Str'               => 'Illuminate\Support\Str',
        'URL'               => 'Illuminate\Support\Facades\URL',
        'Validator'         => 'Illuminate\Support\Facades\Validator',
        'View'              => 'Illuminate\Support\Facades\View',
        'ReCaptcha'         => 'FruitcakeStudio\ReCaptcha\Support\Laravel\Facade',
        'Timthumb'          => 'Spescina\Timthumb\Facades\Timthumb',
        'Datatables'        => 'Bllim\Datatables\Facade\Datatables',
        'Analytics'         => 'Thujohn\Analytics\AnalyticsFacade'
    ),

    'google_api_key'        => 'AIzaSyAOkmhXVRDhDxiN90WSdDAoXIEkNn_rFt4',
    'fb_link_stats_url'     => 'https://api.facebook.com/method/fql.query?query=%s&format=json',
    'twitter_count_url'     => 'http://cdn.api.twitter.com/1/urls/count.json?url=%s',
    'linkedin_count_url'    => 'http://www.linkedin.com/countserv/count/share?url=%s&callback=_',
    'pinterest_count_url'   => 'http://api.pinterest.com/v1/urls/count.json?url=%s&callback=_',
    'stumbleupon_count_url' => 'http://www.stumbleupon.com/services/1.01/badge.getinfo?url=%s',
    'google_plus_count_url' => 'https://clients6.google.com/rpc?key=AIzaSyCHA07oK_oLbqSy2I-2PhIauqxkvsgYuZ4',


    /* Meta Tag Filters */
    'meta_tags_filter'      => [
        'keywords',
        'description',
        'viewport',
        'subject',
        'copyright',
        'language',
        'robots',
        'revised',
        'abstract',
        'topic',
        'summary',
        'classification',
        'author',
        'designer',
        'copyright',
        'reply-to',
        'owner',
        'url',
        'identifier-url',
        'directory',
        'category',
        'coverage',
        'distribution',
        'rating',
        'revisit-after',
        'expires',
        'pragma',
        'cache-control',
        'content-type'
    ],

    'colors'                => [
        "#e95321",
        "#5b90bf",
        "#f1b300",
        "#fff116",
        "#a3be8c",
        "#96b5b4",
        "#8fa1b3",
        "#b48ead",
        "#ab7967",
        "#eeaf7c",
        "#2ca9af",
        "#c47938",
        "#9f1c32",
        "#58a56a",
        "#a7bcfd",
        "#f178a7",
        "#4d3a27",
        "#2f4247",
        "#565600",
        "#82c66d",
        "#de7a8a",
        "#d1ab3e",
        "#2559a1",
        "#5bc254",
        "#e07856",
        "#2b474c",
        "#1e9ee3",
        "#374773",
        "#e58f79",
        "#ccaa69",
        "#d93957",
        "#545e6b",
        "#ea7d58",
        "#cebca9",
        "#486d5b",
        "#9f4242",
        "#586d71",
        "#f22a9a",
        "#8259ab",
        "#63c5eb",
        "#d37e62",
        "#22cc37",
        "#2f50ac",
        "#1c54f5",
        "#a64847",
        "#9ba3ae",
        "#e67217",
        "#773000",
        "#643ea0",
        "#f65052",
        "#eab77d"
    ],

    /* ElasticSearch Settings */
    'elasticsearch_server'  => '127.0.0.1',
    'elasticsearch_index'   => 'hepoon',
    'elasticsearch_type'    => 'site',

    'link_limit'            => 50,
    'bing_account_key'      => 'FTXZNxBFEOkim57tUkxyaCRNLK7EyOOkwr0TPVzTxTs',

    'table_row_limit'       => 10,

    'sitemap_limit'         => 10000,

    'css_files'             => [
        'reset.css',
        'bootstrap.css',
        'font-awesome.min.css',
        'style.css',
        'shortcuts.css',
        'responsive.css',
        'bootstrap-dialog.css',
        'sweet-alert.css'
    ],


);
