<?php

View::composer('layouts.partials.sidebar.general', function($view)
{

    $settings = LSetting::getSettings();

    if($settings->cache_s_s){
        $remember = $settings->cache_s_et;
    }else{
        $remember = 0;
    }

    $view->with('randomCountries', CommonModel::getRandomCountries($settings->sidebar_countries_limit, $remember))
         ->with('recentWebSites', CommonModel::getRecentWebSites($settings->sidebar_analyzed_websites_limit, $remember));

});

View::composer(['layouts.master', 'layouts.partials.sidebar.general', 'detail', 'country', 'websites', 'contact', 'page', 'report'], function($view)
{
    $settings = LSetting::getSettings();
    $layout   = LSetting::getLayoutSettings();
    $languages = DBLang::languages();

    $currentLanguage = Session::get('lang');

    $view->with('settings', $settings)->with('layout', $layout)->with('languages', $languages)->with('currentLanguage', $currentLanguage);
});

View::composer('layouts.footer', function($view)
{
    $pages = Page::getAll();

    foreach($pages as $page){
        $page->page_title = json_decode($page->page_title, true);
    }

    $view->with('pages', $pages);
});

// Admin
View::composer(['admin.setting.ads', 'admin.setting.cache', 'admin.setting.captcha', 'admin.setting.comment', 'admin.setting.general', 'admin.setting.mail', 'admin.setting.pagination', 'admin.setting.sitemap', 'admin.setting.social-media', 'admin.setting.api-key', 'admin.website.deletion-requests', 'admin.dashboard.index'], function($view)
{
    $settings = LSetting::getSettings();

    $view->with('settings', $settings);
});