<?php
/********************************************************************************
 MachForm
  
 Copyright 2007-2014 Appnitro Software. This code cannot be redistributed without
 permission from http://www.appnitro.com/
 
 More info at: http://www.appnitro.com/
 ********************************************************************************/	
	require('includes/init.php');
	
	require('config.php');
	require('includes/db-core.php');
	require('includes/helper-functions.php');
	require('includes/check-session.php');
	
	require('includes/filter-functions.php');
	require('includes/entry-functions.php');
	require('lib/google-authenticator.php');

	$dbh = mf_connect_db();
	$mf_settings = mf_get_settings($dbh);
	
	$user_id = $_SESSION['mf_user_id'];

	$query = "SELECT 
					user_email,
					user_fullname,
					tsv_enable,
					tsv_code_log 
				FROM 
					".MF_TABLE_PREFIX."users 
			   WHERE 
			   		user_id=? and `status`=1";
	$params = array($user_id);
			
	$sth = mf_do_query($query,$params,$dbh);
	$row = mf_do_fetch_result($sth);

	$stored_user_email = $row['user_email'];
	$user_fullname 	   = $row['user_fullname'];
	$tsv_enable		   = (int) $row['tsv_enable'];
	$tsv_code_log	   = $row['tsv_code_log'];
	
	//2-Step Verification
	//if TSV currently not enabled, prepare secret key for TSV setup
	if(empty($tsv_enable)){
		$authenticator = new PHPGangsta_GoogleAuthenticator();

		$tsv_secret = $authenticator->createSecret();
		$totp_data  = "otpauth://totp/MachForm:{$stored_user_email}?secret={$tsv_secret}";
	}


	//handle form submission if there is any
	if(!empty($_POST['submit_form'])){

		$user_email = strtolower(trim($_POST['user_email']));
		
		//we need to check the email, ensure it's valid email address
		$email_regex  = '/^[A-z0-9][\w.-]*@[A-z0-9][\w\-\.]*\.[A-z0-9]{2,6}$/';
		$regex_result = preg_match($email_regex, $user_email);
			
		if(empty($regex_result)){
			$_SESSION['MF_ERROR'] = 'لطفا آدرس ایمیل معتبری را وارد کنید!';
		}else{
			//check for duplicate
			$query = "select count(user_email) total_user from `".MF_TABLE_PREFIX."users` where user_email = ? and user_id <> ? and `status` > 0";
				
			$params = array($user_email,$user_id);
			$sth = mf_do_query($query,$params,$dbh);
			$row = mf_do_fetch_result($sth);

			if(!empty($row['total_user'])){
				$_SESSION['MF_ERROR'] = 'این آدرس ایمیل در حال حاضر در حال استفاده میباشد.';
			}else{

				//update the email address and tsv setting
				if(!empty($_POST['tsv_enable'])){
					//only allow tsv_enable=1 when tsv has been verified previously
					$query 	= "SELECT tsv_code_log FROM ".MF_TABLE_PREFIX."users WHERE user_id=?";
					$params = array($user_id);
					
					$sth = mf_do_query($query,$params,$dbh);
					$row = mf_do_fetch_result($sth);

					$tsv_enable_status = 0;
					if(!empty($row['tsv_code_log'])){
						$tsv_enable_status = 1;
					}

					$query = "UPDATE ".MF_TABLE_PREFIX."users set user_email=?,tsv_enable=? where user_id=?";
					$params = array($user_email,$tsv_enable_status,$user_id);
					mf_do_query($query,$params,$dbh);
				}else{
					//if tsv being disabled, reset secret ket and previous tsv code log
					$query = "UPDATE ".MF_TABLE_PREFIX."users set user_email=?,tsv_enable=0,tsv_secret='',tsv_code_log='' where user_id=?";
					$params = array($user_email,$user_id);
					mf_do_query($query,$params,$dbh);
				}

				

				$_SESSION['MF_SUCCESS'] = 'پروفایل شما ذخیره شد.';

				$ssl_suffix = mf_get_ssl_suffix();						
				header("Location: http{$ssl_suffix}://".$_SERVER['HTTP_HOST'].mf_get_dirname($_SERVER['PHP_SELF'])."/my_account.php");
				exit;
			}
		}

	}else{
		$user_email = $stored_user_email;
	}
	

		$header_data =<<<EOT
<link type="text/css" href="js/jquery-ui/themes/base/jquery.ui.all.css" rel="stylesheet" />
EOT;

	$current_nav_tab = 'my_account';
	require('includes/header.php'); 
	
?>


		<div id="content" class="full">
			<div class="post main_settings">
				<div class="content_header">
					<div class="content_header_title">
						<div style="float: left">
							<h2>اکانت من <img src="images/icons/resultset_next.gif" /> <?php echo htmlspecialchars($user_fullname); ?></h2>
							<p>رمز عبور خود را تغییر دهید و یا برای ورود آدرس ایمیل.</p>
						</div>	
						
						<div style="clear: both; height: 1px"></div>
					</div>
					
				</div>

				<?php mf_show_message(); ?>

				<div class="content_body">
					
					<form id="ms_form" method="post" action="<?php echo htmlentities($_SERVER['PHP_SELF']); ?>">
					<ul id="ms_main_list">
						<li>
							<div id="ms_box_account" data-userid="<?php echo $user_id; ?>" class="ms_box_main gradient_blue">
								<div class="ms_box_title">
									<label class="choice">پروفایل اکانت من</label>
								</div>
								<div class="ms_box_email">
									<label class="description" for="user_email">آدرس ایمیل <span class="required">*</span> <img class="helpmsg" src="images/icons/68_blue.png" style="vertical-align: top" title="این آدرس ایمیل استفاده می شود برای ورود به پنل فرم ساز."/></label>
									<input id="user_email" name="user_email" class="element text medium" value="<?php echo htmlspecialchars($user_email,ENT_QUOTES); ?>" type="text">
									<a id="ms_change_password" href="#">تغییر رمز عبور</a>
								</div>
								<div>
								</div>
							</div>
						</li>
						<li>&nbsp;</li>
						<li>
							<div id="ms_box_user_tsv" class="ms_box_main gradient_red">
								<div class="ms_box_title">
									<input type="checkbox" value="1" class="checkbox" id="tsv_enable" name="tsv_enable" <?php if(!empty($tsv_enable)){ echo 'checked="checked"';} ?>>
									<label for="tsv_enable" class="choice">فعال کردن 2-مرحله تأیید صحت</label>
									<img class="helpmsg" src="images/icons/68_red.png" style="vertical-align: top" title="2-مرحله تأیید صحت یکی از ویژگی های امنیتی اختیاریست که بسیار توصیه می شود که امنیت را می افزاید ، می توانید بیفزایید یک لایه ی حفاظتی به فرمساز خود<br><br>پس از فعال سازی فرمساز یک کد امنیتی شش رقمی علاوه بر کلمه عبور خود به شما می دهد که در هر زمان برای ورود به آن نیاز داشته باشد."/>
								</div>
								<div class="ms_box_email" <?php if(empty($tsv_enable)){ echo 'style="display: none"'; } ?>>
									<?php
										if(!empty($tsv_enable)){
											echo "<h6>وضعیت 2-مرحله تأیید صحت &#8674; فعال شده</h6>";
										}else{
									?>

									<ul>
										<li class="tsv_setup_title">مرحله 1. باز کردن نرم افزار موبایل تأیید کننده اعتبار</li>
										<li>
											باز کردن نرم افزار موبایل تأیید کننده اعتبار. اگر شما نرم افزار را ندارید می توانید نصب کنید آن را از سایت های زیر:
											<div style="margin-top: 10px;padding-left: 20px">
											&#8674; <a class="app_link" href="http://support.google.com/accounts/bin/answer.py?hl=en&answer=1066447" target="_blank">تأیید کننده اعتبار گوگل</a> (Android/iPhone/BlackBerry)<br/>
											&#8674; <a class="app_link" href="http://guide.duosecurity.com/third-party-accounts" target="_blank">دو موبایل</a> (Android/iPhone)<br/>
											&#8674; <a class="app_link" href="http://www.amazon.com/gp/product/B0061MU68M" target="_blank">سایت آمازون AWS MFA</a> (Android)<br/>
											&#8674; <a class="app_link" href="http://www.windowsphone.com/en-US/apps/021dd79f-0598-e011-986b-78e7d1fa76f8" target="_blank">تأیید کننده اعتبار</a> (Windows Phone 7)<br />
                                            &#8674; <a class="app_link" href="http://www.khoein.ir/Google.Authenticator.apk" target="_blank">دانلود مستقیم نرم افزار از سایت پشتیبانی فارسی</a> (Android)
											</div>
										</li>
										<li class="tsv_setup_title">مرحله 2. اسکن بارکد</li>
										<li>
											شما می تواند اسکن کنید بارکد زیر را به وسیله ی نرم افزار تأیید کننده اعتبار:
											<div style="width: 80%;padding: 20px;text-align: center">
												<div id="qrcode" data-totpdata="<?php echo $totp_data; ?>" data-tsvsecret="<?php echo $tsv_secret; ?>"></div>
											</div>
											یا شما می توانید این کلید مخفی را دستی وارد کنید: <strong><?php echo $tsv_secret; ?></strong>
										</li>
										<li class="tsv_setup_title">مرحله 3. تأیید کد</li>
										<li>
											هنگامی که برنامه شما پیکربندی شده است،<strong> کد امنیتی شش رقمی</strong> ایجاد شده توسط برنامه خود را وارد کنید به منظور بررسی و تأیید صحت 2-مرحله:
											<label class="description" for="user_email">کد امنیتی</label>
											<input id="tsv_confirm_token" name="tsv_confirm_token" class="element text small" value="" type="text">
											<br/>
											<a style="margin-top: 10px" href="#" id="button_verify_tsv" class="bb_button bb_small bb_blue">
												تایید کد
											</a>
										</li>
									</ul>
									
									<?php } ?>
								</div>
							</div>
						</li>
						<li>&nbsp;</li>
						<li style="padding-top: 20px">
							
							<a href="#" id="button_save_main_settings" class="bb_button bb_small bb_green">
								<span class="icon-disk" style="margin-right: 5px"></span>ذخیره سازی تنظیمات
							</a>
							
						</li>		
					</ul>
					<input type="hidden" id="submit_form" name="submit_form" value="1">
					</form>

					<div id="dialog-change-password" title="تغییر کلمه عبور من" class="buttons" style="display: none"> 
						<form id="dialog-change-password-form" class="dialog-form" style="margin-bottom: 10px">				
							<ul>
								<li>
									<label for="dialog-change-password-input1" class="description">وارد کردن کلمه عبور جدید</label>
									<input type="password" id="dialog-change-password-input1" name="dialog-change-password-input1" class="text large" value="">
									<label for="dialog-change-password-input2" style="margin-top: 15px" class="description">تکرار کلمه عبور جدید</label>
									<input type="password" id="dialog-change-password-input2" name="dialog-change-password-input2" class="text large" value="">
									
								</li>
							</ul>
						</form>
					</div>

					<div id="dialog-password-changed" title="موفقیت آمیز!" class="buttons" style="display: none">
						<img src="images/icons/62_green_48.png" title="Success" /> 
						<p id="dialog-password-changed-msg">
								کلمه عبور جدید ذخیره شد.
						</p>
					</div>

					<div id="dialog-tsv-verified" title="موفقیت آمیز!" class="buttons" style="display: none">
						<img src="images/icons/62_green_48.png" title="موفقیت آمیز" /> 
						<p id="dialog-tsv-verified-msg">
								کد امنیتی تأیید شد.
						</p>
					</div>

					<div id="dialog-tsv-invalid" title="خطا!" class="buttons" style="display: none">
						<img src="images/icons/warning.png" title="خطا" /> 
						<p id="dialog-tsv-invalid-msg">
								کد امنیتی نامعتبر است. لطفا دوباره تلاش کنید.
						</p>
					</div>

				</div> <!-- /end of content_body -->	
			
			</div><!-- /.post -->
		</div><!-- /#content -->

 
<?php
	$footer_data =<<<EOT
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.core.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.widget.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.tabs.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.mouse.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.sortable.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.draggable.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.position.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.dialog.js"></script>
<script type="text/javascript" src="js/jquery.tools.min.js"></script>
<script type="text/javascript" src="js/qrcode/qrcode.js"></script>
<script type="text/javascript" src="js/my_account.js"></script>
EOT;

	require('includes/footer.php'); 
?>