<?php
/********************************************************************************
 MachForm
  
 Copyright 2007-2014 Appnitro Software. This code cannot be redistributed without
 permission from http://www.appnitro.com/
 
 More info at: http://www.appnitro.com/
 ********************************************************************************/	
	require('includes/init.php');
	
	require('config.php');
	require('includes/db-core.php');
	require('includes/helper-functions.php');
	require('includes/check-session.php');
	require('includes/post-functions.php');
	require('includes/filter-functions.php');
	

	$dbh = mf_connect_db();
	$mf_settings = mf_get_settings($dbh);

	//check user privileges, is this user has privilege to administer MachForm?
	if(empty($_SESSION['mf_user_privileges']['priv_administer'])){
		$_SESSION['MF_DENIED'] = "شما اجازه دسترسی به اداره فرم ساز را ندارید";

		$ssl_suffix = mf_get_ssl_suffix();						
		header("Location: http{$ssl_suffix}://".$_SERVER['HTTP_HOST'].mf_get_dirname($_SERVER['PHP_SELF'])."/restricted.php");
		exit;
	}

	//get the list of the form, put them into array
	$query = "SELECT 
					form_name,
					form_id
				FROM
					".MF_TABLE_PREFIX."forms
				WHERE
					form_active=0 or form_active=1
			 ORDER BY 
					form_name ASC";
	
	$params = array();
	$sth = mf_do_query($query,$params,$dbh);
	
	$form_list_array = array();
	$i=0;
	while($row = mf_do_fetch_result($sth)){
		$form_list_array[$i]['form_id']   	  = $row['form_id'];

		if(!empty($row['form_name'])){		
			$form_list_array[$i]['form_name'] = $row['form_name'];
		}else{
			$form_list_array[$i]['form_name'] = '-فرم بدون عنوان- (#'.$row['form_id'].')';
		}
		$i++;
	}
	
	if(mf_is_form_submitted()){ //if form submitted
		//get all required inputs
		$user_input['user_name'] 		= $_POST['au_user_name'];
		$user_input['user_email'] 		= strtolower($_POST['au_user_email']);
		$user_input['user_id'] 			= (int) $_POST['user_id'];
		$user_input['tsv_enable'] 		= (int) $_POST['au_tsv_enable'];

		$user_input['priv_new_forms'] 	= (int) $_POST['au_priv_new_forms'];
		$user_input['priv_new_themes'] 	= (int) $_POST['au_priv_new_themes'];
		$user_input['priv_administer'] 	= (int) $_POST['au_priv_administer'];

		if(empty($user_input['user_id'])){
			die('ID کاربر مورد نیاز است.');
		}

		//only administrator can modify himself
		if($user_input['user_id'] == 1 && $_SESSION['mf_user_id'] != 1){
			die("دسترسی ممنوع. شما اجازه ویرایش مدیر اصلی را ندارید.");
		}

		//make sure that Main Administrator privileges can't be modified
		if($user_input['user_id'] == 1){
			$user_input['priv_administer'] = 1;
		}

		//if the user has administer privileges, make sure to get all other privileges as well
		if(!empty($user_input['priv_administer'])){
			$user_input['priv_new_forms'] = 1;
			$user_input['priv_new_themes'] = 1;
		}

		foreach ($form_list_array as $value) {
			$form_id = $value['form_id'];

			$user_input['perm_editform_'.$form_id] 	  = (int) $_POST['perm_editform_'.$form_id];
			$user_input['perm_editentries_'.$form_id] = (int) $_POST['perm_editentries_'.$form_id];
			$user_input['perm_viewentries_'.$form_id] = (int) $_POST['perm_viewentries_'.$form_id];
		}
		//clean the inputs
		$user_input = mf_sanitize($user_input);

		//validate inputs
		$error_messages = array();

		//validate name
		if(empty($user_input['user_name'])){
			$error_messages['user_name'] = 'این فیلد مورد نیاز است . لطفا یک نام وارد نمایید';
		}

		//validate email
		if(empty($user_input['user_email'])){
			$error_messages['user_email'] = 'این فیلد مورد نیازاست . لطفا یک ایمیل وارد نمایید';
		}else{
			//check for valid email address
			$email_regex  = '/^[A-z0-9][\w.-]*@[A-z0-9][\w\-\.]*\.[A-z0-9]{2,6}$/';
			$regex_result = preg_match($email_regex, $user_input['user_email']);
				
			if(empty($regex_result)){
				//the email being entered is incorrectly formatted
				$error_messages['user_email'] = 'لطفا یک آدرس ایمیل معتبر وارد کنید.';
			}else{
				//check for duplicate
				$query = "select count(user_email) total_user from `".MF_TABLE_PREFIX."users` where user_email = ? and user_id <> ? and `status` > 0";
				
				$params = array($user_input['user_email'],$user_input['user_id']);
				$sth = mf_do_query($query,$params,$dbh);
				$row = mf_do_fetch_result($sth);

				if(!empty($row['total_user'])){
					$error_messages['user_email'] = 'این ایمیل قبلا مورد استفاده قرار گرفته است';
				}
			}
		}


		if(!empty($error_messages)){
			$_SESSION['MF_ERROR'] = 'لطفا تصحیح کنید فیلد (های) مشخص شده زیر را';
		}else{
			//everything is validated, continue updating user

			//update ap_users table
			$query = "UPDATE 
							`".MF_TABLE_PREFIX."users` 
						SET	
							`user_email`=?,  
							`user_fullname`=?, 
							`priv_administer`=?, 
							`priv_new_forms`=?, 
							`priv_new_themes`=?,
							`tsv_enable`=? 
					 WHERE  `user_id` = ?";
			$params = array(
							$user_input['user_email'],
							$user_input['user_name'],
							$user_input['priv_administer'],
							$user_input['priv_new_forms'],
							$user_input['priv_new_themes'],
							$user_input['tsv_enable'],
							$user_input['user_id']);
			mf_do_query($query,$params,$dbh);

			//when TSV being disabled, reset secret key and previous tsv code log
			if(empty($user_input['tsv_enable'])){
				$query = "UPDATE ".MF_TABLE_PREFIX."users set tsv_enable=0,tsv_secret='',tsv_code_log='' where user_id=?";
				$params = array($user_input['user_id']);
				mf_do_query($query,$params,$dbh);
			}

			//delete existing permissions
			$query = "DELETE from ".MF_TABLE_PREFIX."permissions WHERE user_id = ?";
			$params = array($user_input['user_id']);
			mf_do_query($query,$params,$dbh);

			//insert into ap_permissions table
			foreach ($form_list_array as $value) {
				$form_id = $value['form_id'];

				if(!empty($user_input['perm_editentries_'.$form_id])){
					$user_input['perm_viewentries_'.$form_id] = 1;
				}
				
				//if all permission are empty, don't do insert
				if(empty($user_input['perm_editform_'.$form_id]) && empty($user_input['perm_editentries_'.$form_id]) && empty($user_input['perm_viewentries_'.$form_id])){
					continue;
				}

				$params = array(
								$form_id, 
								$user_input['user_id'], 
								$user_input['perm_editform_'.$form_id], 
								$user_input['perm_editentries_'.$form_id], 
								$user_input['perm_viewentries_'.$form_id]);

				$query = "INSERT INTO 
									`".MF_TABLE_PREFIX."permissions` (
															`form_id`, 
															`user_id`, 
															`edit_form`, 
															`edit_entries`, 
															`view_entries`) 
								VALUES (?, ?, ?, ?, ?);";
				mf_do_query($query,$params,$dbh);
			}

			
			//redirect to manage_users page and display success message
			$_SESSION['MF_SUCCESS'] = 'کاربر #'.$user_input['user_id'].' بروزشد.';

			$ssl_suffix = mf_get_ssl_suffix();						
			header("Location: http{$ssl_suffix}://".$_SERVER['HTTP_HOST'].mf_get_dirname($_SERVER['PHP_SELF'])."/view_user.php?id=".$user_input['user_id']);
			exit;
		}
	}else{
		//populate user data
		$user_id = (int) trim($_GET['id']);
		
		if(empty($user_id)){
			die("Invalid Request");
		}

		//only administrator can modify himself
		if($user_id == 1 && $_SESSION['mf_user_id'] != 1){
			$_SESSION['MF_DENIED'] = "شما اجازه ویرایش مدیر اصلی را ندارید.";

			$ssl_suffix = mf_get_ssl_suffix();						
			header("Location: http{$ssl_suffix}://".$_SERVER['HTTP_HOST'].mf_get_dirname($_SERVER['PHP_SELF'])."/restricted.php");
			exit;

		}

		$user_input['user_id'] = $user_id;

		//get user profile data
		$query = "SELECT 
						user_email,
						user_fullname,
						priv_administer,
						priv_new_forms,
						priv_new_themes,
						last_login_date,
						last_ip_address,
						tsv_enable,
						`status` 
				    FROM 
						".MF_TABLE_PREFIX."users 
				   WHERE 
				   		user_id=? and `status` > 0";
		$params = array($user_id);
				
		$sth = mf_do_query($query,$params,$dbh);
		$row = mf_do_fetch_result($sth);

		$user_input['user_name']  		= $row['user_fullname'];
		$user_input['user_email'] 	    = $row['user_email'];
		$user_input['priv_new_forms'] 	= $row['priv_new_forms'];
		$user_input['priv_new_themes'] 	= $row['priv_new_themes'];
		$user_input['priv_administer'] 	= $row['priv_administer'];
		$user_input['tsv_enable'] 		= (int) $row['tsv_enable'];
 
		//if this user is admin, all privileges should be available
		if(!empty($user_input['priv_administer'])){
			$user_input['priv_new_forms'] = 1;
			$user_input['priv_new_themes'] = 1;
		}

		//get permission list for this user
		$query = "SELECT 
					A.form_id,
					A.edit_form,
					A.edit_entries,
					A.view_entries,
					B.form_name
			    FROM
			   		".MF_TABLE_PREFIX."permissions A LEFT JOIN ".MF_TABLE_PREFIX."forms B on A.form_id=B.form_id
			   WHERE 
			   		A.user_id = ? and (B.form_active=0 or B.form_active=1)
			ORDER BY 
					B.form_name ASC";
		$params = array($user_id);
				
		$sth = mf_do_query($query,$params,$dbh);
		
		while($row = mf_do_fetch_result($sth)){ 
			$form_id = (int) $row['form_id'];
		
			$user_input['perm_editform_'.$form_id] 	  = $row['edit_form'];
			$user_input['perm_editentries_'.$form_id] = $row['edit_entries'];
			$user_input['perm_viewentries_'.$form_id] = $row['view_entries'];
		}

	}
	
	$current_nav_tab = 'users';
	require('includes/header.php'); 
	
?>


		<div id="content" class="full">
			<div class="post add_user">
				<div class="content_header">
					<div class="content_header_title">
						<div style="float: left">
							<h2><a class="breadcrumb" href='manage_users.php'>مدیریت کاربران</a> <img src="images/icons/resultset_next.gif" /> <a class="breadcrumb" href='view_user.php?id=<?php echo $user_input['user_id']; ?>'>#<?php echo $user_input['user_id']; ?></a> <img src="images/icons/resultset_next.gif" /> ویرایش</h2>
							<p>در حال ویرایش کاربر #<?php echo $user_input['user_id']; ?></p>
						</div>
						
						<div style="clear: both; height: 1px"></div>
					</div>
					
				</div>
				
				<?php mf_show_message(); ?>

				<div class="content_body">
					<form id="add_user_form" method="post" action="<?php echo htmlentities($_SERVER['PHP_SELF']); ?>">
					<ul id="au_main_list">
						<li>
							<div id="au_box_user_profile" class="au_box_main gradient_blue">
								<div class="au_box_meta">
									<h1>1.</h1>
									<h6>ویرایش پروفایل</h6>
								</div>
								<div class="au_box_content" style="padding-bottom: 15px">
									<label class="description <?php if(!empty($error_messages['user_name'])){ echo 'label_red'; } ?>" for="au_user_name">نام <span class="required">*</span> <img class="helpmsg" src="images/icons/68_blue.png" style="vertical-align: top" title="نام و نام خانوادگی کاربر"/></label>
									<input id="au_user_name" name="au_user_name" class="element text large" value="<?php echo htmlspecialchars($user_input['user_name']); ?>" type="text">
									<?php
										if(!empty($error_messages['user_name'])){
											echo '<span class="au_error_span">'.$error_messages['user_name'].'</span>';
										}
									?>
									
									<label class="description <?php if(!empty($error_messages['user_email'])){ echo 'label_red'; } ?>" for="au_user_email">آدرس ایمیل <span class="required">*</span> <img class="helpmsg" src="images/icons/68_blue.png" style="vertical-align: top" title="ادرس ایمیل باید منحصر به فرد باشد . دو کاربر نمیتوانند یک ایمیل یکسان داشته باشند"/></label>
									<input id="au_user_email" name="au_user_email" class="element text large" value="<?php echo htmlspecialchars($user_input['user_email']); ?>" type="text">
									<?php
										if(!empty($error_messages['user_email'])){
											echo '<span class="au_error_span">'.$error_messages['user_email'].'</span>';
										}
									?>

									<div style="clear: both;margin-top: 10px"></div>
										
									<input id="au_tsv_enable" name="au_tsv_enable" class="checkbox" <?php if(!empty($user_input['tsv_enable'])){ echo 'checked="checked"'; } ?> value="1" type="checkbox" style="margin-left: 0px;">
									<label class="choice" for="au_tsv_enable">فعال کردن 2-مرحله تأیید صحت </label><img class="helpmsg" src="images/icons/68_blue.png" style="vertical-align: top" title="2-مرحله تأیید صحت یکی از ویژگی های امنیتی اختیاریست که یک لایه حفاظتی از لایه های حفاظتی مچ فرم محسوب می شود ، یکبار فعال کنید مچ فرم یک کد امنیتی شش رقمی علاوه بر رمز عبور استاندارد به کاربر برای اینکه هر زمان نیاز به ورود به سیستم داشته باشد می دهد."/>
								</div>
							</div>
						</li>
						<li class="ps_arrow"><img src="images/icons/33_orange.png" /></li>
						<li>
							<div id="au_box_privileges" class="au_box_main gradient_red">
								<div class="au_box_meta">
									<h1>2.</h1>
									<h6>ویرایش امتیازات</h6>
								</div>
								<div class="au_box_content" style="padding-top: 10px;min-height: 90px;">
										<input id="au_priv_new_forms" name="au_priv_new_forms" class="checkbox" <?php if(!empty($user_input['priv_new_forms'])){ echo 'checked="checked"'; } ?> value="1" type="checkbox" style="margin-left: 0px" <?php if(!empty($user_input['priv_administer'])){ echo 'disabled="disabled"'; } ?>>
										<label class="choice" for="au_priv_new_forms">اجازه به کاربر برای ایجاد فرم های جدید</label>
											
										<div style="clear: both;margin-top: 10px"></div>
										
										<input id="au_priv_new_themes" name="au_priv_new_themes" class="checkbox" <?php if(!empty($user_input['priv_new_themes'])){ echo 'checked="checked"'; } ?> value="1" type="checkbox" style="margin-left: 0px;" <?php if(!empty($user_input['priv_administer'])){ echo 'disabled="disabled"'; } ?>>
										<label class="choice" for="au_priv_new_themes">اجازه به کاربر برای ایجاد قالب های جدید</label>
										
										<div style="clear: both;margin-top: 10px"></div>
										
										<input id="au_priv_administer" name="au_priv_administer" class="checkbox" <?php if(!empty($user_input['priv_administer'])){ echo 'checked="checked"'; } ?> value="1" type="checkbox" style="margin-left: 0px;" <?php if($user_input['user_id'] == 1){ echo 'disabled="disabled"'; } ?>>
										<label class="choice" for="au_priv_administer">اجازه به کاربر برای اداره فرم ساز</label>
								</div>
							</div>
						</li>
						<li class="ps_arrow"><img src="images/icons/33_orange.png" /></li>
						<?php
							if(!empty($form_list_array)){
						?>
						<li class="user_permissions_list" <?php if(!empty($user_input['priv_administer'])){ echo 'style="display: none"'; } ?>>
							<div id="au_box_permissions" class="au_box_main gradient_green">
								<div class="au_box_meta">
									<h1>3.</h1>
									<h6>ویرایش مجوزها</h6>
								</div>
								<div class="au_box_content">
									<ul id="au_li_permissions">
										
										<?php
											foreach ($form_list_array as $value) {
												$form_id = $value['form_id'];

												if(!empty($user_input['perm_editform_'.$form_id])){
													$class_attr = 'class="highlight_red"';
												}else if(!empty($user_input['perm_editentries_'.$form_id])){
													$class_attr = 'class="highlight_yellow"';
												}else if(!empty($user_input['perm_viewentries_'.$form_id])){
													$class_attr = 'class="highlight_green"';
												}else{
													$class_attr = '';
												}
										?>
												<li id="li_<?php echo $form_id; ?>" <?php echo $class_attr; ?>>
													<div class="au_perm_title"><?php echo $value['form_name']; ?></div>
													<div class="au_perm_controls">
														<span class="au_perm_guide">اجازه کاربر به</span> <span class="au_perm_arrow">&#8674;</span>
														<input id="perm_editform_<?php echo $form_id; ?>" name="perm_editform_<?php echo $form_id; ?>" <?php if(!empty($user_input['perm_editform_'.$form_id])){ echo 'checked="checked"'; } ?> class="checkbox cb_editform" value="1" type="checkbox" style="margin-left: 5px">
														<label class="choice" for="perm_editform_<?php echo $form_id; ?>">ویرایش فرم</label>

														<input id="perm_editentries_<?php echo $form_id; ?>" name="perm_editentries_<?php echo $form_id; ?>" <?php if(!empty($user_input['perm_editentries_'.$form_id])){ echo 'checked="checked"'; } ?> class="checkbox cb_editentries" value="1" type="checkbox">
														<label class="choice" for="perm_editentries_<?php echo $form_id; ?>">ویرایش ورودی ها</label>

														<input id="perm_viewentries_<?php echo $form_id; ?>" name="perm_viewentries_<?php echo $form_id; ?>" <?php if(!empty($user_input['perm_viewentries_'.$form_id]) || !empty($user_input['perm_editentries_'.$form_id])){ echo 'checked="checked"'; } ?> class="checkbox cb_viewentries" <?php if(!empty($user_input['perm_editentries_'.$form_id])){ echo 'disabled="disabled"'; } ?> value="1" type="checkbox">
														<label class="choice" for="perm_viewentries_<?php echo $form_id; ?>">نمایش ورودی ها</label>
													</div>
												</li>
										<?php
											}
										?>
									</ul>
									<div id="au_bulk_select">
									<select class="element select" id="au_bulk_action" name="au_bulk_action">
											<option value="">مجموعه اقدامات</option> 
											<optgroup label="Select All:">
												<option value="select_editform">ویرایش فرم</option>
												<option value="select_editentries">ویرایش ورودی ها</option>
												<option value="select_viewentries">نمایش ورودی ها</option>
											</optgroup>
											<optgroup label="Unselect All:">
												<option value="unselect_editform">ویرایش فرم</option>
												<option value="unselect_editentries">ویرایش ورودی ها</option>
												<option value="unselect_viewentries">نمایش ورودی ها</option>
											</optgroup>
										</select>
									</div>
								</div>
							</div>
						</li>
						<li class="ps_arrow user_permissions_list" <?php if(!empty($user_input['priv_administer'])){ echo 'style="display: none"'; } ?>><img src="images/icons/33_orange.png" /></li>
						<?php } ?>
						<li>
							<div>
								<a href="#" id="button_edit_user" class="bb_button bb_small bb_green">
									<span class="icon-disk" style="margin-right: 5px"></span>									ذخیره تغییرات

								</a>
							</div>
						</li>	
					</ul>
					<input type="hidden" name="submit_form" value="1" />
					<input type="hidden" name="user_id" value="<?php echo (int) $user_input['user_id']; ?>" />
					</form>
					
				</div> <!-- /end of content_body -->	
			
			</div><!-- /.post -->
		</div><!-- /#content -->

 
<?php
	$footer_data =<<<EOT
<script type="text/javascript" src="js/jquery.tools.min.js"></script>
<script type="text/javascript" src="js/add_user.js"></script>
EOT;

	require('includes/footer.php'); 
?>