/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/


if(!dojo._hasResource["lucid.apps._App"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["lucid.apps._App"] = true;
dojo.provide("lucid.apps._App");

dojo.declare("lucid.apps._App", null, {
	name: "",
	sysname: "",
	version: "",
	instance: -1,
	status: "",
	iconClass: "",
	compatible: "",
	constructor: function(info){
		this.status = "init";
		this.name = info.name;
		this.id = this.sysname = this.declaredClass.substring(this.declaredClass.lastIndexOf(".")+1);
		this.iconClass = info.icon ? (info.icon.indexOf(".") === -1 ? info.icon : "icon-app-"+this.sysname) : "";
		dojo.connect(this, "kill", this, function(){
            this.status = "killed";
			var pid = this.instance;
			//allow the garbage collector to free up memory
			setTimeout(function(){
				lucid.app.instances[pid]=null;
			}, lucid.config.window.animSpeed + 1000);
        });
		this.instance = info.instance;
		this.compatible = info.compatible;
	},
	init: function(args){
		//	summary:
		//		start the app
		
		//since this is a base class for an app, we'll just kill ourselves
		//to prevent it from showing up on the task manager if it is
		//accidentally launched
		this.kill();
	},
	kill: function(){
		//	summary:
		//		cleanup ui, disconnect events, etc.
	}
})

}
