/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/


if(!dojo._hasResource["lucid.apps.Todo._base"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["lucid.apps.Todo._base"] = true;
dojo.provide("lucid.apps.Todo._base");
dojo.require("dojox.grid.DataGrid");
dojo.require("dijit.Toolbar");
dojo.require("dijit.form.Button");
dojo.requireLocalization("lucid.apps.Todo", "labels", null, "ROOT,es,fr");
dojo.requireLocalization("lucid", "apps", null, "ROOT,es,fr");
lucid.addDojoCss("dojox/grid/resources/Grid.css");

dojo.declare("lucid.apps.Todo", lucid.apps._App, {
    init: function(args){
        var labels = dojo.i18n.getLocalization("lucid.apps.Todo", "labels");
        var app = dojo.i18n.getLocalization("lucid", "apps");
        var win = this.win = new lucid.widget.Window({
            title: app["Todo"],
            width: "450px",
            height: "250px",
            onClose: dojo.hitch(this, "kill")
        });
        var toolbar = new dijit.Toolbar({
            region: "top"
        });
        var newTask = new dijit.form.Button({
            label: labels.newTask,
            iconClass: "icon-16-actions-list-add",
            onClick: dojo.hitch(this, "newTask")
        });
        toolbar.addChild(newTask);
        var removeTask = new dijit.form.Button({
            label: labels.removeTask,
            iconClass: "icon-16-actions-list-remove",
            onClick: dojo.hitch(this, "removeTask")
        });
        toolbar.addChild(removeTask);
        win.addChild(toolbar);
        
        var store = this.store = new lucid.Registry({
            name: "tasks",
            appname: this.sysname,
            data: {
                identifier: "id",
                items: []
            }
        });
        dojo.connect(store, "onSet", this, function(){ this.grid.setSortIndex(0, true); store.save(); });
		dojo.connect(store, "onDelete", function(){ store.save(); });
        dojo.connect(store, "onNew", function(){ store.save(); });

        var grid = this.grid = new dojox.grid.DataGrid({
            store: store,
            query: {id: "*"},
            structure: [{
				cells: [[
					{field: "complete", name: labels.complete, editable: true, type: dojox.grid.cells.Bool, sort: "desc"},
                    {field: "description", name: labels.description, width: "auto", editable: true, type: dojox.grid.cells.Cell},
                    {field: "category", name: labels.category, editable: true, type: dojox.grid.cells.ComboBox, options: [], hidden: true} //hidden until we get this implemented
				]]
			}]
        });
        var content = this.content = new dijit.layout.ContentPane({region: "center"});
        content.setContent(grid);
        win.addChild(content);
        win.show();
        grid.startup();
        setTimeout(dojo.hitch(grid, "setSortIndex", 0, true), 200);
    },
    newTask: function(){
        var labels = dojo.i18n.getLocalization("lucid.apps.Todo", "labels");
        this.store.newItem({
            id: (new Date()).toString(),
            complete: false,
            description: labels.newTask,
            category: ""
        });
    },
    removeTask: function(){
        this.grid.removeSelectedRows();
    },
    kill: function(){
        if(!this.win.closed)
            this.win.close();
    }
});

}
