/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(!dojo._hasResource["lucid.apps.TextEditor"]){dojo._hasResource["lucid.apps.TextEditor"]=true;dojo.provide("lucid.apps.TextEditor");dojo.declare("lucid.apps.TextEditor",lucid.apps._App,{newAs:false,editing:false,fileEditing:"",kill:function(){if(!this.window.closed){this.window.close();}},init:function(_1){var cm=dojo.i18n.getLocalization("lucid","common");var _3=dojo.i18n.getLocalization("lucid","apps");var _4=dojo.i18n.getLocalization("lucid","messages");this.window=new lucid.widget.Window({title:_3["Text Editor"],iconClass:this.iconClass,onClose:dojo.hitch(this,"kill")});var _5=new dijit.Toolbar({region:"top"});_5.addChild(new dijit.form.Button({label:cm["new"],onClick:dojo.hitch(this,this.processNew),iconClass:"icon-16-actions-document-open"}));_5.addChild(new dijit.form.Button({label:cm.open,onClick:dojo.hitch(this,this.processOpen),iconClass:"icon-16-actions-document-open"}));_5.addChild(new dijit.form.Button({label:cm.save,onClick:dojo.hitch(this,this.processSave),iconClass:"icon-16-actions-document-save"}));_5.addChild(new dijit.form.Button({label:cm.saveAs,onClick:dojo.hitch(this,this.processSaveAs),iconClass:"icon-16-actions-document-save-as"}));_5.addChild(new dijit.form.Button({label:cm.close,onClick:dojo.hitch(this,this.processClose),iconClass:"icon-16-actions-process-stop"}));this.window.addChild(_5);this.statusbar=new lucid.widget.StatusBar({region:"bottom"});this.editor=new dijit.form.SimpleTextarea({region:"center"});this.statusbar.attr("label",_4.noFileOpen);this.window.addChild(this.editor);this.window.addChild(this.statusbar);this.editor.setDisabled(true);this.window.show();this.window.startup();if(_1.file){this._processOpen(_1.file);}else{this.processNew();}},updateTitle:function(_6){var _7=dojo.i18n.getLocalization("lucid","apps");if(!_6){return this.window.attr("title",_7["Text Editor"]);}var _8=_6.split("/");this.window.attr("title",_8[_8.length-1]+" - "+_7["Text Editor"]);},processNew:function(){var _9=dojo.i18n.getLocalization("lucid","messages");var cm=dojo.i18n.getLocalization("lucid","common");this.editor.setDisabled(false);this.editor.setValue("");this.editing=false;this.fileEditing="";this.newAs=true;this.statusbar.attr("label",_9.editingFile.replace("%s",cm.untitled));this.updateTitle(cm.untitled);},processClose:function(){var _b=dojo.i18n.getLocalization("lucid","messages");this.editor.setDisabled(true);this.editor.setValue("");this.newAs=false;this.editing=false;this.fileEditing="";this.statusbar.attr("label",_b.noFileOpen);this.updateTitle(false);},processOpen:function(){var _c=dojo.i18n.getLocalization("lucid","messages");lucid.dialog.file({title:_c.chooseFileOpen,onComplete:dojo.hitch(this,"_processOpen")});},_processOpen:function(_d){if(_d==false){return false;}this.updateTitle(_d);var _e=dojo.i18n.getLocalization("lucid","messages");this.statusbar.attr("label",_e.openingFile.replace("%s",_d));this.newAs=true;this.editor.setDisabled(true);lucid.filesystem.readFileContents(_d,dojo.hitch(this,function(_f){this.editor.setValue(_f);this.editing=true;this.newAs=true;this.editor.setDisabled(false);this.fileEditing=_d;this.statusbar.attr("label",_e.editingFile.replace("%s",_d));}));},processSave:function(){var msg=dojo.i18n.getLocalization("lucid","messages");if(this.editing){lucid.filesystem.writeFileContents(this.fileEditing,this.editor.getValue());this.statusbar.attr("label",msg.fileSaved);}else{this.processSaveAs();}},processSaveAs:function(){var msg=dojo.i18n.getLocalization("lucid","messages");if(this.newAs){lucid.dialog.file({title:msg.chooseFileSave,onComplete:dojo.hitch(this,function(_12){if(_12==false){return false;}this.editing=true;this.fileEditing=_12;this.newAs=true;this.processSave();this.updateTitle(_12);})});}}});}dojo.i18n._preloadLocalizations("lucid.apps.nls.TextEditor",["ROOT","en","en-gb","en-us","es","es-es","fr","fr-fr","xx"]);
