/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(!dojo._hasResource["lucid.apps.MusicPlayer"]){dojo._hasResource["lucid.apps.MusicPlayer"]=true;dojo.provide("lucid.apps.MusicPlayer");dojo.declare("lucid.apps.MusicPlayer",lucid.apps._App,{init:function(_1){var _2=this.nls=dojo.i18n.getLocalization("lucid","common");var _3=dojo.i18n.getLocalization("lucid","apps");this.win=new lucid.widget.Window({title:_3["Music Player"],width:"500px",height:"150px",iconClass:this.iconClass,onClose:dojo.hitch(this,"kill")});var _4=new dijit.Toolbar({region:"top"});dojo.forEach([{label:_2.openFile,iconClass:"icon-16-actions-document-open",onClick:dojo.hitch(this,this.openFileDialog)},{label:_2.openUrl,iconClass:"icon-16-actions-document-open",onClick:dojo.hitch(this,this.openURLDialog)}],function(_5){_4.addChild(new dijit.form.Button(_5));});this.win.addChild(_4);var _6=new dijit.form.VerticalSlider({onChange:dojo.hitch(this,function(_7){this.sound.volume(_7);dojo.removeClass(this.ui.volume.iconNode,"icon-32-status-audio-volume-high");dojo.removeClass(this.ui.volume.iconNode,"icon-32-status-audio-volume-medium");dojo.removeClass(this.ui.volume.iconNode,"icon-32-status-audio-volume-low");dojo.removeClass(this.ui.volume.iconNode,"icon-32-status-audio-volume-muted");if(_7==0){dojo.addClass(this.ui.volume.iconNode,"icon-32-status-audio-volume-muted");}else{if(_7>0&&_7<33){dojo.addClass(this.ui.volume.iconNode,"icon-32-status-audio-volume-low");}else{if(_7>=33&&_7<=66){dojo.addClass(this.ui.volume.iconNode,"icon-32-status-audio-volume-medium");}else{dojo.addClass(this.ui.volume.iconNode,"icon-32-status-audio-volume-high");}}}}),value:100,style:"height: 100px; background-color: white;"});this.ui={play:new dijit.form.Button({iconClass:"icon-32-actions-media-playback-start",onClick:dojo.hitch(this,this.play),showLabel:false,label:_2.play}),stop:new dijit.form.Button({iconClass:"icon-32-actions-media-playback-stop",onClick:dojo.hitch(this,this.stop),showLabel:false,label:_2.stop}),ticker:document.createElement("div"),volume:new dijit.form.DropDownButton({dropDown:_6,label:_2.volume,iconClass:"icon-32-status-audio-volume-high",showLabel:false}),slider:new dijit.form.HorizontalSlider({showButtons:false,style:"width: 100%;",onChange:dojo.hitch(this,this.skip)})};dojo.connect(this.ui.slider.domNode,"onmousedown",this,function(){this.stopTicker();});var _8=this.ui.ticker;dojo.style(_8,{border:"1px solid gray",backgroundColor:"black",color:"gray",width:"60%",position:"relative"});_8.innerHTML="&nbsp;0:00/00:00&nbsp;";var _9=new dijit.Toolbar({region:"center"});for(var _a in this.ui){var _b=this.ui[_a];if(_b.declaredClass=="dijit.form.Button"){dojo.style(_b.domNode,"width","40px");}if(_b.declaredClass){_9.addChild(_b);}else{var _c=this.box=new dijit.layout.ContentPane({},_b);_9.addChild(_c);dojo.removeClass(_c.domNode,"dijitContentPane");dojo.addClass(_c.domNode,"dijitInline");}}this.win.addChild(_9);this.win.show();this.win.startup();if(_1.file){this.openFile(_1.file);}else{if(_1.url){this.openURL(_1.url);}}},updateTitle:function(_d){var _e=dojo.i18n.getLocalization("lucid","apps");if(!_d){return this.win.attr("title",_e["Music Player"]);}this.win.attr("title",_d+" - "+_e["Music Player"]);},sound:false,play:function(){if(this.sound){this.is_playing=true;this.sound.play();if(this.sound.capabilities.pause){dojo.removeClass(this.ui.play.iconNode,"icon-32-actions-media-playback-start");dojo.addClass(this.ui.play.iconNode,"icon-32-actions-media-playback-pause");this.ui.play.setLabel(this.nls.pause);this.ui.play.onClick=dojo.hitch(this,this.pause);}this.ui.play.startup();this.startTicker();}},pause:function(){if(this.sound&&this.sound.capabilities.pause){this.is_playing=false;this.sound.pause();dojo.removeClass(this.ui.play.iconNode,"icon-32-actions-media-playback-pause");dojo.addClass(this.ui.play.iconNode,"icon-32-actions-media-playback-start");this.ui.play.setLabel(this.nls.play);this.ui.play.onClick=dojo.hitch(this,this.play);this.stopTicker();}},skip:function(_f){if(!this.ignoreOnChange){var d=this.sound.duration();this.sound.position((_f/100)*d);if(this.is_playing){this.sound.play();this.startTicker();}}},stop:function(){if(this.sound){this.is_playing=false;dojo.removeClass(this.ui.play.iconNode,"icon-32-actions-media-playback-pause");dojo.addClass(this.ui.play.iconNode,"icon-32-actions-media-playback-start");this.ui.play.setLabel(this.nls.play);this.ui.play.onClick=dojo.hitch(this,this.play);this.sound.stop();this.stopTicker();this.ui.slider.setValue(0);}},openURLDialog:function(){lucid.dialog.input({title:this.nls.openUrl,onComplete:dojo.hitch(this,this.openURL)});},openURL:function(_11){if(_11){this.sound=new lucid.Sound({src:_11});this.play();_11=_11.split("/");this.filename=_11.pop();}},openFileDialog:function(){lucid.dialog.file({title:"Select audio file to open",onComplete:dojo.hitch(this,this.openFile)});},openFile:function(_12){if(_12){this.sound=new lucid.Sound({src:lucid.filesystem.embed(_12)});this.play();_12=_12.split("/");this.filename=_12.pop();}},startTicker:function(){if(!this.__ticker){this.__ticker=setInterval(dojo.hitch(this,"updateTicker"),1000);}},stopTicker:function(){clearInterval(this.__ticker);this.__ticker=false;},updateTicker:function(){var c=this.sound.capabilities;if(c.id3){var i=this.sound.id3();}if(c.id3&&i){var _15="<div>"+i.songname+"</div><div>"+i.artist+" - "+i.album+"</div>";this.updateTitle(i.songname+" by "+i.artist);}else{var _15=this.filename;this.updateTitle(this.filename);}if(!(c.position&&c.duration)){this.box.domNode.innerHTML=_15+"<div style='position: absolute; top:25%; right: 0px;'>"+"?:??/?:??"+"</div>";return;}var p=this.sound.position();var d=this.sound.duration();if(d==0){d=p+1;}if(p==d){this.stop();}this.ignoreOnChange=true;this.ui.slider.setValue(Math.floor((p/d)*100));this.ignoreOnChange=false;var pos=this.formatTime(p);var dur=this.formatTime(d);this.box.domNode.innerHTML=_15+"<div style='position: absolute; top:25%; right: 0px;'>"+pos+"/"+dur+"</div>";},formatTime:function(ms){var ts=ms/1000;var m=Math.floor((ts/60));var s=Math.floor(ts%60);if(s==60){m++;s=0;}return m+":"+(s<10?"0"+s:s);},kill:function(){this.stopTicker();if(this.sound){this.sound.destroy();}if(!this.win.closed){this.win.close();}}});}dojo.i18n._preloadLocalizations("lucid.apps.nls.MusicPlayer",["ROOT","en","en-gb","en-us","es","es-es","fr","fr-fr","xx"]);
