/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(!dojo._hasResource["dojox.gfx.matrix"]){dojo._hasResource["dojox.gfx.matrix"]=true;dojo.provide("dojox.gfx.matrix");(function(){var m=dojox.gfx.matrix;var _2={};m._degToRad=function(_3){return _2[_3]||(_2[_3]=(Math.PI*_3/180));};m._radToDeg=function(_4){return _4/Math.PI*180;};m.Matrix2D=function(_5){if(_5){if(typeof _5=="number"){this.xx=this.yy=_5;}else{if(_5 instanceof Array){if(_5.length>0){var _6=m.normalize(_5[0]);for(var i=1;i<_5.length;++i){var l=_6,r=dojox.gfx.matrix.normalize(_5[i]);_6=new m.Matrix2D();_6.xx=l.xx*r.xx+l.xy*r.yx;_6.xy=l.xx*r.xy+l.xy*r.yy;_6.yx=l.yx*r.xx+l.yy*r.yx;_6.yy=l.yx*r.xy+l.yy*r.yy;_6.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_6.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}dojo.mixin(this,_6);}}else{dojo.mixin(this,_5);}}}};dojo.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});dojo.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_e){var c=Math.cos(_e);var s=Math.sin(_e);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_11){return m.rotate(m._degToRad(_11));},skewX:function(_12){return new m.Matrix2D({xy:Math.tan(_12)});},skewXg:function(_13){return m.skewX(m._degToRad(_13));},skewY:function(_14){return new m.Matrix2D({yx:Math.tan(_14)});},skewYg:function(_15){return m.skewY(m._degToRad(_15));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_22){return (_22 instanceof m.Matrix2D)?_22:new m.Matrix2D(_22);},clone:function(_23){var obj=new m.Matrix2D();for(var i in _23){if(typeof (_23[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_23[i]){obj[i]=_23[i];}}return obj;},invert:function(_26){var M=m.normalize(_26),D=M.xx*M.yy-M.xy*M.yx,M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_29,x,y){return {x:_29.xx*x+_29.xy*y+_29.dx,y:_29.yx*x+_29.yy*y+_29.dy};},multiplyPoint:function(_2c,a,b){var M=m.normalize(_2c);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiply:function(_30){var M=m.normalize(_30);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_35,x,y){return m.multiply(m.translate(x,y),_35,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_3c,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_3c),a,b);}return m._sandwich(m.rotate(_3c),a.x,a.y);},rotategAt:function(_3f,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_3f),a,b);}return m._sandwich(m.rotateg(_3f),a.x,a.y);},skewXAt:function(_42,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_42),a,b);}return m._sandwich(m.skewX(_42),a.x,a.y);},skewXgAt:function(_45,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_45),a,b);}return m._sandwich(m.skewXg(_45),a.x,a.y);},skewYAt:function(_48,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_48),a,b);}return m._sandwich(m.skewY(_48),a.x,a.y);},skewYgAt:function(_4b,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_4b),a,b);}return m._sandwich(m.skewYg(_4b),a.x,a.y);}});})();dojox.gfx.Matrix2D=dojox.gfx.matrix.Matrix2D;}if(!dojo._hasResource["dojox.gfx._base"]){dojo._hasResource["dojox.gfx._base"]=true;dojo.provide("dojox.gfx._base");(function(){var g=dojox.gfx,b=g._base;g._hasClass=function(_50,_51){var cls=_50.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_51+" ")>=0;};g._addClass=function(_53,_54){var cls=_53.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_54+" ")<0){_53.setAttribute("className",cls+(cls?" ":"")+_54);}};g._removeClass=function(_56,_57){var cls=_56.getAttribute("className");if(cls){_56.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_57+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _59={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};if(dojo.isIE){dojo.doc.documentElement.style.fontSize="100%";}var div=dojo.doc.createElement("div");var s=div.style;s.position="absolute";s.left="-100px";s.top="0px";s.width="30px";s.height="1000em";s.border="0px";s.margin="0px";s.padding="0px";s.outline="none";s.lineHeight="1";s.overflow="hidden";dojo.body().appendChild(div);for(var p in _59){div.style.fontSize=p;_59[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}dojo.body().removeChild(div);div=null;return _59;};var _5d=null;b._getCachedFontMeasurements=function(_5e){if(_5e||!_5d){_5d=b._getFontMeasurements();}return _5d;};var _5f=null,_60={};b._getTextBox=function(_61,_62,_63){var m,s;if(!_5f){m=_5f=dojo.doc.createElement("div");s=m.style;s.position="absolute";s.left="-10000px";s.top="0";dojo.body().appendChild(m);}else{m=_5f;s=m.style;}m.className="";s.border="0";s.margin="0";s.padding="0";s.outline="0";if(arguments.length>1&&_62){for(var i in _62){if(i in _60){continue;}s[i]=_62[i];}}if(arguments.length>2&&_63){m.className=_63;}m.innerHTML=_61;return dojo.marginBox(m);};var _67=0;b._getUniqueId=function(){var id;do{id=dojo._scopeName+"Unique"+(++_67);}while(dojo.byId(id));return id;};})();dojo.mixin(dojox.gfx,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _69={};return function(_6a){var t=_69[_6a];if(t){return new t();}t=_69[_6a]=function(){};t.prototype=dojox.gfx["default"+_6a];return new t();};})(),normalizeColor:function(_6c){return (_6c instanceof dojo.Color)?_6c:new dojo.Color(_6c);},normalizeParameters:function(_6d,_6e){if(_6e){var _6f={};for(var x in _6d){if(x in _6e&&!(x in _6f)){_6d[x]=_6e[x];}}}return _6d;},makeParameters:function(_71,_72){if(!_72){return dojo.delegate(_71);}var _73={};for(var i in _71){if(!(i in _73)){_73[i]=dojo.clone((i in _72)?_72[i]:_71[i]);}}return _73;},formatNumber:function(x,_76){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _78=val.indexOf(".");if(_78>=0&&val.length-_78>5){val=x.toFixed(4);}}if(x<0){return val;}return _76?" "+val:val;},makeFontString:function(_79){return _79.style+" "+_79.variant+" "+_79.weight+" "+_79.size+" "+_79.family;},splitFontString:function(str){var _7b=dojox.gfx.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}_7b.style=t[0];_7b.varian=t[1];_7b.weight=t[2];var i=t[3].indexOf("/");_7b.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;break;}if(t[4].substr(0,1)=="/"){j=5;break;}}if(j+3>t.length){break;}_7b.size=t[j];_7b.family=t[j+1];}while(false);return _7b;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return dojox.gfx._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*dojox.gfx.px_in_pt();},px2pt:function(len){return len/dojox.gfx.px_in_pt();},normalizedLength:function(len){if(len.length==0){return 0;}if(len.length>2){var _82=dojox.gfx.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_82;case "in":return val*72*_82;case "pc":return val*12*_82;case "mm":return val*dojox.gfx.mm_in_pt*_82;case "cm":return val*dojox.gfx.cm_in_pt*_82;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-Za-z])|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,equalSources:function(a,b){return a&&b&&a==b;}});}if(!dojo._hasResource["dojox.gfx"]){dojo._hasResource["dojox.gfx"]=true;dojo.provide("dojox.gfx");dojo.loadInit(function(){var gfx=dojo.getObject("dojox.gfx",true),sl,_88,_89;if(!gfx.renderer){var _8a=(typeof dojo.config.gfxRenderer=="string"?dojo.config.gfxRenderer:"svg,vml,silverlight,canvas").split(",");var ua=navigator.userAgent,_8c=0,_8d=0;if(dojo.isSafari>=3){if(ua.indexOf("iPhone")>=0||ua.indexOf("iPod")>=0){_89=ua.match(/Version\/(\d(\.\d)?(\.\d)?)\sMobile\/([^\s]*)\s?/);if(_89){_8c=parseInt(_89[4].substr(0,3),16);}}}if(dojo.isWebKit){if(!_8c){_89=ua.match(/Android\s+(\d+\.\d+)/);if(_89){_8d=parseFloat(_89[1]);}}}for(var i=0;i<_8a.length;++i){switch(_8a[i]){case "svg":if(!dojo.isIE&&(!_8c||_8c>=1521)&&!_8d&&!dojo.isAIR){dojox.gfx.renderer="svg";}break;case "vml":if(dojo.isIE){dojox.gfx.renderer="vml";}break;case "silverlight":try{if(dojo.isIE){sl=new ActiveXObject("AgControl.AgControl");if(sl&&sl.IsVersionSupported("1.0")){_88=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_88=true;}}}catch(e){_88=false;}finally{sl=null;}if(_88){dojox.gfx.renderer="silverlight";}break;case "canvas":if(!dojo.isIE){dojox.gfx.renderer="canvas";}break;}if(dojox.gfx.renderer){break;}}if(dojo.config.isDebug){console.log("gfx renderer = "+dojox.gfx.renderer);}}});dojo.requireIf(dojox.gfx.renderer=="svg","dojox.gfx.svg");dojo.requireIf(dojox.gfx.renderer=="vml","dojox.gfx.vml");dojo.requireIf(dojox.gfx.renderer=="silverlight","dojox.gfx.silverlight");dojo.requireIf(dojox.gfx.renderer=="canvas","dojox.gfx.canvas");}if(!dojo._hasResource["lucid.apps.MineSweep"]){dojo._hasResource["lucid.apps.MineSweep"]=true;dojo.provide("lucid.apps.MineSweep");dojo.declare("lucid.apps.MineSweep",lucid.apps._App,{difficulty:"Easy",board:0,xSize:0,ySize:0,squaresRevealed:0,totalSquares:0,squaresToWin:0,resultShade:0,resultMessage:0,init:function(_8f){var nls=dojo.i18n.getLocalization("lucid","games");var app=dojo.i18n.getLocalization("lucid","apps");this.win=new lucid.widget.Window({title:app["MineSweep"],width:"200px",height:"230px",iconClass:this.iconClass,resizable:false,showMaximize:false,onClose:dojo.hitch(this,this.kill)});this.toolbar=new dijit.Toolbar({region:"top"});this.toolbar.addChild(new dijit.form.Button({label:nls.start,onClick:dojo.hitch(this,"startGame")}));this.win.addChild(this.toolbar);var _92=new dijit.form.FilteringSelect({autoComplete:true,searchAttr:"label",style:"width: 90px; font-size: small",store:new dojo.data.ItemFileReadStore({data:{identifier:"value",items:[{label:nls.easy,value:"Easy"},{label:nls.medium,value:"Medium"},{label:nls.hard,value:"Hard"}]}}),onChange:dojo.hitch(this,function(val){if(typeof val=="undefined"){return;}this.difficulty=val;})});this.toolbar.addChild(_92);this.surfacePane=new dijit.layout.ContentPane({region:"center",style:"overflow: hidden"});this.surface=dojox.gfx.createSurface(this.surfacePane.containerNode,600,600);this.win.addChild(this.surfacePane);this.win.show();this.win.startup();_92.textbox.disabled=true;_92.setValue("Easy");dojo.connect(this.surfacePane.containerNode,"oncontextmenu",dojo,"stopEvent");this.makeBoard(10,10);setTimeout(dojo.hitch(this,function(){var _94=this.toolbar.domNode.offsetHeight;this.win.resize({width:"200px",height:(200+_94)+"px"});}),200);},startGame:function(){var _95=this.toolbar.domNode.offsetHeight;if(this.difficulty=="Easy"){this.win.resize({width:"200px",height:(200+_95)+"px"});this.surface.clear();this.makeBoard(10,10);}else{if(this.difficulty=="Medium"){this.win.resize({width:"300px",height:(300+_95)+"px"});this.surface.clear();this.makeBoard(15,15);}else{if(this.difficulty=="Hard"){this.win.resize({width:"600px",height:(300+_95)+"px"});this.surface.clear();this.makeBoard(30,15);}}}},makeBoard:function(_96,_97){this.xSize=_96;this.ySize=_97;this.squaresRevealed=0;this.totalSquares=0;this.squaresToWin=0;var a=0;var b=0;this.board=new Array();for(b=0;b<_96;b++){this.board[b]=new Array();for(a=0;a<_97;a++){this.board[b][a]=this.makeSquare(b,a);this.totalSquares++;}}this.squaresToWin=this.totalSquares;this.makeMines();this.assignNums();console.debug("Total: "+this.totalSquares+", To win: "+this.squaresToWin);},makeMines:function(){var a=0;var _9b=0;if(this.difficulty=="Easy"){_9b=10;}if(this.difficulty=="Medium"){_9b=34;}if(this.difficulty=="Hard"){_9b=90;}for(a=0;a<_9b;a++){var _9c=Math.floor(Math.random()*this.xSize);var _9d=Math.floor(Math.random()*this.ySize);this.board[_9c][_9d].hasMine=true;this.board[_9c][_9d].numMines=0;this.squaresToWin--;}},assignNums:function(){var a=0;var b=0;var _a0=0;for(b=0;b<this.xSize;b++){for(a=0;a<this.ySize;a++){_a0=0;if(a>0){if(this.board[b][a-1].hasMine==true){_a0++;}}if(a>0&&b<(this.xSize-1)){if(this.board[b+1][a-1].hasMine==true){_a0++;}}if(b<(this.xSize-1)){if(this.board[b+1][a].hasMine==true){_a0++;}}if(a<(this.ySize-1)&&b<(this.xSize-1)){if(this.board[b+1][a+1].hasMine==true){_a0++;}}if(a<(this.ySize-1)){if(this.board[b][a+1].hasMine==true){_a0++;}}if(b>0&&a<(this.ySize-1)){if(this.board[b-1][a+1].hasMine==true){_a0++;}}if(b>0){if(this.board[b-1][a].hasMine==true){_a0++;}}if(b>0&&a>0){if(this.board[b-1][a-1].hasMine==true){_a0++;}}this.board[b][a].numMines=_a0;}}},makeSquare:function(_a1,_a2){var _a3=this.surface.createRect({x:_a1*20,y:_a2*20,width:20,height:20});this.squareFillNormal(_a3);_a3.mouseover=_a3.connect("onmouseover",this,function blah(){this.squareFillOver(_a3);});_a3.mouseout=_a3.connect("onmouseout",this,function blah2(){this.squareFillNormal(_a3);});_a3.mousedown=_a3.connect("onmouseup",this,function(e){dojo.stopEvent(e);if(e.button==2){this.squareFillMarked(_a3);}else{this.squareReveal(_a3);}return false;});_a3.mouseright=_a3.connect("oncontextmenu",this,function(e){dojo.stopEvent(e);});_a3.revealed=false;_a3.numMines=0;_a3.hasMine=false;_a3.marked=false;_a3.xPos=_a1;_a3.yPos=_a2;return _a3;},gameOver:function(){this.resultShade=this.surface.createRect({x:0,y:0,width:(this.xSize*20),height:(this.ySize*20)}).setFill([225,225,225,0.75]);var nls=dojo.i18n.getLocalization("lucid","games");this.resultMessage=this.surface.createText({x:((this.xSize*20)/2),y:((this.ySize*20)/2),text:nls.youLose,align:"middle"}).setFill("#000000");this.resultMessage.setFont({weight:"bold",size:20});},gameWin:function(){this.resultShade=this.surface.createRect({x:0,y:0,width:(this.xSize*20),height:(this.ySize*20)}).setFill([225,225,225,0.75]);var nls=dojo.i18n.getLocalization("lucid","games");this.resultMessage=this.surface.createText({x:((this.xSize*20)/2),y:((this.ySize*20)/2),text:nls.youWin,align:"middle"}).setFill("#000000");this.resultMessage.setFont({weight:"bold",size:20});},squareReveal:function(_a8){if(_a8.revealed==true){return;}dojo.disconnect(_a8.mousedown);dojo.disconnect(_a8.mouseover);dojo.disconnect(_a8.mouseout);dojo.disconnect(_a8.mouseright);_a8.revealed=true;var _a9=_a8.getBoundingBox();if(_a8.hasMine==true){_a8.setFill("#FF0000");_a8.mine=this.surface.createCircle({cx:(_a9.x+(_a9.width/2)),cy:(_a9.y+(_a9.height/2)),r:(_a9.width/2)});_a8.mine.setFill({type:"radial",cx:((_a9.x+(_a9.width/2))-5),cy:((_a9.y+(_a9.height/2))-5),colors:[{offset:0,color:"#FFFFFF"},{offset:0.1,color:"#222222"}]});this.gameOver();return;}_a8.setFill("#EFEFEF");this.squaresRevealed++;if(this.squaresRevealed>=this.squaresToWin){this.gameWin();return;}if(_a8.numMines>0){var _aa="#000000";if(_a8.numMines==1){_aa="#0000FF";}if(_a8.numMines==2){_aa="#00AA00";}if(_a8.numMines>=3){_aa="#FF0000";}_a8.numText=this.surface.createText({x:(_a9.x+(_a9.width/2)-5),y:(_a9.y+(_a9.height-5)),text:" "+(_a8.numMines)+" ",align:"left",color:"#000000"}).setFill(_aa);_a8.numText.setFont({weight:"bold"});_a8.numText.moveToFront();}else{this.clearAdjacentSquares(_a8.xPos,_a8.yPos);}},clearAdjacentSquares:function(_ab,_ac){if(_ac>0){if(!this.board[_ab][_ac-1].hasMine&&!this.board[_ab][_ac-1].revealed){this.squareReveal(this.board[_ab][_ac-1]);}}if(_ab<(this.xSize-1)){if(!this.board[_ab+1][_ac].hasMine&&!this.board[_ab+1][_ac].revealed){this.squareReveal(this.board[_ab+1][_ac]);}}if(_ac<(this.ySize-1)){if(!this.board[_ab][_ac+1].hasMine&&this.board[_ab][_ac+1].revealed){this.squareReveal(this.board[_ab][_ac+1]);}}if(_ab>0){if(!this.board[_ab-1][_ac].hasMine&&!this.board[_ab-1][_ac].revealed){this.squareReveal(this.board[_ab-1][_ac]);}}if(_ac>0&&_ab<(this.xSize-1)){if(!this.board[_ab+1][_ac-1].hasMine&&!this.board[_ab+1][_ac-1].revealed){this.squareReveal(this.board[_ab+1][_ac-1]);}}if(_ac<(this.ySize-1)&&_ab<(this.xSize-1)){if(!this.board[_ab+1][_ac+1].hasMine&&!this.board[_ab+1][_ac+1].revealed){this.squareReveal(this.board[_ab+1][_ac+1]);}}if(_ac<(this.ySize-1)&&_ab>0){if(!this.board[_ab-1][_ac+1].hasMine&&!this.board[_ab-1][_ac+1].revealed){this.squareReveal(this.board[_ab-1][_ac+1]);}}if(_ac>0&&_ab>0){if(!this.board[_ab-1][_ac-1].hasMine&&!this.board[_ab-1][_ac-1].revealed){this.squareReveal(this.board[_ab-1][_ac-1]);}}},squareFillMarked:function(_ad){if(_ad.marked==false){_ad.marked=true;var _ae=_ad.getBoundingBox();_ad.setFill({type:"linear",x1:_ae.x,y1:_ae.y,x2:_ae.x+_ae.width,y2:_ae.y+_ae.height,colors:[{offset:0,color:"#8F8F8F"},{offset:1,color:"#444444"}]});}else{_ad.marked=false;this.squareFillNormal(_ad);}},squareFillNormal:function(_af){if(_af.marked==true){return;}var _b0=_af.getBoundingBox();_af.setStroke({width:"0.25px",color:"#000000"});_af.setFill({type:"linear",x1:_b0.x,y1:_b0.y,x2:_b0.x+_b0.width,y2:_b0.y+_b0.height,colors:[{offset:0.1,color:"#CFCFCF"},{offset:0.9,color:"#888888"}]});},squareFillOver:function(_b1){if(_b1.marked==true){return;}var _b2=_b1.getBoundingBox();_b1.setFill({type:"linear",x1:_b2.x,y1:_b2.y,x2:_b2.x+_b2.width,y2:_b2.y+_b2.height,colors:[{offset:0,color:"#E5E5E5"},{offset:1,color:"#AAAAAA"}]});},kill:function(){if(!this.win.closed){this.win.close();}}});}dojo.i18n._preloadLocalizations("lucid.apps.nls.MineSweep",["ROOT","en","en-gb","en-us","es","es-es","fr","fr-fr","xx"]);
