/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/


if(!dojo._hasResource["lucid.apps.Messenger.sound"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["lucid.apps.Messenger.sound"] = true;
dojo.provide("lucid.apps.Messenger.sound");

dojo.extend(lucid.apps.Messenger, {
    sounds: {
        send: null,
        receive: null
    },
    initSounds: function(){
        var s = this.sounds = {};
        s.send = new lucid.Sound({
            src: dojo.moduleUrl("lucid.apps.Messenger.resources", "send.mp3").uri
        });
        s.receive = new lucid.Sound({
            src: dojo.moduleUrl("lucid.apps.Messenger.resources", "receive.mp3").uri
        });
        s.send.stop();
        s.receive.stop();
        
    },
    cleanupSounds: function(){
        for(var s in this.sounds){
            this.sounds[s].destroy();
        }
    },
    playSend: function(){
        var s = this.sounds.send;
        s.stop();
        s.play();
    },
    playReceive: function(){
        var s = this.sounds.receive;
        s.stop();
        s.play();
    }
});

}
