/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(!dojo._hasResource["dojox.embed.Flash"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojox.embed.Flash"] = true;
dojo.provide("dojox.embed.Flash");

(function(){
	/*******************************************************
		dojox.embed.Flash

		Base functionality to insert a flash movie into
		a document on the fly.

		Usage:
		var movie=new dojox.embed.Flash({ args }, containerNode);
	 ******************************************************/
	var fMarkup, fVersion;
	var minimumVersion = 9; // anything below this will throw an error (may overwrite)
	var keyBase = "dojox-embed-flash-", keyCount=0;
	var _baseKwArgs = {
		expressInstall: false,
		width: 320,
		height: 240,
		swLiveConnect: "true",
		allowScriptAccess: "sameDomain",
		allowNetworking:"all",
		style: null,
		redirect: null
	};

	function prep(kwArgs){
		// console.warn("KWARGS:", kwArgs)
		kwArgs = dojo.delegate(_baseKwArgs, kwArgs);

		if(!("path" in kwArgs)){
			console.error("dojox.embed.Flash(ctor):: no path reference to a Flash movie was provided.");
			return null;
		}

		if(!("id" in kwArgs)){
			kwArgs.id = (keyBase + keyCount++);
		}
		return kwArgs;
	}

	if(dojo.isIE){
		fMarkup = function(kwArgs){
			kwArgs = prep(kwArgs);
			if(!kwArgs){ return null; }
			
			var p;
			var path = kwArgs.path;
			if(kwArgs.vars){
				var a = [];
				for(p in kwArgs.vars){
					a.push(p + '=' + kwArgs.vars[p]);
				}
				path += ((path.indexOf("?") == -1) ? "?" : "&") + a.join("&");
			}
			// FIXME: really? +'s?
			var s = '<object id="' + kwArgs.id + '" '
				+ 'classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" '
				+ 'width="' + kwArgs.width + '" '
				+ 'height="' + kwArgs.height + '"'
				+ ((kwArgs.style)?' style="' + kwArgs.style + '"':'')
				+ '>'
				+ '<param name="movie" value="' + path + '" />';
			if(kwArgs.params){
				for(p in kwArgs.params){
					s += '<param name="' + p + '" value="' + kwArgs.params[p] + '" />';
				}
			}
			s += '</object>';
			return { id: kwArgs.id, markup: s };
		};

		fVersion = (function(){
			var testVersion = 10, testObj = null;
			while(!testObj && testVersion > 7){
				try {
					testObj = new ActiveXObject("ShockwaveFlash.ShockwaveFlash." + testVersion--);
				}catch(e){ }
			}
			if(testObj){
				var v = testObj.GetVariable("$version").split(" ")[1].split(",");
				return {
					major: (v[0]!=null) ? parseInt(v[0]) : 0, 
					minor: (v[1]!=null) ? parseInt(v[1]) : 0, 
					rev: (v[2]!=null) ? parseInt(v[2]) : 0 
				};
			}
			return { major: 0, minor: 0, rev: 0 };
		})();

		//	attach some cleanup for IE, thanks to deconcept :)
		dojo.addOnUnload(function(){
			var dummy = function(){};
			var objs = dojo.query("object").
				reverse().
				style("display", "none").
				forEach(function(i){
					for(var p in i){
						if((p != "FlashVars") && dojo.isFunction(i[p])){
							try{
								i[p] = dummy;
							}catch(e){}
						}
					}
				});
		});

		//	TODO: ...and double check this fix; is IE really firing onbeforeunload with any kind of href="#" link?
		/*
		var beforeUnloadHandle = dojo.connect(dojo.global, "onbeforeunload", function(){
			try{
				if(__flash_unloadHandler){ __flash_unloadHandler=function(){ }; }
				if(__flash_savedUnloadHandler){ __flash_savedUnloadHandler=function(){ }; }
			} catch(e){ }
			dojo.disconnect(beforeUnloadHandle);
		});
		*/
	} else {
		//	*** Sane browsers branch ******************************************************************
		fMarkup = function(kwArgs){
			kwArgs = prep(kwArgs);
			if(!kwArgs){ return null; }
			
			var p;
			var path = kwArgs.path;
			if(kwArgs.vars){
				var a = [];
				for(p in kwArgs.vars){
					a.push(p + '=' + kwArgs.vars[p]);
				}
				path += ((path.indexOf("?") == -1) ? "?" : "&") + a.join("&");
			}
			var s = '<embed type="application/x-shockwave-flash" '
				+ 'src="' + path + '" '
				+ 'id="' + kwArgs.id + '" '
				//+ 'name="' + kwArgs.id + '" '
				+ 'width="' + kwArgs.width + '" '
				+ 'height="' + kwArgs.height + '"'
				+ ((kwArgs.style)?' style="' + kwArgs.style + '" ':'')
				+ 'swLiveConnect="'+kwArgs.swLiveConnect+'" '
				+ 'allowScriptAccess="' +kwArgs.allowScriptAccess+  '" '
				+ 'allowNetworking="' +kwArgs.allowNetworking+  '" '
				
				+ 'pluginspage="' + window.location.protocol + '//www.adobe.com/go/getflashplayer" ';
			if(kwArgs.params){
				for(p in kwArgs.params){
					s += ' ' + p + '="' + kwArgs.params[p] + '"';
				}
			}
			s += ' />';
			return { id: kwArgs.id, markup: s };
		};

		fVersion=(function(){
			var plugin = navigator.plugins["Shockwave Flash"];
			if(plugin && plugin.description){
				var v = plugin.description.replace(/([a-zA-Z]|\s)+/, "").replace(/(\s+r|\s+b[0-9]+)/, ".").split(".");
				return { 
					major: (v[0]!=null) ? parseInt(v[0]) : 0, 
					minor: (v[1]!=null) ? parseInt(v[1]) : 0, 
					rev: (v[2]!=null) ? parseInt(v[2]) : 0 
				};
			}
			return { major: 0, minor: 0, rev: 0 };
		})();
	}


	/*=====
	dojox.embed.__flashArgs = function(path, id, width, height, style, params, vars, expressInstall, redirect){
		//	path: String
		//		The URL of the movie to embed.
		//	id: String?
		//		A unique key that will be used as the id of the created markup.  If you don't
		//		provide this, a unique key will be generated.
		//	width: Number?
		//		The width of the embedded movie; the default value is 320px.
		//	height: Number?
		//		The height of the embedded movie; the default value is 240px
		//	minimumVersion: Number ?
		//		The minimum targeted version of the Flash Player (defaults to 9) 
		//	style: String?
		//		Any CSS style information (i.e. style="background-color:transparent") you want
		//		to define on the markup.
		//	params: Object?
		//		A set of key/value pairs that you want to define in the resultant markup.
		//	vars: Object?
		//		A set of key/value pairs that the Flash movie will interpret as FlashVars.
		//	expressInstall: Boolean?
		//		Whether or not to include any kind of expressInstall info. Default is false.
		//	redirect: String?
		//		A url to redirect the browser to if the current Flash version is not supported.
		this.id=id;
		this.path=path;
		this.width=width;
		this.minimumVersion=minimumVersion;
		this.height=height;
		this.style=style;
		this.params=params;
		this.vars=vars;
		this.expressInstall=expressInstall;
		this.redirect=redirect;
	}
	=====*/

	//	the main entry point
	dojox.embed.Flash = function(/*dojox.embed.__flashArgs*/ kwArgs, /*DOMNode*/ node){
		//	summary:
		//		Creates a wrapper object around a Flash movie.  Wrapper object will
		//		insert the movie reference in node; when the browser first starts
		//		grabbing the movie, onReady will be fired; when the movie has finished
		//		loading, it will fire onLoad.
		//
		//		If your movie uses ExternalInterface, you should use the onLoad event
		//		to do any kind of proxy setup (see dojox.embed.Flash.proxy); this seems
		//		to be the only consistent time calling EI methods are stable (since the
		//		Flash movie will shoot several methods into the window object before
		//		EI callbacks can be used properly).
		//
		//	arguments:
		//		kwArgs: dojox.embed.__flashArgs
		//			See dojox.embed.__flashArgs
		//
		//		node:	DomNode
		//			The node where the embed object will be placed
		//
		// 	properties:
		//		id: String
		//			The ID of the internal embed/object tag.  Can be used to get a reference to
		//			the movie itself.
		//		movie: HTMLObject
		//			A reference to the Flash movie itself.
		//
		//	example:
		//		Embed a flash movie in a document using the new operator, and get a reference to it.
		//	|	var movie = new dojox.embed.Flash({
		//	|		path: "path/to/my/movie.swf",
		//	|		width: 400,
		//	|		height: 300
		//	|	}, myWrapperNode, "testLoaded");
		//
		//	example:
		//		Embed a flash movie in a document without using the new operator.
		//	|	var movie = dojox.embed.Flash({
		//	|		path: "path/to/my/movie.swf",
		//	|		width: 400,
		//	|		height: 300,
		//	|		style: "position:absolute;top:0;left:0"
		//	|	}, myWrapperNode, "testLoaded");
		//
		// File can only be run from a server, due to SWF dependency.
		if(location.href.toLowerCase().indexOf("file://")>-1){
			throw new Error("dojox.embed.Flash can't be run directly from a file. To instatiate the required SWF correctly it must be run from a server, like localHost.");
		}
		this.available = dojox.embed.Flash.available;
		this.minimumVersion = kwArgs.minimumVersion || minimumVersion;
		//console.log("AVAILABLE:", this);
		this.id = null;
		this.movie = null;
		this.domNode = null;
		if(node){
			node = dojo.byId(node);
		}
		// setTimeout Fixes #8743 - creating double SWFs
		// also allows time for code to attach to onError
		setTimeout(dojo.hitch(this, function(){
			if(this.available && this.available >= this.minimumVersion){
				if(kwArgs && node){
					this.init(kwArgs, node);
				}// FIXME: else what?
				
			}else{
				if(!this.available){
					this.onError("Flash is not installed.");
				}else{
					this.onError("Flash version detected: "+this.available+" is out of date. Minimum required: "+this.minimumVersion);
				}
			}
		}), 100);
	};

	dojo.extend(dojox.embed.Flash, {
		onReady: function(/*HTMLObject*/ movie){
			//	summary:
			//		Stub function for you to attach to when the movie reference is first
			//		pushed into the document.
		},
		onLoad: function(/*HTMLObject*/ movie){
			//	summary:
			//		Stub function for you to attach to when the movie has finished downloading
			//		and is ready to be manipulated.
		},
		onError: function(msg){
			
		},
		_onload: function(){
			// summary:
			//	Internal. Cleans up before calling onLoad. 
			clearInterval(this._poller);
			delete this._poller;
			delete this._pollCount;
			delete this._pollMax;
			this.onLoad(this.movie);
		},
		init: function(/*dojox.embed.__flashArgs*/ kwArgs, /*DOMNode?*/ node){
			//	summary
			//		Initialize (i.e. place and load) the movie based on kwArgs.
			this.destroy();		//	ensure we are clean first.
			node = dojo.byId(node || this.domNode);
			if(!node){ throw new Error("dojox.embed.Flash: no domNode reference has been passed."); }
			
			// vars to help determine load status
			var p = 0, testLoaded=false;
			this._poller = null; this._pollCount = 0; this._pollMax = 5; this.pollTime = 100;
			
			if(dojox.embed.Flash.initialized){
				
				this.id = dojox.embed.Flash.place(kwArgs, node);
				this.domNode = node;

				setTimeout(dojo.hitch(this, function(){
					this.movie = this.byId(this.id, kwArgs.doc);
					this.onReady(this.movie);
					
					this._poller = setInterval(dojo.hitch(this, function(){
						
						// catch errors if not quite ready.
						try{
							p = this.movie.PercentLoaded();
						}catch(e){
							/* squelch */
							console.warn("this.movie.PercentLoaded() failed");
						};
						
						if(p == 100){
							// if percent = 100, movie is fully loaded and we're communicating
							this._onload();
						
						}else if(p==0 && this._pollCount++ > this._pollMax){
							// after several attempts, we're not past zero.
							// FIXME: What if we get stuck on 33% or something?
							clearInterval(this._poller);
							throw new Error("Building SWF failed.");
						}
					}), this.pollTime);
				}), 1);
			}
		},
		_destroy: function(){
			//	summary
			//		Kill the movie and reset all the properties of this object.
			try{
				this.domNode.removeChild(this.movie);
			}catch(e){}
			this.id = this.movie = this.domNode = null;
		},
		destroy: function(){
			//	summary
			//		Public interface for destroying all the properties in this object.
			//		Will also clean all proxied methods.
			if(!this.movie){ return; }
			
			//	remove any proxy functions
			var test = dojo.delegate({ 
				id: true,
				movie: true,
				domNode: true,
				onReady: true,
				onLoad: true 
			});
			for(var p in this){
				if(!test[p]){
					delete this[p];
				}
			}

			//	pull the movie
			if(this._poller){
				//	wait until onLoad to destroy
				dojo.connect(this, "onLoad", this, "_destroy");
			} else {
				this._destroy();
			}
		},
		byId: function (movieName, doc){
			// 	summary:
			//		Gets Flash movie by id.
			//	description:
			//		Probably includes methods for outdated
			//		browsers, but this should catch all cases.
			// arguments:
			//		movieName: String
			//			The name of the SWF
			//		doc: Object
			//			The document, if not current window
			//			(not fully supported)
			//	example:
			//	| var movie = dojox.embed.Flash.byId("myId");
			//
			doc = doc || document;
			if(doc.embeds[movieName]){
				return doc.embeds[movieName];
			}
			if(doc[movieName]){
				return doc[movieName];
			}
			if(window[movieName]){
				return window[movieName];
			}
			if(document[movieName]){
				return document[movieName];
			}
			return null;
		}
	});
	
	//	expose information through the constructor function itself.
	dojo.mixin(dojox.embed.Flash, {
		//	summary:
		//		A singleton object used internally to get information
		//		about the Flash player available in a browser, and
		//		as the factory for generating and placing markup in a
		//		document.
		//
		//	minSupported: Number
		//		The minimum supported version of the Flash Player, defaults to 8.
		//	available: Number
		//		Used as both a detection (i.e. if(dojox.embed.Flash.available){ })
		//		and as a variable holding the major version of the player installed.
		//	supported: Boolean
		//		Whether or not the Flash Player installed is supported by dojox.embed.
		//	version: Object
		//		The version of the installed Flash Player; takes the form of
		//		{ major, minor, rev }.  To get the major version, you'd do this:
		//		var v=dojox.embed.Flash.version.major;
		//	initialized: Boolean
		//		Whether or not the Flash engine is available for use.
		//	onInitialize: Function
		//		A stub you can connect to if you are looking to fire code when the 
		//		engine becomes available.  A note: DO NOT use this event to
		//		place a movie in a document; it will usually fire before DOMContentLoaded
		//		is fired, and you will get an error.  Use dojo.addOnLoad instead.
		minSupported : 8,
		available: fVersion.major,
		supported: (fVersion.major >= fVersion.required),
		minimumRequired: fVersion.required,
		version: fVersion,
		initialized: false,
		onInitialize: function(){
			dojox.embed.Flash.initialized = true;
		},
		__ie_markup__: function(kwArgs){
			return fMarkup(kwArgs);
		},
		proxy: function(/*dojox.embed.Flash*/ obj, /*Array|String*/ methods){
			//	summary:
			//		Create the set of passed methods on the dojox.embed.Flash object
			//		so that you can call that object directly, as opposed to having to
			//		delve into the internal movie to do this.  Intended to make working
			//		with Flash movies that use ExternalInterface much easier to use.
			//
			//	example:
			//		Create "setMessage" and "getMessage" methods on foo.
			//	|	var foo = new dojox.embed.Flash(args, someNode);
			//	|	dojo.connect(foo, "onLoad", dojo.hitch(foo, function(){
			//	|		dojox.embed.Flash.proxy(this, [ "setMessage", "getMessage" ]);
			//	|		this.setMessage("dojox.embed.Flash.proxy is pretty cool...");
			//	|		console.log(this.getMessage());
			//	|	}));
			dojo.forEach((dojo.isArray(methods) ? methods : [ methods ]), function(item){
				this[item] = dojo.hitch(this, function(){
					return (function(){
						return eval(this.movie.CallFunction(
							'<invoke name="' + item + '" returntype="javascript">'
							+ '<arguments>'
							+ dojo.map(arguments, function(item){
								// FIXME: 
								//		investigate if __flash__toXML will
								//		accept direct application via map()
								//		(e.g., does it ignore args past the
								//		first? or does it blow up?)
								return __flash__toXML(item);
							}).join("")
							+ '</arguments>'
							+ '</invoke>'
						));
					}).apply(this, arguments||[]);
				});
			}, obj);
		}
	});

	if(dojo.isIE){
		//	Ugh!
		if(dojo._initFired){
			var e = document.createElement("script");
			e.type = "text/javascript";
			e.src = dojo.moduleUrl("dojox", "embed/IE/flash.js");
			document.getElementsByTagName("head")[0].appendChild(e);
		}else{
			//	we can use document.write.  What a kludge.
			document.write('<scr'+'ipt type="text/javascript" src="' + dojo.moduleUrl("dojox", "embed/IE/flash.js") + '">'
				+ '</scr'+'ipt>');
		}
	}else{
		dojox.embed.Flash.place = function(kwArgs, node){
			var o = fMarkup(kwArgs);
			node = dojo.byId(node);
			if(!node){ 
				node = dojo.doc.createElement("div");
				node.id = o.id+"-container";
				dojo.body().appendChild(node);
			}
			if(o){
				node.innerHTML = o.markup;
				return o.id;
			}
			return null;
		}
		dojox.embed.Flash.onInitialize();
	}
})();

}

if(!dojo._hasResource["dojox.html.styles"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojox.html.styles"] = true;
dojo.provide("dojox.html.styles");
	
	// summary:
	//		Methods for creating and minipulating dynamic CSS Styles and Style Sheets
	//
	// example:
	//		| dojox.html.createStyle("#myDiv input", "font-size:24px");
	//			Creates Style #myDiv input, which can now be applied to myDiv, and 
	//			the inner input will be targeted
	//		| dojox.html.createStyle(".myStyle", "color:#FF0000");
	//			Now the class myStyle can be assigned to a node's className
	
(function(){
	
	var dynamicStyleMap = {};
	var pageStyleSheets = {};
	var titledSheets = [];
	var styleIndicies = [];
	
	dojox.html.insertCssRule = function(/*String*/selector, /*String*/declaration, /*String*/styleSheetName){
		// summary:
		//	Creates a style and attaches it to a dynamically created stylesheet
		//	arguments:
		//		selector: 	
		//					A fully qualified class name, as it would appear in
		//					a CSS dojo.doc. Start classes with periods, target
		//					nodes with '#'. Large selectors can also be created
		//					like:
		//					| "#myDiv.myClass span input"
		//		declaration:
		//					A single string that would make up a style block, not
		//					including the curly braces. Include semi-colons between
		//					statements. Do not use JavaScript style declarations
		//					in camel case, use as you would in a CSS dojo.doc:
		//					| "color:#ffoooo;font-size:12px;margin-left:5px;"
		//		styleSheetName: ( optional )
		//					Name of the dynamic style sheet this rule should be 
		//					inserted into. If is not found by that name, it is
		//					created. If no name is passed, the name "default" is 
		//					used.
		//
		var ss = dojox.html.getDynamicStyleSheet(styleSheetName);
		var styleText = selector + " {" + declaration + "}";
		console.log("insertRule:", styleText)
		if(dojo.isIE){
			// Note: check for if(ss.cssText) does not work
			ss.cssText+=styleText;
			console.log("ss.cssText:", ss.cssText)
		}else if(ss.sheet){
			ss.sheet.insertRule(styleText, ss._indicies.length);
		}else{
			ss.appendChild(dojo.doc.createTextNode(styleText));
		}
		ss._indicies.push(selector+" "+declaration);
		return selector; // String 
	
	}
	
	dojox.html.removeCssRule = function(/*String*/selector, /*String*/declaration, /*String*/styleSheetName){
		// summary:
		//		Removes a cssRule base on the selector and declaration passed
		//		The declaration is needed for cases of dupe selectors
		// description: Only removes DYNAMICALLY created cssRules. If you 
		//		created it with dojox.html.insertCssRule, it can be removed.
		//
		var ss;
		var index=-1;
		for(var nm in dynamicStyleMap){
			if(styleSheetName && styleSheetName!=nm) {continue;}
			ss = dynamicStyleMap[nm];
			for(var i=0;i<ss._indicies.length;i++){
				if(selector+" "+declaration == ss._indicies[i]){
					index = i;
					break;
				}
			}
			if(index>-1) { break; }
		}
		if(!ss){
			console.log("No dynamic style sheet has been created from which to remove a rule.");
			return false;
		}
		if(index==-1){
			console.log("The css rule was not found and could not be removed.");
			return false;
		}
		
		ss._indicies.splice(index, 1);
		
		
		
		if(dojo.isIE){ 
			// Note: check for if(ss.removeRule) does not work
			ss.removeRule(index);
		}else if(ss.sheet){
			ss.sheet.deleteRule(index);
		}else if(document.styleSheets[0]){
			console.log("what browser hath useth thith?")
			//
		}
		return true; //Boolean
		
	}
	
	/* TODO
	dojox.html.modifyCssRule = function(selector, declaration, styleSheetName){
		Not implemented - it seems to have some merit for changing some complex 
		selectors. It's not much use for changing simple ones like "span".
		For now, simply write a new rule which will cascade over the first.
		// summary
		//	Modfies an existing cssRule
	}
	*/
	
	dojox.html.getStyleSheet = function(/*String*/styleSheetName){
		// summary:
		//		Returns a style sheet based on the argument.
		//		Searches dynamic style sheets first. If no matches,
		//		searches document style sheets.
		//
		// argument: (optional)
		//		A title or an href to a style sheet. Title can be 
		//		an attribute in a tag, or a dynamic style sheet 
		//		reference. Href can be the name of the file.
		//		If no argument, the assumed created dynamic style 
		//		sheet is used.
		
		// try dynamic sheets first 
		if(dynamicStyleMap[styleSheetName || "default"]){
			return dynamicStyleMap[styleSheetName || "default"];
		}
		if(!styleSheetName){
			// no arg is nly good for the default style sheet 
			// and it has not been created yet.
			return false;
		}
		
		var allSheets = dojox.html.getStyleSheets();
		
		// now try document style sheets by name
		if(allSheets[styleSheetName]){
			return dojox.html.getStyleSheets()[styleSheetName];
		}
		
		// check for partial matches in hrefs (so that a fully 
		//qualified name does not have to be passed)
		for ( var nm in allSheets){
			if(	allSheets[nm].href && allSheets[nm].href.indexOf(styleSheetName)>-1){
				return allSheets[nm];
			}
		}
		return false; //StyleSheet or false
	}
	
	dojox.html.getDynamicStyleSheet = function(/*String*/styleSheetName){
		// summary:
		//		Creates and returns a dynamically created style sheet
		// 		used for dynamic styles
		//
		//	argument:
		//			styleSheetName /* optional String */
		//			The name given the style sheet so that multiple 
		//			style sheets can be created and referenced. If 
		//			no argument is given, the name "default" is used.
		//
		if(!styleSheetName){ styleSheetName="default"; }
		
		if(!dynamicStyleMap[styleSheetName]){
			if(dojo.doc.createStyleSheet){ //IE
			
				dynamicStyleMap[styleSheetName] = dojo.doc.createStyleSheet();
				dynamicStyleMap[styleSheetName].title = styleSheetName;

			}else{
				dynamicStyleMap[styleSheetName] = dojo.doc.createElement("style");
				dynamicStyleMap[styleSheetName].setAttribute("type", "text/css");
				dojo.doc.getElementsByTagName("head")[0].appendChild(dynamicStyleMap[styleSheetName]);
				console.log(styleSheetName, " ss created: ", dynamicStyleMap[styleSheetName].sheet);
			}
			dynamicStyleMap[styleSheetName]._indicies = [];
		}
		
		
		return dynamicStyleMap[styleSheetName]; //StyleSheet
	}

	dojox.html.enableStyleSheet = function(/*String*/styleSheetName){
		// summary:
		//		Enables the style sheet with the name passed in the
		//		argument. Deafults to the default style sheet.
		//
		var ss = dojox.html.getStyleSheet(styleSheetName);
		if(ss){ 
			if(ss.sheet){
				ss.sheet.disabled = false; 
			}else{
				ss.disabled = false; 
			}
		}
	}

	dojox.html.disableStyleSheet = function(styleSheetName){
		// summary:
		//		Disables the dynamic style sheet with the name passed in the
		//		argument. If no arg is passed, defaults to the default style sheet.
		//
		var ss = dojox.html.getStyleSheet(styleSheetName);
		if(ss){ 
			if(ss.sheet){
				ss.sheet.disabled = true; 
			}else{
				ss.disabled = true; 
			}
		}
	}
	
	dojox.html.activeStyleSheet = function(/*?String*/title){
		// summary:
		//		Getter/Setter
		// description:
		//		If passed a title, enables a that style sheet. All other
		//		toggle-able style sheets are disabled.
		//		If no argument is passed, returns currently enabled
		//		style sheet.
		//
		var sheets = dojox.html.getToggledStyleSheets();
		if(arguments.length == 1){
			//console.log("sheets:", sheets);
			dojo.forEach(sheets, function(s){
				s.disabled = (s.title == title) ? false : true;
				//console.log("SWITCHED:", s.title, s.disabled, s.id);
			});
		}else{
			for(var i=0; i<sheets.length;i++){
				if(sheets[i].disabled == false){
					return sheets[i];
				}
			}
		}
		return true; //StyleSheet or Boolean - FIXME - doesn't make a lot of sense
	}
	
	dojox.html.getPreferredStyleSheet = function(){
		// summary
		//	Returns the style sheet that was initially enabled
		//	on document launch.
		
		//TODO
	}
	
	
	
	
	dojox.html.getToggledStyleSheets = function(){
		// summary:
		//		Searches HTML for style sheets that are "toggle-able" - 
		//		can be enabled and disabled. These would include sheets
		//		with the title attribute, as well as the REL attribute.
		//	returns:
		//		An array of all toggle-able style sheets
		//	TODO: 	Sets of style sheets could be grouped according to
		//			an ID and used in sets, much like different
		//			groups of radio buttons. It would not however be
		//			according to W3C spec
		//
		if(!titledSheets.length){
			var sObjects = dojox.html.getStyleSheets();
			for(var nm in sObjects){
				
				if(sObjects[nm].title){
					//console.log("TITLE:", sObjects[nm].title, sObjects[nm])
					titledSheets.push(sObjects[nm]);
				}
			}
		}
		return titledSheets; //Array
	}
	
	
	dojox.html.getStyleSheets = function(){
		// summary:
		//		Collects all the style sheets referenced in the HTML page,
		//		including any incuded via @import. 
		//
		//	returns: 
		//		An hash map of all the style sheets.
		//
		//	TODO: 	Does not recursively search for @imports, so it will
		//			only go one level deep.
		//
		if(pageStyleSheets.collected) {return pageStyleSheets;}
		
		var sheets = dojo.doc.styleSheets;
		//console.log("styleSheets:", sheets);
		dojo.forEach(sheets, function(n){
			var s = (n.sheet) ? n.sheet : n;
			var name = s.title || s.href;
			if(dojo.isIE){
				// IE attaches a style sheet for VML - do not include this
				if(s.cssText.indexOf("#default#VML")==-1){
					
					
					if(s.href){
						// linked		
						pageStyleSheets[name] = s;
					
					}else if(s.imports.length){
						// Imported via @import
						dojo.forEach(s.imports, function(si){
							pageStyleSheets[si.title || si.href] = si;
						});
						
					}else{
						//embedded within page
						pageStyleSheets[name] = s;
					}
				}
				
			}else{
				//linked or embedded
				pageStyleSheets[name] = s;
				pageStyleSheets[name].id = s.ownerNode.id;
				dojo.forEach(s.cssRules, function(r){
					if(r.href){
						// imported
						pageStyleSheets[r.href] = r.styleSheet;
						pageStyleSheets[r.href].id = s.ownerNode.id;
					}
				});
			
			}
			
		});
		
		//console.log("pageStyleSheets:", pageStyleSheets);
		
		
		pageStyleSheets.collected = true;
		return pageStyleSheets; //Object
	}
	

})();

}

if(!dojo._hasResource["dojox.embed.flashVars"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojox.embed.flashVars"] = true;
dojo.provide("dojox.embed.flashVars");

dojo.mixin(dojox.embed.flashVars, {
	//	summary
	//		Handles flashvar serialization
	//		Converting complex objects into a simple, clear string that can be appended
	//		to the swf as a query: myMovie.swf?flashvars=foo.
	//		Note this needs to work with the SWF, which must know what variables to expect.
	//		Therefore this is something of an "internal" class - unless you know how to
	//		modify or create SWFs.
	//
	//	description:
	//		JSON could be done, but Deft does not yet have a JSON parser, and quotes are
	//		very problematic since Flash cannot use eval(); JSON parsing was successful
	//		when it was fully escaped, but that made it very large anyway. flashvar
	//		serialization at most is 200% larger than JSON.
	//
	//	See:
	//		Deft/common/flashVars.as
	//
	serialize: function(/* String */n, /*Object*/o){
		// summary:
		//		Key method. Serializes an object.
		//	n:String
		//		The name for the object, such as: "button"
		//	o:Object
		//		The object to serialize
		//
		var esc = function(val){
			//	have to encode certain characters that indicate an object
			if(typeof val=="string"){
				val = val.replace(/;/g,"_sc_");
				val = val.replace(/\./g,"_pr_");
				val = val.replace(/\:/g,"_cl_");
				//val = escape(val);
			}
			return val;
		};
		var df = dojox.embed.flashVars.serialize;
		var txt = "";
		if(dojo.isArray(o)){
			for(var i=0;i<o.length;i++){
				txt += df(n+"."+i, esc(o[i]))+";";
			}
			return txt.replace(/;{2,}/g,";");
		}else if(dojo.isObject(o)){
			for(var nm in o){
				txt += df(n+"."+nm, esc(o[nm]))+";";
			}
			return txt.replace(/;{2,}/g,";");
		}
		// Dev note: important that there is no double semi-colons
		return n+":"+o; // String
	}
});

}

if(!dojo._hasResource["dojox.form.FileUploader"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojox.form.FileUploader"] = true;
dojo.provide("dojox.form.FileUploader");






dojo.experimental("dojox.form.FileUploader");
	//	Usage Notes:
	//		To center text vertically, use vertical-align:middle;
	//			which emulates a boxModel button. Using line-height to center text
	//			can cause height problems in IE6
	
	
(function(){
	
	var swfPath = dojo.config.uploaderPath || dojo.moduleUrl("dojox.form", "resources/uploader.swf");
	
	var mixin = function(o1,o2){
		// custom mixin
		var o = {}, nm;
		for(nm in o1){
			if(dojo.isObject(o1[nm])){
				o[nm] = mixin({}, o1[nm]);
			}else{
				o[nm] = o1[nm];	
			}
			
		}
		for(nm in o2){
			if(dojo.isObject(o2[nm])){
				if(dojo.isObject(o[nm])){
					mixin(o[nm], o2[nm]);
				}else{
					mixin({}, o2[nm]);
				}
			}else{
				o[nm] = o2[nm];
			}
		}
		return o;
	};
	
	var urlencode = function(url){
		// Using symbols in place of URL chars that will break in Flash serialization.
		if(!url || url == "none"){
			return false;
		}
		return url.replace(/:/g,"||").replace(/\./g,"^^").replace("url(", "").replace(")","").replace(/'/g,"").replace(/"/g,"");
	};
	
	var isButton = function(node){
		// testing if button for styling purposes
		var tn = node.tagName.toLowerCase();
		return tn == "button" || tn == "input";
	};
	
	var getTextStyle = function(node){
		// getting font info
		var o = {};
		o.ff = dojo.style(node, "fontFamily");
		o.ff = o.ff.replace(/\"|\'/g, "");
		o.fw = dojo.style(node, "fontWeight");
		o.fi = dojo.style(node, "fontStyle");
		o.fs = parseInt(dojo.style(node, "fontSize"), 10);
		
		o.fc = new dojo.Color(dojo.style(node, "color")).toHex();
		o.fc = parseInt(o.fc.substring(1,Infinity),16);
		
		o.lh = dojo.style(node, "lineHeight");
		o.ta = dojo.style(node, "textAlign");
		o.ta = o.ta == "start" || !o.ta ? "left" : o.ta;
		o.va = isButton(node) ? "middle" : o.lh == o.h ? "middle" : dojo.style(node, "verticalAlign");
		return o;
	};
	
	var getText = function(node){
		// Get the text of the button. It's possible to use HTML in the Flash Button,
		//	but the results are not spectacular.
		var cn = dojo.trim(node.innerHTML);
		if(cn.indexOf("<")>-1){
			cn = escape(cn);
		}
		return cn;
	};
	
	var getStyle = function(node){
		// getting the style of a node. Using very abbreviated characters which the
		//	Flash movie understands.
		var o = {};
		var dim = dojo.contentBox(node);
		
		var pad = dojo._getPadExtents(node);
		o.p = [pad.t, pad.w-pad.l, pad.h-pad.t, pad.l];
		o.w = dim.w + pad.w;
		o.h = dim.h + pad.h;
		o.d = dojo.style(node, "display");
		var clr = new dojo.Color(dojo.style(node, "backgroundColor"));
		// if no color, Safari sets #000000 and alpha=0
		// 	since we don't support alpha, it makes black
		//	- make it white
		o.bc = clr.a == 0 ? "#ffffff" : clr.toHex();
		o.bc = parseInt(o.bc.substring(1,Infinity),16);
		var url = urlencode(dojo.style(node, "backgroundImage"));
		if(url){
			o.bi = {
				url:url,
				rp:dojo.style(node, "backgroundRepeat"),
				pos: escape(dojo.style(node, "backgroundPosition"))
			};
			if(!o.bi.pos){
				// IE does Xpx and Ypx, not "X% Y%"
				var rx = dojo.style(node, "backgroundPositionX");
				var ry = dojo.style(node, "backgroundPositionY");
				rx = (rx == "left") ? "0%" : (rx == "right") ? "100%" : rx;
				ry = (ry == "top") ? "0%" : (ry == "bottom") ? "100%" : ry;
				o.bi.pos = escape(rx+" "+ry);
			}
		}
		return mixin(o, getTextStyle(node));
	};
	var getTempNodeStyle = function(node, _class, isDijitButton){
		// This sets up a temp node to get the style of the hover, active, and disabled states
		var temp, style;
		if(isDijitButton){
			// backwards compat until dojo 1.5
			temp = dojo.place("<"+node.tagName+"><span>"+node.innerHTML+" "+_class+"</span></"+node.tagName+">", node.parentNode);
			var first = temp.firstChild;
			dojo.addClass(first, node.className);
			dojo.addClass(temp, _class);
			style = getStyle(first);
		}else{
			temp = dojo.place("<"+node.tagName+">"+node.innerHTML+"</"+node.tagName+">", node.parentNode);
			dojo.addClass(temp, node.className);
			dojo.addClass(temp, _class);
			temp.id = node.id;
			style = getStyle(temp);
		}
		dojo.destroy(temp);
		return style;
	};
	
	var isUpperCase = function(ltr){
		// returns true if character is upper case
		return ltr.charCodeAt(0) < 91;
	};
	
	dojo.declare("dojox.form.FileUploader", [dijit._Widget, dijit._Templated], {
		// version:
		//		1.4
		// summary: 
		// 		Handles File Uploading to a server (PHP script included for testing)
		//
		//		***NEW: FileUploader is now a WIDGET. You do not have to pass a button
		//		in. Passing a button is still supported until version 1.5 to maintain
		//		backwards compatibility, but it is not reccomended. Just create your
		//		uploader like any other widget.
		//
		// description:
		//		If the correct version of Flash Player is available (> 9.0) , a SWF
		//		is used. If Flash Player is not installed or is outdated, a typical
		//		html fileInput is used. This process can be overridden with
		//		force:"flash" or force:"html".
		//
		//		FileUploader works with Flash 10.
		//
		//		***NEW: The button styles are now recreated in Flash, so there is no longer
		//		using an invisible Flash movie with wmode=transparent. This way the Flash button
		//		is actually placed inline with the DOM, not floating above it and contstantly
		//		resetting its position. The "Windows Firefox clickable bug" should be fixed (and
		//		hopefully some Linux problems).
		//
		//		***NEW: The HTML button is created in a new way and it is now inline as is the
		//		FLash button. Styling is much easier and more versatile.
		//
		//	Dependencies:
		//		FileUploader no longer uses FileInput.css. It now uses FileUploader.css
		//		See requires for JavaScript dependencies.
		//
		//	NEW FEATURES - 
		//		There are a ton of features and fixes in this version.
		//			Disabled: Can be toggled with widget.attr("disable", true|false)
		//			Submit: A convenience method has been added for if the uploader is in a form.
		//					Instead of submitting the form, call uploader.submit(theForm), and the
		//					Uploader will handle all of the form values and post the data.
		//			Selected List: If passing the ID of a container, the Uploaders will populate it
		//					with the selected files.
		//			Deleting Files: You can now delete pending files.
		//			Progress Built in: showProgress:true will change the button to a progress
		//					bar on upload.
		//			Progress Attach: Passing progressWidgetId will tell the Uploader of a progress
		//					widget. If the Progress widget is initially hidden, it will change to
		//					visible and then restored after upload.
		//			A11Y: The Flash button can be accessed with the TAB key. (The HTML cannot due
		//					to browser limtations)
		//			Deferred Uploading: (Flash only) throttles the upload to one file at a time
		//
		// 	UploadFile.php fixes:
		//		HTML didn't send postdata properly
		//		removed unecessary code, clarified things
		//		html files return sizes on upload 	
		//
		//	CDN USERS - 
		//		FileUpload now works with the CDN but with limitations. The SWF must 
		//		be from the same domain as the HTML page. 'swfPath' has been exposed
		//		so that you may link to that file (could of course be the same SWF in 
		//		dojox resource folder). The SWF will *NOT* work from the
		//		CDN server. This would require a special XML file that would allow 
		//		access to your server, and the logistics to that is impossible.
		//
		//	OPERA USERS -
		//		It works better than the 1.3 version. fileInputs apperantly can't have opacity
		//		set to zero. The Flash uploader works but files are auto-uploaded. Must be a
		//		flashVar problem.
		//
		
		uploadUrl: "",
		
	/*=====
		//
		//	button: dijit.form.Button or a domNode
		// 		DEPRECATED: The "fake" button that when clicked, launches the upload dialog
		//
		//	isDebug: Boolean
		//		If true, outputs traces from the SWF to console. What exactly gets passed
		//		is very relative, and depends upon what traces have been left in the DEFT SWF.
		isDebug:false,
		//
		//	devMode: Boolean.
		//		REMOVED - no longer useful with new code design.
		//
		//	id: String
		//		The object id, just like any other widget in Dojo. However, this id
		//		is also used as a reference for the SWF
		//
		//	hoverClass: String
		//		The name of the class that will style the button in a "hover" state. A specific
		//		class should be made to do this. Do not rely on a target like button:hover{...}
		hoverClass:"",
		//
		//	activeClass: String
		//		The name of the class that will style the button in a "press" state. A specific
		//		class should be made to do this. Do not rely on a target like button:active{...}
		activeClass:"",
		//
		//	disabledClass: String
		//		The name of the class that will style the button when its disabled.
		disabledClass:"",
		//
		//	force: String
		//		Use "flash" to always use Flash (and hopefully force the user to download the plugin
		//		if they don't have it). Use "html" to always use the HTML uploader. An empty string
		//		(default) will check for the right version of Flash and use HTML if not available.
		force:"",
		//
		//	uploaderType: [readonly] String
		//		Internal. What type of uploader is being used: "flash" or "html"
		uploaderType:"",
		//
		//	flashObject: [readonly] dojox.embed.Flash 
		//		The object that creates the SWF embed object. Mostly Internal.
		flashObject: null,
		//
		//	flashMovie: [readonly] Function
		//		The SWF. Mostly Internal.
		flashMovie: null,
		//
		//	flashDiv: [readonly] HTMLNode
		//		DEPRECATED for insideNode
		//		The div that holds the SWF and form/fileInput
		flashDiv: null,
		//
		//	insideNode: [readonly] HTMLNode
		//		The div that holds the SWF and form/fileInput
		insideNode: null,
		//
		//	deferredUploading: Boolean
		//		(Flash only) throttles the upload to one file at a time
		deferredUploading:false,
		//
		//	fileListId: String
		//		The id of a dom node to be used as a container for the pending file list.
		fileListId:"",
	=====*/
		//
		//	uploadOnChange: Boolean
		//		If true, uploads imediately after a file has been selected. If false,
		//		waits for upload() to be called.
		uploadOnChange: false,
		
		//	selectMultipleFiles: Boolean
		//		If true and flash mode, multiple files may be selected from the dialog.
		//		If html mode, files are not uploaded until upload() is called. The references
		//		to each file is incremented:uploadedfile0, uploadedfile1, uploadedfile2... etc.
		selectMultipleFiles: true,
		//
		//	htmlFieldName: String
		//		The name of the field of the fileInput that the server is expecting
		htmlFieldName:"uploadedfile",
		//
		//	flashFieldName: String
		//		The name of the field of the flash uploaded files that the server is expecting
		flashFieldName:"flashUploadFiles",
		//
		// fileMask:  Array[ Array[Description, FileTypes], Array[...]...] 
		// 		(an array, or an array of arrays)
		//		Restrict file selection to certain file types
		// 		Empty array defaults to "All Files"
		// example:
		//	fileMask = ["Images", "*.jpg;*.jpeg;*.gif;*.png"]
		//	or
		//	fileMask = [
		//		["Jpeg File", 	"*.jpg;*.jpeg"],
		//		["GIF File", 	"*.gif"],
		//		["PNG File", 	"*.png"],
		//		["All Images", 	"*.jpg;*.jpeg;*.gif;*.png"],
		//	]
		//	NOTE: MacType is not supported, as it does not work very well.
		//			fileMask will work on a Mac, but differently than 
		//			Windows.
		fileMask: [],
		//
		//	minFlashVersion: Number
		//		The minum of version of Flash player to target. 0 would always install Flash, 100
		//		would never install it. The Flash Player has supported multiple uploads since
		//		version 8, so it could go as low as that safely.
		minFlashVersion:9,
		//
		//	tabIndex: Number|String
		//		The tab order in the DOM
		tabIndex:-1,
		//
		//	showProgress: Boolean
		//		If true, the button changes to a progress bar during upload.
		showProgress:false,
		//
		//	progressMessage: String
		//		The message shown while the button is changed to a progress bar
		progressMessage:"Loading",
		//
		//	progressBackgroundUrl: String|Uri
		//		The background image to use for the button-progress
		progressBackgroundUrl:dojo.moduleUrl("dijit", "themes/tundra/images/buttonActive.png"),
		//
		//	progressBackgroundColor: String|Number
		//		The background color to use for the button-progress
		progressBackgroundColor:"#ededed",
		//
		//	progressWidgetId:String
		//		The widget id of a Dijit Progress bar. The Uploader will bind to it and update it
		//		automatically.
		progressWidgetId:"",
		
		templateString:'<div><div dojoAttachPoint="progNode"><div dojoAttachPoint="progTextNode"></div></div><div dojoAttachPoint="insideNode"></div></div>',
		
		log: function(){
			//	summary:
			//		Due to the excessive logging necessary to make this code happen,
			//		It's easier to turn it on and off here in one place.
			//		Also helpful if there are multiple uploaders on one page.
			if(this.isDebug){
				console.log.apply(console, arguments);
			}
		},
		
		postMixInProperties: function(){
			// private stuff:
			this.fileList = [];
			this._subs = [];
			this._cons = [];
			this.fileInputs = [];
			this.fileCount = 0;
			this.flashReady = false;
			this._disabled = false;
			this.uploaderType = ((dojox.embed.Flash.available >= this.minFlashVersion || this.force=="flash") && this.force != "html") ? "flash" : "html";
			
			if(!this.swfPath){
				this.swfPath = swfPath;
			}
			this.getButtonStyle();
		},
		
		postCreate: function(){
			this.setButtonStyle();
			if(this.uploaderType == "flash"){
				this.uploaderType = "flash";
				this.createFlashUploader();
			}else{
				this.uploaderType = "html";
				this.createHtmlUploader();
			}
			
			if(this.fileListId){
				dojo.connect(dojo.byId(this.fileListId), "click", this, function(evt){
					var p = evt.target.parentNode.parentNode.parentNode; // in a table
					if(p.id && p.id.indexOf("file_")>-1){
						this.removeFile(p.id.split("file_")[1]);
					}
				});
			}
			
	//		this._animateProgress();
		},
		
		getButtonStyle: function(){
			// summary:
			//		Internal.
			//		Get necessary style information from srcRefNode and
			//		assigned styles
			//
			if(!this.srcNodeRef && this.button && this.button.domNode){
				// backwards compat for a Dijit button
				this.isDijitButton = true;
				var cls = this.button.domNode.className + " dijitButtonNode";
				var txt = getText(dojo.query(".dijitButtonText", this.button.domNode)[0]);
				var domTxt = '<button id="'+this.button.id+'" class="'+cls+'">'+txt+'</button>';
				this.srcNodeRef = dojo.place(domTxt, this.button.domNode, "after");	
				this.button.destroy();
				
				this.hoverClass = "dijitButtonHover";
				this.pressClass = "dijitButtonActive";
				this.disabledClass = "dijitButtonDisabled";
			}
			
			this.norm = getStyle(this.srcNodeRef);
			this.width = this.norm.w;
			this.height = this.norm.h;
			
			if(this.uploaderType == "flash"){
				if(this.hoverClass){
					this.over = getTempNodeStyle(this.srcNodeRef, this.hoverClass, this.isDijitButton);
				}else{
					this.over = mixin({}, this.norm);
				}
				
				if(this.activeClass){
					this.down = getTempNodeStyle(this.srcNodeRef, this.activeClass, this.isDijitButton);				
				}else{
					this.down = mixin({}, this.norm);
				}
				
				if(this.disabledClass){
					this.dsbl = getTempNodeStyle(this.srcNodeRef, this.disabledClass, this.isDijitButton);				
				}else{
					this.dsbl = mixin({}, this.norm);
				}
				
				this.fhtml = {
					cn:getText(this.srcNodeRef),
					nr:this.norm,
					ov:this.over,
					dn:this.down,
					ds:this.dsbl
				};
			}else{
				this.fhtml = {
					cn:getText(this.srcNodeRef),
					nr:this.norm
				}
			}
			
		},
		
		setButtonStyle: function(){
			// summary:
			//		Internal.
			//		Set up internal dom nodes
			//
			dojo.style(this.domNode, {
				width:this.fhtml.nr.w+"px",
				height:(this.fhtml.nr.h)+"px",
				padding:"0px",
				lineHeight:"normal",
				position:"relative"
			});
			if(this.showProgress){
				this.progTextNode.innerHTML = this.progressMessage;
				dojo.style(this.progTextNode, {
					width:this.fhtml.nr.w+"px",
					height:(this.fhtml.nr.h+0)+"px",
					padding:"0px",
					margin:"0px",
					left:"0px",
					lineHeight:(this.fhtml.nr.h+0)+"px",
					position:"absolute"
				});
				dojo.style(this.progNode, {
					width:this.fhtml.nr.w+"px",
					height:(this.fhtml.nr.h+0)+"px",
					padding:"0px",
					margin:"0px",
					left:"0px",
					position:"absolute",
					display:"none",
					backgroundImage:"url("+this.progressBackgroundUrl+")",
					backgroundPosition:"bottom",
					backgroundRepeat:"repeat-x",
					backgroundColor:this.progressBackgroundColor
				});
			}
			dojo.style(this.insideNode,{
				position:"absolute",
				top:"0px",
				left:"0px",
				display:""
			});
			dojo.addClass(this.domNode, this.srcNodeRef.className);
			if(this.fhtml.nr.d.indexOf("inline")>-1){
				dojo.addClass(this.domNode, "dijitInline");
			}
				
			try{
				this.insideNode.innerHTML = this.fhtml.cn;
			}catch(e){
				// You have got to be kidding me. IE does us he favor of checking that
				//	we aren't inserting the improper type of content with innerHTML into
				//	an inline element. Alert us with an "Unknown Runtime Error". You can't
				//	MAKE this stuff up.
				//
				console.warn("IE inline node", this.domNode.outerHTML)
				if(this.uploaderType == "flash"){
				this.insideNode = this.insideNode.parentNode.removeChild(this.insideNode);
					dojo.body().appendChild(this.insideNode);
					this.insideNode.innerHTML = this.fhtml.cn;
					var c = dojo.connect(this, "onReady", this, function(){ dojo.disconnect(c);
						this.insideNode = this.insideNode.parentNode.removeChild(this.insideNode);
						this.domNode.appendChild(this.insideNode);
					});
				}else{
					this.insideNode.appendChild(document.createTextNode(this.fhtml.cn));
				}
			}
			
			
			this.flashDiv = this.insideNode; //backwards compat - rem in 1.5
		},
		
		
		/*************************
		 *	   Public Events	 *
		 *************************/
		
		// The following events are inherited from _Widget and still may be connected:
		// onClick
		// onMouseUp
		// onMouseDown
		// onMouseOver
		// onMouseOut
		
		onChange: function(dataArray){
			//	summary:
			// 		stub to connect 
			// 		Fires when files are selected
			// 		Event is an array of last files selected
		},
		
		onProgress: function(dataArray){
			// summary:
			// 		Stub to connect 
			// 		Fires as progress returns from SWF
			// 		Event is an array of all files uploading
			//		Can be connected to for HTML uploader,
			//		but will not return anything.
		},
		
		onComplete: function(dataArray){
			// summary
			// stub to connect 
			// Fires when all files have uploaded
			// Event is an array of all files
		},
		
		onCancel: function(){
			// summary:
			// 		Stub to connect 
			// 		Fires when dialog box has been closed 
			//		without a file selection
			this.log("Upload Canceled");
		},
		
		onError: function(evtObject){
			//FIXME: Unsure of a standard form for receiving errors
			var type = evtObject.type ? evtObject.type.toUpperCase() : "ERROR";
			var msg = evtObject.msg ? evtObject.msg : evtObject;
			console.error("FLASH/ERROR/"+type , msg);
		},
		
		onReady: function(){
			// summary:
			//	Stub - when uploader is finished building
		},
		/*************************
		 *	   Public Methods	 *
		 *************************/
		submit: function(/* form node ? */form){
			// summary:
			//		If FileUploader is in a form, and other data should be sent
			//		along with the files, use this instead of form submit.
			//
			var data = form ? dojo.formToObject(form) : null;
			this.upload(data);
			return false; // Boolean
		},
		upload: function(/*Object ? */data){
			// summary:
			// 		When called, begins file upload
			//	data: Object
			//		postData to be sent to server
			if(!this.fileList.length){
				return false;
			}
			if(!this.uploadUrl){
				console.warn("uploadUrl not provided. Aborting.");
				return false;
			}
			if(!this.showProgress){
				this.attr("disabled", true);
			}else{
				//this._progInterval = setTimeout(dojo.hitch(this, "animateLoad"),800);
			}
			
			if(this.progressWidgetId){
				
				var node = dijit.byId(this.progressWidgetId).domNode;
				console.warn("PROGRESS BAR", node, dojo.style(node, "display"));
				if(dojo.style(node, "display") == "none"){
					this.restoreProgDisplay = "none";
					dojo.style(node, "display", "block");
				}
				if(dojo.style(node, "visibility") == "hidden"){
					this.restoreProgDisplay = "hidden";
					dojo.style(node, "visibility", "visible");
				}
			}
			
			if(data){
				this.postData = data;
			}
			this.log("upload type:", this.uploaderType, " - postData:", this.postData);
			
			for (var i=0;i<this.fileList.length;i++){
				var f = this.fileList[i];
				f.bytesLoaded = 0;
				f.bytesTotal = f.size || 100000;
				f.percent = 0;
			}
			if(this.uploaderType == "flash"){
				this.uploadFlash();
			}else{
				this.uploadHTML();
			}
			// prevent form submit
			return false;
		},
		removeFile: function(/*String*/name, /*Boolean*/noListEdit){
			// summary:
			//		Removes a file from the pending file list.
			//		Removes pending data from teh Flash movie
			//		and fileInputes from teh HTML uploader.
			//		If a file container node is bound, the file
			//		will also be removed.
			// name:String
			//		The name of the file to be removed. Typically the file name,
			//		such as: picture01.png
			// noListEdit:Boolean
			//		Internal. If true don't remove files from list.
			//
			var i;
			for(i=0;i<this.fileList.length;i++){
				if(this.fileList[i].name == name){
					if(!noListEdit){ // if onComplete, don't do this
						this.fileList.splice(i,1);
					}
					break;
				}
			}
			if(this.uploaderType == "flash"){
				this.flashMovie.removeFile(name);
			}else if(!noListEdit){
				dojo.destroy(this.fileInputs[i]);
				this.fileInputs.splice(i,1);
			}
			if(this.fileListId){
				dojo.destroy("file_"+name);	
			}
		},
		destroyAll: function(){
			//	summary:
			// 		Destroys button
			console.warn("DEPRECATED for 1.5 - use destroy() instead");
			this.destroy();
		},
		
		destroy: function(){
			//	summary:
			//		Destroys uploader button
			if(this.uploaderType == "flash" && !this.flashMovie){
				this._cons.push(dojo.connect(this, "onLoad", this, "destroy"));
				return;
			}
			dojo.forEach(this._subs, function(s){
				dojo.unsubscribe(s);
			});
			dojo.forEach(this._cons, function(c){
				dojo.disconnect(c);
			});
			if(this.scrollConnect){
				dojo.disconnect(this.scrollConnect);
			}
			if(this.uploaderType == "flash"){
				this.flashObject.destroy();
				dojo.destroy(this.flashDiv);
			}
			this.inherited(arguments);
		},
		hide: function(){
			//	summary:
			//		Hides the upload button.
			console.warn("DEPRECATED for 1.5 - use dojo.style(domNode, 'display', 'none' instead");
			dojo.style(this.domNode, 'display', 'none');
		},
		
		show: function(){
			//	summary:
			//		Shows the upload button. This is called
			//		when within a dialog.
			console.warn("DEPRECATED for 1.5 - use dojo.style(domNode, 'display', '') instead");
			dojo.style(this.domNode, 'display', '');
		},
		disable: function(/*Boolean*/disabled){
			console.warn("DEPRECATED: FileUploader.disable() - will be removed in 1.5. Use attr('disable', true) instead.")
			this.attr("disable", disabled);
		},
		/*************************
		 *	   Private Events	 *
		 *************************/
		_displayProgress: function(/*Boolean or Number */display){
			// summary:
			//		Shows and updates the built-in progress bar.
			//
			if(display === true){
				if(this.uploaderType == "flash"){
					dojo.style(this.insideNode,"left", "-1000px");
				}else{
					dojo.style(this.insideNode,"display", "none");	
				}
				dojo.style(this.progNode,"display","");
			}else if(display === false){
				dojo.style(this.insideNode,"display", "");
				dojo.style(this.insideNode,"left", "0px");
				dojo.style(this.progNode,"display","none");
			}else{
				var w = display * this.fhtml.nr.w;
				dojo.style(this.progNode,{
					width:w+"px"
				});
			}
		},
		_animateProgress: function(){
			// summary:
			//		Internal. Animated the built-in progress bar
			this._displayProgress(true);
			var _uploadDone = false;
			var c = dojo.connect(this, "_complete", function(){
				dojo.disconnect(c);
				_uploadDone = true;
			});
			var w = 0;
			var interval = setInterval(dojo.hitch(this, function(){
				w+=5;
				if(w>this.fhtml.nr.w){
					w = 0;
					_uploadDone = true;
				}
				this._displayProgress(w/this.fhtml.nr.w);
				
				if(_uploadDone){
					clearInterval(interval);
					setTimeout(dojo.hitch(this, function(){
						this._displayProgress(false);
					}), 500);
				}
				
			}),50);
		},
		
		_error: function(evt){
			this.onError(evt);
		},
		
		_addToFileList: function(){
			// summary:
			//		Internal only. If there is a file list, adds a file to it.
			//		If you need to use a function such as this, connect to
			//		onChange and update ourtside of this widget.
			//
			if(this.fileListId){
				var str = '';
				dojo.forEach(this.fileList, function(d){
					// have to use tables because of IE. Grumble.
					str += '<table id="file_'+d.name+'" class="fileToUpload"><tr><td class="fileToUploadClose"></td><td class="fileToUploadName">'+d.name+'</td><td class="fileToUploadSize">'+Math.ceil(d.size*.001)+'kb</td></tr></table>'	
				}, this);
				dojo.byId(this.fileListId).innerHTML = str;
			}
		},
		
		_change: function(dataArray){
			// summary:
			//		Internal. Updates uploader selection
			if(dojo.isIE){
				//IE6 uses the entire path in the name, which isn't terrible, but much different
				// than everything else
				dojo.forEach(dataArray, function(f){
					f.name = f.name.split("\\")[f.name.split("\\").length-1];
				});
			}
			if(this.selectMultipleFiles){
				this.fileList = this.fileList.concat(dataArray);
			}else{
				if(this.fileList[0]){
					this.removeFile(this.fileList[0].name);
				}
				this.fileList = dataArray;
			}
			this._addToFileList();
			this.onChange(dataArray);
			if(this.uploadOnChange){
				this.upload();
			}else if(this.uploaderType == "html" && this.selectMultipleFiles){
				this._buildFileInput();
				this._connectInput();
			}
		},
		
		_complete: function(dataArray){
			// summary:
			//		Internal. Handles tasks after files have finished uploading
			//
			dataArray = dojo.isArray(dataArray) ? dataArray : [dataArray];
			
			// Yes. Yes I do have to do three loops here. ugh.
			//
			// Check if one of the files had an error
			dojo.forEach(dataArray, function(f){
				if(f.ERROR){
					console.error(f.ERROR);
					this._error(new Error(f.ERROR));	
				}
			}, this);
			
			// Have to be set them all too 100%, because
			// onProgress does not always fire
			dojo.forEach(this.fileList, function(f){
				f.bytesLoaded = 1;
				f.bytesTotal = 1;
				f.percent = 100;
				this._progress(f);
			}, this);
			// we're done. remove files.
			dojo.forEach(this.fileList, function(f){
				this.removeFile(f.name, true);
			}, this);
			
			this.onComplete(dataArray);
			
			this.fileList = [];
			this._resetHTML();
			this.attr("disabled", false);
			
			
			if(this.restoreProgDisplay){
				// using timeout so prog shows on screen for at least a short time
				setTimeout(dojo.hitch(this, function(){
					dojo.style(dijit.byId(this.progressWidgetId).domNode,
						this.restoreProgDisplay == "none" ? "display" : "visibility",
						this.restoreProgDisplay
					);
				}), 700);
			}
			
		},
		
		_progress: function(dataObject){
			// summary:
			//		Internal. Calculate progress
			var total = 0;
			var loaded = 0;
			for (var i = 0; i < this.fileList.length; i++){
				var f = this.fileList[i];
				if(f.name == dataObject.name){
					f.bytesLoaded = dataObject.bytesLoaded;
					f.bytesTotal = dataObject.bytesTotal;
					f.percent = Math.ceil(f.bytesLoaded / f.bytesTotal * 100);
					console.info(f.name, "percent:", f.percent)
				} 
				loaded += Math.ceil(.001 * f.bytesLoaded);
				total += Math.ceil(.001 * f.bytesTotal);
			}
			var percent = Math.ceil(loaded / total * 100);
			if(this.progressWidgetId){
				dijit.byId(this.progressWidgetId).update({progress:percent+"%"});
			}
			if(this.showProgress){
				this._displayProgress(percent * .01);
			}
			this.onProgress(this.fileList);
			
		},
		_getDisabledAttr: function(){
			// summary:
			//		Internal. To get disabled use: widget.attr("disabled");
			return this._disabled;
		},
		
		_setDisabledAttr: function(disabled){
			// summary:
			//		Internal. To set disabled use: widget.attr("disabled", true | false);
			if(this._disabled == disabled){ return; }
			
			if(this.uploaderType == "flash"){
				if(!this.flashReady){
					var _fc = dojo.connect(this, "onReady", this, function(){
						dojo.disconnect(_fc);
						this._setDisabledAttr(disabled);
					});
					return;
				}
				this._disabled = disabled;
				this.flashMovie.doDisable(disabled);
				if(disabled){
					dojo.addClass(this.domNode, this.disabledClass);
				}else{
					dojo.removeClass(this.domNode, this.disabledClass);
				}
			}else{
				this._disabled = disabled;
				if(disabled){
					dojo.addClass(this.domNode, this.disabledClass);
					dojo.style(this._fileInput, "display", "none");
				}else{
					dojo.removeClass(this.domNode, this.disabledClass);
					dojo.style(this._fileInput, "display", "");
				}
			}
		},
		_onFlashBlur: function(){
			// summary:
			//		Internal. Detects when Flash movies reliquishes focus.
			//		We have to find all teh tabIndexes in the doc and figure
			//		out whom to gove focus to next.
			this.flashMovie.blur();
			if(!this.nextFocusObject && this.tabIndex){
				var nodes = dojo.query("[tabIndex]");
				for(var i=0;i<nodes.length;i++){
					if(nodes[i].tabIndex >= Number(this.tabIndex)+1){
						this.nextFocusObject = nodes[i];
						break;
					}
				}
			}
			this.nextFocusObject.focus();
		},
		_disconnect: function(){
			// summary:
			//		Internal. Disconnects fileInput in favor of new one.
			dojo.forEach(this._cons, function(c){
				dojo.disconnect(c);
			});
		},
		
		/*************************
		 *			HTML		 *
		 *************************/
		uploadHTML: function(){
			// summary:
			//		Internal. You could use this, but you should use upload() or submit();
			//		which can also handle the post data.
			//
			// NOTE on deferredUploading:
			// This is not enabled for HTML. Workaround would be to force
			//	singleFile uploads.
			//	TODO:
			//	Investigate removing fileInputs and resending form
			//	multiple times adding each fileInput
			//
			dojo.destroy(this._fileInput);
			this._setHtmlPostData();
			if(this.showProgress){
				this._animateProgress();
			}
			dojo.io.iframe.send({
				url: this.uploadUrl,
				form: this._formNode,
				handleAs: "json",
				handle: dojo.hitch(this, function(data, ioArgs, widgetRef){
					this._complete(data);
				})
			}); 
		},
		createHtmlUploader: function(){
			// summary:
			//		Internal. Fires of methods to build HTML Uploader.
			this._buildForm();
			this._setFormStyle();
			this._buildFileInput();
			this._connectInput();
			this._styleContent();
			this.onReady();
		},
		_connectInput: function(){
			// summary:
			//		Internal. HTML Uploader connections. These get disconnected
			//		after upload or if multi upload.
			this._disconnect();
			this._cons.push(dojo.connect(this._fileInput, "mouseover", this, function(evt){
				dojo.addClass(this.domNode, this.hoverClass);
				this.onMouseOver(evt);
			}));
			this._cons.push(dojo.connect(this._fileInput, "mouseout", this, function(evt){
				dojo.removeClass(this.domNode, this.activeClass);
				dojo.removeClass(this.domNode, this.hoverClass);
				this.onMouseOut(evt);
				this._checkHtmlCancel("off");
			}));
			this._cons.push(dojo.connect(this._fileInput, "mousedown", this, function(evt){
				dojo.addClass(this.domNode, this.activeClass);
				dojo.removeClass(this.domNode, this.hoverClass);
				this.onMouseDown(evt);
			}));
			this._cons.push(dojo.connect(this._fileInput, "mouseup", this, function(evt){
				dojo.removeClass(this.domNode, this.activeClass);
				this.onMouseUp(evt);
				this.onClick(evt);
				this._checkHtmlCancel("up");
			}));
			
			this._cons.push(dojo.connect(this._fileInput, "change", this, function(){
				this.log("html change");
				this._checkHtmlCancel("change");
				this._change([{
					name: this._fileInput.value,
					type: "",
					size: 0
				}]);
			}));
			if(this.tabIndex>=0){
				dojo.attr(this.domNode, "tabIndex", this.tabIndex);
			}
		},
		_checkHtmlCancel: function(mouseType){
			// summary:
			//		Internal. Check if the dialog was opened and canceled without file selection.
			if(mouseType == "change"){
				this.dialogIsOpen = false;
			}
			if(mouseType == "up"){
				this.dialogIsOpen = true;
			}
			if(mouseType == "off"){
				if(this.dialogIsOpen){
					this.onCancel();
				}
				this.dialogIsOpen = false;
			}
		},
		_styleContent: function(){
			// summary:
			//		Internal.Apply style to node
			var o = this.fhtml.nr;
			dojo.style(this.insideNode, {
				width:o.w+"px",
				height:o.va == "middle"?o.h+"px":"auto",
				lineHeight:o.va == "middle"?o.h+"px":"auto",
				textAlign:o.ta,
				paddingTop:o.p[0]+"px",
				paddingRight:o.p[1]+"px",
				paddingBottom:o.p[2]+"px",
				paddingLeft:o.p[3]+"px"
			});
		},
		_resetHTML: function(){
			// summary:
			//		Internal. After upload, this is called to clear the form and build a new
			//		fileInput.
			if(this.uploaderType == "html" && this._formNode){
				dojo.query("*", this._formNode).forEach(function(n){
					dojo.destroy(n);
				});
				this.fileCount = 0;
				this._buildFileInput();
				this._connectInput();
			}
		},
		_buildForm: function(){
			// summary:
			//		Build the form that holds the fileInput
			//
			if(this._formNode){ return; }
			
			if(dojo.isIE){
				this._formNode = document.createElement('<form enctype="multipart/form-data" method="post">');
				this._formNode.encoding = "multipart/form-data";
			}else{
				this._formNode = document.createElement('form');
				this._formNode.setAttribute("enctype", "multipart/form-data");
			}
			this._formNode.id = dijit.getUniqueId("FileUploaderForm"); // needed for dynamic style
			this.domNode.appendChild(this._formNode);
		},
		
		_buildFileInput: function(){
			// summary:
			//		Build the fileInput field
			//
			if(this._fileInput){
				this._disconnect();
				// FIXME:
				//	Just hiding it which works, but we lose
				//	reference to it and can't remove it from
				//	the upload list.
				this._fileInput.id = this._fileInput.id + this.fileCount;
				dojo.style(this._fileInput, "display", "none");
			}
			this._fileInput = document.createElement('input');
			this.fileInputs.push(this._fileInput);
			// server will need to know this variable:
			var nm = this.htmlFieldName;
			var _id = this.id;
			if(this.selectMultipleFiles){
				nm += this.fileCount;
				_id += this.fileCount;
				this.fileCount++;
			}
			
			dojo.attr(this._fileInput, {
				id:this.id,
				name:nm,
				type:"file"
			});
			
			dojo.addClass(this._fileInput, "dijitFileInputReal");
			this._formNode.appendChild(this._fileInput);
			var real = dojo.marginBox(this._fileInput);
			dojo.style(this._fileInput, {
				position:"relative",
				left:(this.fhtml.nr.w - real.w) + "px",
				opacity:0
			});
		},
		_setFormStyle: function(){
			// summary:
			//		Apply a dynamic style to the form and input
			var size = Math.max(2, Math.max(Math.ceil(this.fhtml.nr.w / 60), Math.ceil(this.fhtml.nr.h / 15)));
			// Now create a style associated with the form ID
			dojox.html.insertCssRule("#" + this._formNode.id + " input", "font-size:" + size + "em");
			dojo.style(this.domNode, {
				overflow:"hidden",
				position:"relative"
			});
			dojo.style(this.insideNode, "position", "absolute");
		},
		_setHtmlPostData: function(){
			// summary:
			//		Internal.Apply postData to hidden fields in form
			if(this.postData){
				for (var nm in this.postData){
					var f = document.createElement('input');
					dojo.attr(f, "type", "hidden");
					dojo.attr(f, "name", nm);
					dojo.attr(f, "value", this.postData[nm]);
					this._formNode.appendChild(f);
				}
			}
		},
		
		/*************************
		 *			FLASH		 *
		 *************************/
		uploadFlash: function(){
			// summary:
			//		Internal. You should use upload() or submit();
			try{
				if(this.showProgress){
					this._displayProgress(true);
					var c = dojo.connect(this, "_complete", this, function(){
						dojo.disconnect(c);
						this._displayProgress(false);
					});
				}
				this.flashMovie.doUpload(this.postData);
				
			}catch(err){
				throw new Error("Sorry, the SWF failed to initialize." + err);
			}
		},
		createFlashUploader: function(){
			// summary:
			//		Internal. Creates Flash Uploader
			this.uploadUrl = this.uploadUrl.toString();
			if(this.uploadUrl){
				if(this.uploadUrl.toLowerCase().indexOf("http")<0 && this.uploadUrl.indexOf("/")!=0){
					// Appears to be a relative path. Attempt to 
					//	convert it to absolute, so it will better 
					//target the SWF.
					//
					var loc = window.location.href.split("/");
					loc.pop();
					loc = loc.join("/")+"/";
					this.uploadUrl = loc+this.uploadUrl;
					this.log("SWF Fixed - Relative loc:", loc, " abs loc:", this.uploadUrl);
				}
			}else{
				//console.warn("Warning: no uploadUrl provided.");
			}
			var w = this.fhtml.nr.w;
			var h = this.fhtml.nr.h;
			
			var args = {
				expressInstall:true,
				path: this.swfPath.uri || this.swfPath,
				width: w,
				height: h,
				allowScriptAccess:"always",
				allowNetworking:"all",
				vars: {
					uploadDataFieldName: this.flashFieldName,
					uploadUrl: this.uploadUrl,
					uploadOnSelect: this.uploadOnChange,
					deferredUploading:this.deferredUploading,
					selectMultipleFiles: this.selectMultipleFiles,
					id: this.id,
					isDebug: this.isDebug,
					devMode:this.devMode,
					flashButton:dojox.embed.flashVars.serialize("fh", this.fhtml),
					fileMask:dojox.embed.flashVars.serialize("fm", this.fileMask)
				},
				params: {
					scale:"noscale"
				}
				
			};
			
			this.flashObject = new dojox.embed.Flash(args, this.insideNode);
			console.log("start flash...")
			this.flashObject.onError = function(msg){
				console.warn("Flash Error:", msg);
			};
			this.flashObject.onReady = dojo.hitch(this, function(){
				//console.log("READY");
			});
			this.flashObject.onLoad = dojo.hitch(this, function(mov){
				//console.log("ONLOAD")
				this.flashMovie = mov;
				this.flashReady = true;
				this.onReady();
			});
			this._connectFlash();
		},
		_connectFlash: function(){
			// 	summary:
			//		Subscribing to published topics coming from the
			//		Flash uploader.
			// 	description:
			//		Sacrificing some readbilty for compactness. this.id
			//		will be on the beginning of the topic, so more than
			//		one uploader can be on a page and can have unique calls.
			//
			this._doSub("/filesSelected", "_change");
			this._doSub("/filesUploaded", "_complete");
			this._doSub("/filesProgress", "_progress");
			this._doSub("/filesError", "_error");
			this._doSub("/filesCanceled", "onCancel");
			this._doSub("/stageBlur", "_onFlashBlur");
			
			this._doSub("/up", "onMouseUp");
			this._doSub("/down", "onMouseDown");
			this._doSub("/over", "onMouseOver");
			this._doSub("/out", "onMouseOut");
			
			this.connect(this.domNode, "focus", function(){
				// TODO: some kind of indicator that the Flash button
				//	is in focus
				this.flashMovie.focus();
				this.flashMovie.doFocus();
				dojo.connect(document, "keydown", function(evt){
					console.log(evt.keyCode)
				});
			});
			if(this.tabIndex>=0){
				dojo.attr(this.domNode, "tabIndex", this.tabIndex);		
			}
		},
		
		_doSub: function(subStr, funcStr){
			// summary:
			//		Internal. Shortcut for subscribes to Flash movie
			this._subs.push(dojo.subscribe(this.id + subStr, this, funcStr));
		}
		
	});
	
})();

}

if(!dojo._hasResource["dojox.widget.FileInput"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojox.widget.FileInput"] = true;
dojo.provide("dojox.widget.FileInput");
dojo.experimental("dojox.widget.FileInput"); 


 

dojo.declare("dojox.widget.FileInput",
	dijit.form._FormWidget,
	{
	// summary: A styled input type="file"
	//
	// description: A input type="file" form widget, with a button for uploading to be styled via css,
	//	a cancel button to clear selection, and FormWidget mixin to provide standard dijit.form.Form
	//	support (FIXME: maybe not fully implemented) 

	// label: String
	//	the title text of the "Browse" button
	label: "Browse ...",

	// cancelText: String
	//	the title of the "Cancel" button
	cancelText: "Cancel",

	// name: String
	//	ugh, this should be pulled from this.domNode
	name: "uploadFile",

	templateString:"<div class=\"dijitFileInput\">\n\t<input id=\"${id}\" class=\"dijitFileInputReal\" type=\"file\" dojoAttachPoint=\"fileInput\" name=\"${name}\" />\n\t<div class=\"dijitFakeInput\">\n\t\t<input class=\"dijitFileInputVisible\" type=\"text\" dojoAttachPoint=\"focusNode, inputNode\" />\n\t\t<div class=\"dijitInline dijitFileInputText\" dojoAttachPoint=\"titleNode\">${label}</div>\n\t\t<div class=\"dijitInline dijitFileInputButton\" dojoAttachPoint=\"cancelNode\" \n\t\t\tdojoAttachEvent=\"onclick:_onClick\">${cancelText}</div>\n\t</div>\n</div>\n",
	
	startup: function(){
		// summary: listen for changes on our real file input
		this._listener = dojo.connect(this.fileInput,"onchange",this,"_matchValue");
		this._keyListener = dojo.connect(this.fileInput,"onkeyup",this,"_matchValue");
	},

	_matchValue: function(){
		// summary: set the content of the upper input based on the semi-hidden file input
		this.inputNode.value = this.fileInput.value;
		if(this.inputNode.value){
			this.cancelNode.style.visibility = "visible";
			dojo.fadeIn({ node: this.cancelNode, duration:275 }).play();
		}
	},

	setLabel: function(/* String */label,/* String? */cssClass){
		// summary: method to allow use to change button label
		this.titleNode.innerHTML = label;
	},

	_onClick: function(/* Event */e){
		// summary: on click of cancel button, since we can't clear the input because of
		// 	security reasons, we destroy it, and add a new one in it's place.
		dojo.disconnect(this._listener);
		dojo.disconnect(this._keyListener); 
		this.domNode.removeChild(this.fileInput);
		dojo.fadeOut({ node: this.cancelNode, duration:275 }).play(); 

		// should we use cloneNode()? can we?
		this.fileInput = document.createElement('input');
		this.fileInput.setAttribute("type","file");
		this.fileInput.setAttribute("id",this.id);
		this.fileInput.setAttribute("name",this.name);
		dojo.addClass(this.fileInput,"dijitFileInputReal");
		this.domNode.appendChild(this.fileInput);

		this._keyListener = dojo.connect(this.fileInput,"onkeyup",this,"_matchValue");
		this._listener = dojo.connect(this.fileInput,"onchange",this,"_matchValue"); 
		this.inputNode.value = ""; 
	}

});

}

if(!dojo._hasResource["dojox.widget.FileInputAuto"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojox.widget.FileInputAuto"] = true;
dojo.provide("dojox.widget.FileInputAuto");


 

dojo.declare("dojox.widget.FileInputAuto",
	dojox.widget.FileInput,
	{
	// summary: An extension on dojox.widget.FileInput providing background upload progress
	//
	// description: An extended version of FileInput - when the user focuses away from the input
	//	the selected file is posted via dojo.io.iframe to the url. example implementation
	//	comes with PHP solution for handling upload, and returning required data.
	//	
	// notes: the return data from the io.iframe is used to populate the input element with 
	//	data regarding the results. it will be a JSON object, like:
	//	
	//	results = { size: "1024", filename: "file.txt" }
	//	
	//	all the parameters allowed to dojox.widget.FileInput apply

	// url: String
	// 	the URL where our background FileUpload will be sent
	url: "",

	// blurDelay: Integer
	//	time in ms before an un-focused widget will wait before uploading the file to the url="" specified
	//	default: 2 seconds
	blurDelay: 2000,

	// duration: Integer
	//	The time in ms to use as the generic timing mechanism for the animations
	//	set to 1 or 0 for "immediate respose"
	duration: 500,

	// uploadMessage: String
	//	
	//	FIXME: i18n somehow?
	uploadMessage: "Uploading ...", 
	
	_sent: false,

	// small template changes, new attachpoint: overlay
	templateString:"<div class=\"dijitFileInput\">\n\t<input id=\"${id}\" name=\"${name}\" class=\"dijitFileInputReal\" type=\"file\" dojoAttachPoint=\"fileInput\" />\n\t<div class=\"dijitFakeInput\" dojoAttachPoint=\"fakeNodeHolder\">\n\t\t<input class=\"dijitFileInputVisible\" type=\"text\" dojoAttachPoint=\"focusNode, inputNode\" />\n\t\t<div class=\"dijitInline dijitFileInputText\" dojoAttachPoint=\"titleNode\">${label}</div>\n\t\t<div class=\"dijitInline dijitFileInputButton\" dojoAttachPoint=\"cancelNode\" dojoAttachEvent=\"onclick:_onClick\">${cancelText}</div>\n\t</div>\n\t<div class=\"dijitProgressOverlay\" dojoAttachPoint=\"overlay\">&nbsp;</div>\n</div>\n",

	startup: function(){
		// summary: add our extra blur listeners
		this._blurListener = dojo.connect(this.fileInput,"onblur",this,"_onBlur");
		this._focusListener = dojo.connect(this.fileInput,"onfocus",this,"_onFocus"); 
		this.inherited("startup",arguments);
	},

	_onFocus: function(){
		// summary: clear the upload timer
		if(this._blurTimer){ clearTimeout(this._blurTimer); }
	},

	_onBlur: function(){
		// summary: start the upload timer
		if(this._blurTimer){ clearTimeout(this._blurTimer); }
		if(!this._sent){
			this._blurTimer = setTimeout(dojo.hitch(this,"_sendFile"),this.blurDelay);		
		}
	},


	setMessage: function(/*String*/title){
		// summary: set the text of the progressbar
		
		// FIXME: this throws errors in IE?!?!?!? egads.		
		if(!dojo.isIE){ this.overlay.innerHTML = title;	}
	},
	
	_sendFile: function(/* Event */e){
		// summary: triggers the chain of events needed to upload a file in the background.
		if(!this.fileInput.value || this._sent){ return; }
		
		dojo.style(this.fakeNodeHolder,"display","none");
		dojo.style(this.overlay,"opacity","0");
		dojo.style(this.overlay,"display","block");

		this.setMessage(this.uploadMessage);

		dojo.fadeIn({ node: this.overlay, duration:this.duration }).play();

		var _newForm; 
		if(dojo.isIE){
			// just to reiterate, IE is a steaming pile of code. 
			_newForm = document.createElement('<form enctype="multipart/form-data" method="post">');
			_newForm.encoding = "multipart/form-data";
			
		}else{
			// this is how all other sane browsers do it
			_newForm = document.createElement('form');
			_newForm.setAttribute("enctype","multipart/form-data");
		}
		_newForm.appendChild(this.fileInput);
		dojo.body().appendChild(_newForm);
	
		dojo.io.iframe.send({
			url: this.url,
			form: _newForm,
			handleAs: "json",
			handle: dojo.hitch(this,"_handleSend")
		});
	},

	_handleSend: function(data,ioArgs){
		// summary: The callback to toggle the progressbar, and fire the user-defined callback
		if(!dojo.isIE){
			// otherwise, this throws errors in ie? FIXME:
			this.overlay.innerHTML = "";
		}
		
		this._sent = true;
		dojo.style(this.overlay,"opacity","0");
		dojo.style(this.overlay,"border","none");
		dojo.style(this.overlay,"background","none"); 

		this.overlay.style.backgroundImage = "none";
		this.fileInput.style.display = "none";
		this.fakeNodeHolder.style.display = "none";
		dojo.fadeIn({ node:this.overlay, duration:this.duration }).play(250);

		dojo.disconnect(this._blurListener);
		dojo.disconnect(this._focusListener);

		this.onComplete(data,ioArgs,this);
	},

	_onClick: function(e){
		// summary: accomodate our extra focusListeners
		if(this._blurTimer){ clearTimeout(this._blurTimer); }

		dojo.disconnect(this._blurListener);
		dojo.disconnect(this._focusListener);

		this.inherited("_onClick",arguments);

		this._blurListener = dojo.connect(this.fileInput,"onblur",this,"_onBlur");
		this._focusListener = dojo.connect(this.fileInput,"onfocus",this,"_onFocus"); 
	},

	onComplete: function(data,ioArgs,widgetRef){
		// summary: stub function fired when an upload has finished. 
		// data: the raw data found in the first [TEXTAREA] tag of the post url
		// ioArgs: the dojo.Deferred data being passed from the handle: callback
		// widgetRef: this widget pointer, so you can set this.overlay to a completed/error message easily
	}
});

dojo.declare("dojox.widget.FileInputBlind",
	dojox.widget.FileInputAuto,
	{
	// summary: An extended version of dojox.widget.FileInputAuto
	//	that does not display an input node, but rather only a button
	// 	and otherwise behaves just like FileInputAuto
	
	startup: function(){
		// summary: hide our fileInput input field
		this.inherited("startup",arguments);
		this._off = dojo.style(this.inputNode,"width");
		this.inputNode.style.display = "none";
		this._fixPosition();
	},
	
	_fixPosition: function(){		
		// summary: in this case, set the button under where the visible button is 
		if(dojo.isIE){
			dojo.style(this.fileInput,"width","1px");
		}else{
			dojo.style(this.fileInput,"left","-"+(this._off)+"px");
		}
	},

	_onClick: function(e){
		// summary: onclick, we need to reposition our newly created input type="file"
		this.inherited("_onClick",arguments);
		this._fixPosition(); 
	}
});

}

if(!dojo._hasResource["lucid.apps.FileBrowser"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["lucid.apps.FileBrowser"] = true;
dojo.provide("lucid.apps.FileBrowser");







lucid.addDojoCss("dojox/form/resources/FileInput.css");






dojo.declare("lucid.apps.FileBrowser", lucid.apps._App, {
	windows: [],
	init: function(args)
	{
		var cm = dojo.i18n.getLocalization("lucid", "common");
		var app = dojo.i18n.getLocalization("lucid", "apps");
		var places = dojo.i18n.getLocalization("lucid", "places");
		var sys = dojo.i18n.getLocalization("lucid", "system");
		this.win = new lucid.widget.Window({
			title: app["File Browser"],
			iconClass: this.iconClass,
			onClose: dojo.hitch(this, "kill")
		});
		this.fileArea = new lucid.widget.FileArea({path: (args.path || "file://"), region: "center"});
        this.updateTitle(this.fileArea.path);
        this.fileArea.refresh();
		this.pane = new dijit.layout.ContentPane({region: "left", splitter: true, minSize: 120, style: "width: 120px;"});
		var menu = new dijit.Menu({
			style: "width: 100%;"
		});
		dojo.forEach(lucid.config.filesystem.places, function(item){
			var item = new dijit.MenuItem({label: places[item.name] || item.name,
				iconClass: item.icon || "icon-16-places-folder",
				onClick: dojo.hitch(this.fileArea, "setPath", item.path)
			});
			menu.addChild(item);
		}, this);
		this.pane.setContent(menu.domNode);
		this.win.addChild(this.pane);
		this.win.addChild(this.fileArea);
		
		this.pathbar = new dijit.Toolbar({region: "center"});
		this.pathbox = new dijit.form.TextBox({
			style: "width: 90%;",
			value: args.path || "file://"
		});
		dojo.connect(this.fileArea, "onPathChange", this, function(){
			this.pathbox.setValue(this.fileArea.path);
			this.fixUploadPath(this.fileArea.path);
			this.statusbar.attr("label", "&nbsp;");
            this.updateTitle(this.fileArea.path);
		});
		this.pathbar.addChild(this.pathbox);
		this.goButton = new dijit.form.Button({
			label: cm.go,
			onClick: dojo.hitch(this, function(){
				this.fileArea.setPath(this.pathbox.getValue());
			})
		});
		this.pathbar.addChild(this.goButton);
		
		
		this.toolbar = new dijit.Toolbar({region: "top"});
			var button = new dijit.form.Button({
				onClick: dojo.hitch(this.fileArea, function(){
					this.setPath("file://");
				}),
				iconClass: "icon-16-places-user-home",
				label: places.Home
			});
			this.toolbar.addChild(button);
			var button = new dijit.form.Button({
				onClick: dojo.hitch(this.fileArea, this.fileArea.up),
				iconClass: "icon-16-actions-go-up",
				label: cm.up
			});
			this.toolbar.addChild(button);
			var button = new dijit.form.Button({
				onClick: dojo.hitch(this.fileArea, this.fileArea.refresh),
				iconClass: "icon-16-actions-view-refresh",
				label: cm.refresh
			});
			this.toolbar.addChild(button);
			this.quotabutton = new dijit.form.Button({
				onClick: dojo.hitch(this, "quotaNotice"),
				iconClass: "icon-16-devices-drive-harddisk",
				label: sys.quota
			});
			this.toolbar.addChild(this.quotabutton);
            this.makeUploadButton();
			var load = this.loadNode = document.createElement("div");
			dojo.addClass(load, "icon-loading-indicator");
			dojo.style(load, {
				display: "none",
				position: "absolute",
				top: "0px",
				right: "0px",
				margin: "7px"
			});
			this.toolbar.domNode.appendChild(load);
			
			dojo.connect(this.fileArea, "_loadStart", this, function(){
				dojo.style(load, "display", "block");
			});
			dojo.connect(this.fileArea, "_loadEnd", this, function(){
				dojo.style(load, "display", "none");
			});
		
		var bCont = new dijit.layout.BorderContainer({
			region: "top",
			gutters: false,
			style: "height: 42px;"	//This is really fucked up, since themes may use different heights for toolbars.
									//If BorderContainer ever supports more then one widget in one slot, please fix this.
		})
		bCont.addChild(this.toolbar);
		bCont.addChild(this.pathbar);
		this.win.addChild(bCont);
		// Status bar
		this.statusbar = new lucid.widget.StatusBar({region: "bottom"});
		this.win.addChild(this.statusbar);
		this.win.show();
		bCont.startup();
        this.win.resize();
		setTimeout(dojo.hitch(this, "makeUploader"), 1000);
	},
    updateTitle: function(path){
        var folders = path.split("/");
        var text = folders[folders.length-1] || folders[folders.length-2] || path;
        var app = dojo.i18n.getLocalization("lucid", "apps");
        this.win.attr("title", text + " - "+app["File Browser"]);
    },
	quotaNotice: function(){
		var cm = dojo.i18n.getLocalization("lucid", "common");
		var sys = dojo.i18n.getLocalization("lucid", "system");
		if(typeof(this.quotaWin) != "undefined"){ if(!this.quotaWin.closed){ return; } }
		lucid.filesystem.getQuota(this.fileArea.path, dojo.hitch(this, function(values){
			values.total = Math.round(values.total / 1024); values.remaining = Math.round(values.remaining / 1024); values.used = Math.round(values.used / 1024); 
			this.quotaWin = new lucid.widget.Window({
				title: sys.quota,
				resizable: false,
				height: "75px",
				width: "175px"
			});
			this.windows.push(this.quotaWin);
			var content = new dijit.layout.ContentPane({});
			var central = document.createElement("div");
			central.innerHTML = cm.total+": "+values.total+"kb<br>";
			central.innerHTML += cm.used+": "+values.used+"kb<br>";
			central.innerHTML += cm.remaining+": "+values.remaining+"kb";
            // TODO: get a progress bar in here?
			content.setContent(central);
			this.quotaWin.addChild(content);
			this.quotaWin.show();
			this.quotaWin.startup();
		}));
	},
	makeUploader: function(){
	    this.uploader = new dojox.form.FileUploader({
		    button: this.upbutton,
		    degradable: true,
			force: "html",
		    //uploadUrl: lucid.xhr("api.fs.io.upload")+"&path="+encodeURIComponent(this.fileArea.path),
            uploadUrl: lucid.xhr("api.fs.io.upload")+"?path="+encodeURIComponent(this.fileArea.path),
		    uploadOnChange: true,
            selectMultipleFiles: true
		});
		/*
        if(dojox.embed.Flash.available > 9){
            //fix button (workaround)
            this.fixButton();
            dojo.connect(this.uploader, "_connectInput", this, "fixButton");
        }*/
        this.doUploaderConnects();
	},
	
    fixButton: function(){
        var node = this.uploader.fileInputs[0];
        console.log(node);
        setTimeout(dojo.hitch(this, function(){
            var butNode = this.upbutton.domNode;
            var upNode = this.uploader._formNode;
            butNode.appendChild(upNode);
            dojo.style(butNode, "position", "relative");
            var right = node.offsetWidth-butNode.offsetWidth
            dojo.style(node, {
                top: "0px",
                left: "-"+right+"px",
                clip: "rect(0px, "+right-butNode.offsetWidth+"px, "+butNode.offsetHeight+"px, "+right+"px)"
            });
            dojo.style(node.parentNode, {position: "absolute", top: "0px", left: "0px"});
            dojo.query("span.dijitReset.dijitRight.dijitInline", this.upbutton.domNode).style("position", "relative");
        }), 500);
    },

    makeUploadButton: function(){
        if(this.upbutton)
            this.upbutton.destroy();
        var cm = dojo.i18n.getLocalization("lucid", "common");
        this.upbutton = new dijit.form.Button({
			iconClass: "icon-16-actions-mail-send-receive",
			label: cm.upload
		});
		this.toolbar.addChild(this.upbutton);
    },

	fixUploadPath: function(path){
	    var loc = window.location.href.split("/");
		loc.pop();
		loc = loc.join("/")+"/";
        //var newUrl = loc+lucid.xhr("api.fs.io.upload")+"&path="+encodeURIComponent(this.fileArea.path);
        var newUrl = loc+lucid.xhr("api.fs.io.upload")+"?path="+encodeURIComponent(this.fileArea.path);
		this.uploader.uploadUrl = newUrl;
		if(this.uploader.flashObject){
            this.uploader.destroy();
            this.makeUploadButton();
            this.makeUploader();
        }
	},
	
	doUploaderConnects: function(){
		var nls = dojo.i18n.getLocalization("lucid.widget", "filearea");
	    var uploader = this.uploader;
	    dojo.connect(uploader, "onChange", this, function(dataArray){
	       this.statusbar.attr({
	            label: nls.uploading.replace("%s", dataArray.length),
	            showProgress: true
	       });
	       this.statusbar.update({
	            indeterminate: true
	       });
	    });
	    dojo.connect(uploader, "onProgress", this, function(dataArray){
	        var progress = 0;
	        var total = 0;
	        dojo.forEach(dataArray, function(file){
	            progress += file.bytesLoaded;
	            total += file.bytesTotal;
	        });
	        this.statusbar.update({
	            indeterminate: false,
	            progress: progress,
	            maximum: total
	        });
            //workaround
            if(progress >= total) uploader.onComplete([{status: "success"}]);
	    });
	    uploader.onComplete = dojo.hitch(this, function(data){
	        if(data[data.length-1].status == "success"){
	           this.statusbar.attr({
	                label: nls.uploadingComplete,
	                showProgress: false
	           });
	           this.fileArea.refresh();
	        }else{
	           this.statusbar.attr({
	                label: "Error: "+data.details,
	                showProgress: false
	           });
	        }
	    });
        dojo.connect(uploader, "onError", this, function(data){
            this.statusbar.attr({
                label: "Error",
                showProgress: false
            });
        });
	},
	
	kill: function(){
		if(!this.win.closed){ this.win.close(); }
		dojo.forEach(this.windows, function(win){
			if(!win.closed) win.close();
		});
	}
})

}


dojo.i18n._preloadLocalizations("lucid.apps.nls.FileBrowser", ["ROOT","en","en-gb","en-us","es","es-es","fr","fr-fr","xx"]);
